/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos.stageutils;

import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosPrincipal;
import java.util.HashSet;
import java.util.Set;

public class ResolvedKerberosKeytab {
    private String ownerName = null;
    private String ownerAccess = null;
    private String groupName = null;
    private String groupAccess = null;
    private String file = null;
    private Set<ResolvedKerberosPrincipal> principals = new HashSet<ResolvedKerberosPrincipal>();
    private boolean isAmbariServerKeytab = false;
    private boolean mustWriteAmbariJaasFile = false;

    public ResolvedKerberosKeytab(String file, String ownerName, String ownerAccess, String groupName, String groupAccess, Set<ResolvedKerberosPrincipal> principals, boolean isAmbariServerKeytab, boolean writeAmbariJaasFile) {
        this.ownerName = ownerName;
        this.ownerAccess = ownerAccess;
        this.groupName = groupName;
        this.groupAccess = groupAccess;
        this.file = file;
        this.setPrincipals(principals);
        this.isAmbariServerKeytab = isAmbariServerKeytab;
        this.mustWriteAmbariJaasFile = writeAmbariJaasFile;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String name) {
        this.ownerName = name;
    }

    public String getOwnerAccess() {
        return this.ownerAccess;
    }

    public void setOwnerAccess(String access) {
        this.ownerAccess = access;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String name) {
        this.groupName = name;
    }

    public String getGroupAccess() {
        return this.groupAccess;
    }

    public void setGroupAccess(String access) {
        this.groupAccess = access;
    }

    public Set<ResolvedKerberosPrincipal> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Set<ResolvedKerberosPrincipal> principals) {
        this.principals = principals;
        if (principals != null) {
            for (ResolvedKerberosPrincipal principal : this.principals) {
                principal.setResolvedKerberosKeytab(this);
            }
        }
    }

    public void addPrincipal(ResolvedKerberosPrincipal principal) {
        if (!this.principals.contains(principal)) {
            principal.setResolvedKerberosKeytab(this);
            this.principals.add(principal);
        }
    }

    public boolean isAmbariServerKeytab() {
        return this.isAmbariServerKeytab;
    }

    public void setAmbariServerKeytab(boolean isAmbariServerKeytab) {
        this.isAmbariServerKeytab = isAmbariServerKeytab;
    }

    public boolean isMustWriteAmbariJaasFile() {
        return this.mustWriteAmbariJaasFile;
    }

    public void setMustWriteAmbariJaasFile(boolean mustWriteAmbariJaasFile) {
        this.mustWriteAmbariJaasFile = mustWriteAmbariJaasFile;
    }

    public void mergePrincipals(ResolvedKerberosKeytab otherKeytab) {
        for (ResolvedKerberosPrincipal rkp : otherKeytab.getPrincipals()) {
            ResolvedKerberosPrincipal existent = this.findPrincipal(rkp.getHostId(), rkp.getPrincipal(), rkp.getKeytabPath());
            if (existent != null) {
                existent.mergeComponentMapping(rkp);
                continue;
            }
            this.principals.add(rkp);
        }
    }

    private ResolvedKerberosPrincipal findPrincipal(Long hostId, String principal, String keytabPath) {
        for (ResolvedKerberosPrincipal rkp : this.principals) {
            boolean hostIdIsSame = hostId != null && rkp.getHostId() != null ? hostId.equals(rkp.getHostId()) : hostId == null && rkp.getHostId() == null;
            if (!hostIdIsSame || !principal.equals(rkp.getPrincipal()) || !keytabPath.equals(rkp.getKeytabPath())) continue;
            return rkp;
        }
        return null;
    }
}

