/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos.stageutils;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.orm.dao.KerberosKeytabDAO;
import id.onyx.obdp.server.orm.dao.KerberosKeytabPrincipalDAO;
import id.onyx.obdp.server.orm.entities.KerberosKeytabEntity;
import id.onyx.obdp.server.orm.entities.KerberosKeytabPrincipalEntity;
import id.onyx.obdp.server.orm.entities.KerberosPrincipalEntity;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosKeytab;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosPrincipal;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosIdentityDescriptor;
import id.onyx.obdp.server.utils.StageUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.collections4.MapUtils;

@Singleton
public class KerberosKeytabController {
    @Inject
    private KerberosKeytabDAO kerberosKeytabDAO;
    @Inject
    private KerberosKeytabPrincipalDAO kerberosKeytabPrincipalDAO;
    @Inject
    private Clusters clusters;
    private static KerberosHelper kerberosHelper;

    public static void setKerberosHelper(KerberosHelper kerberosHelper) {
        KerberosKeytabController.kerberosHelper = kerberosHelper;
    }

    public ResolvedKerberosKeytab getKeytabByFile(String file) {
        return this.getKeytabByFile(file, true);
    }

    public ResolvedKerberosKeytab getKeytabByFile(String file, boolean resolvePrincipals) {
        return this.fromKeytabEntity(this.kerberosKeytabDAO.find(file), resolvePrincipals, false);
    }

    public Set<ResolvedKerberosKeytab> getAllKeytabs() {
        return this.fromKeytabEntities(this.kerberosKeytabDAO.findAll(), false);
    }

    public Set<ResolvedKerberosKeytab> getFromPrincipal(ResolvedKerberosPrincipal rkp) {
        return this.fromKeytabEntities(this.kerberosKeytabDAO.findByPrincipalAndHost(rkp.getPrincipal(), rkp.getHostId()), false);
    }

    public Set<ResolvedKerberosKeytab> getFromPrincipalExceptServiceMapping(ResolvedKerberosPrincipal rkp) {
        return this.fromKeytabEntities(this.kerberosKeytabDAO.findByPrincipalAndHost(rkp.getPrincipal(), rkp.getHostId()), true);
    }

    private Set<ResolvedKerberosKeytab> getFilteredKeytabs(Map<String, ? extends Collection<String>> serviceComponentFilter, Set<String> hostFilter, Collection<String> identityFilter) {
        if (serviceComponentFilter == null && hostFilter == null && identityFilter == null) {
            return this.getAllKeytabs();
        }
        List<KerberosKeytabPrincipalDAO.KerberosKeytabPrincipalFilter> filters = this.splitServiceFilter(serviceComponentFilter);
        for (KerberosKeytabPrincipalDAO.KerberosKeytabPrincipalFilter filter : filters) {
            filter.setHostNames(hostFilter);
            filter.setPrincipals(identityFilter);
        }
        Set<ResolvedKerberosPrincipal> filteredPrincipals = this.fromPrincipalEntities(this.kerberosKeytabPrincipalDAO.findByFilters(filters), false);
        HashMap<String, ResolvedKerberosKeytab> resultMap = new HashMap<String, ResolvedKerberosKeytab>();
        for (ResolvedKerberosPrincipal principal : filteredPrincipals) {
            if (!resultMap.containsKey(principal.getKeytabPath())) {
                resultMap.put(principal.getKeytabPath(), this.getKeytabByFile(principal.getKeytabPath(), false));
            }
            ResolvedKerberosKeytab keytab = (ResolvedKerberosKeytab)resultMap.get(principal.getKeytabPath());
            keytab.addPrincipal(principal);
        }
        return Sets.newHashSet(resultMap.values());
    }

    public Set<ResolvedKerberosKeytab> getFilteredKeytabs(Collection<KerberosIdentityDescriptor> serviceIdentities, Set<String> hostFilter, Collection<String> identityFilters) {
        Collection<String> enhancedIdentityFilters = this.populateIdentityFilter(identityFilters, serviceIdentities);
        return this.getFilteredKeytabs((Map<String, ? extends Collection<String>>)null, hostFilter, enhancedIdentityFilters);
    }

    private List<KerberosKeytabPrincipalDAO.KerberosKeytabPrincipalFilter> splitServiceFilter(Map<String, ? extends Collection<String>> serviceComponentFilter) {
        if (serviceComponentFilter != null && serviceComponentFilter.size() > 0) {
            HashSet<String> serviceSet = new HashSet<String>();
            HashSet<String> componentSet = new HashSet<String>();
            HashSet<String> serviceOnlySet = new HashSet<String>();
            for (Map.Entry<String, ? extends Collection<String>> entry : serviceComponentFilter.entrySet()) {
                String serviceName = entry.getKey();
                Collection<String> serviceComponents = entry.getValue();
                if (serviceComponents == null || serviceComponents.contains("*")) {
                    serviceOnlySet.add(serviceName);
                    continue;
                }
                serviceSet.add(serviceName);
                componentSet.addAll(serviceComponents);
            }
            ArrayList<KerberosKeytabPrincipalDAO.KerberosKeytabPrincipalFilter> result = new ArrayList<KerberosKeytabPrincipalDAO.KerberosKeytabPrincipalFilter>();
            if (serviceSet.size() > 0) {
                result.add(KerberosKeytabPrincipalDAO.KerberosKeytabPrincipalFilter.createFilter(null, serviceSet, componentSet, null));
            }
            if (serviceOnlySet.size() > 0) {
                result.add(KerberosKeytabPrincipalDAO.KerberosKeytabPrincipalFilter.createFilter(null, serviceOnlySet, null, null));
            }
            if (result.size() > 0) {
                return result;
            }
        }
        return Lists.newArrayList((Object[])new KerberosKeytabPrincipalDAO.KerberosKeytabPrincipalFilter[]{KerberosKeytabPrincipalDAO.KerberosKeytabPrincipalFilter.createEmptyFilter()});
    }

    private ResolvedKerberosKeytab fromKeytabEntity(KerberosKeytabEntity kke, boolean resolvePrincipals, boolean exceptServiceMapping) {
        HashSet<ResolvedKerberosPrincipal> principals = resolvePrincipals ? this.fromPrincipalEntities(kke.getKerberosKeytabPrincipalEntities(), exceptServiceMapping) : new HashSet<ResolvedKerberosPrincipal>();
        return new ResolvedKerberosKeytab(kke.getKeytabPath(), kke.getOwnerName(), kke.getOwnerAccess(), kke.getGroupName(), kke.getGroupAccess(), principals, kke.isAmbariServerKeytab(), kke.isWriteAmbariJaasFile());
    }

    private ResolvedKerberosKeytab fromKeytabEntity(KerberosKeytabEntity kke) {
        return this.fromKeytabEntity(kke, true, false);
    }

    private Set<ResolvedKerberosKeytab> fromKeytabEntities(Collection<KerberosKeytabEntity> keytabEntities, boolean exceptServiceMapping) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (KerberosKeytabEntity kke : keytabEntities) {
            builder.add((Object)this.fromKeytabEntity(kke, true, exceptServiceMapping));
        }
        return builder.build();
    }

    private Set<ResolvedKerberosPrincipal> fromPrincipalEntities(Collection<KerberosKeytabPrincipalEntity> principalEntities, boolean exceptServiceMapping) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (KerberosKeytabPrincipalEntity kkpe : principalEntities) {
            KerberosPrincipalEntity kpe = kkpe.getKerberosPrincipalEntity();
            if (kpe == null) continue;
            ResolvedKerberosPrincipal rkp = new ResolvedKerberosPrincipal(kkpe.getHostId(), kkpe.getHostName(), kkpe.getPrincipalName(), kpe.isService(), kpe.getCachedKeytabPath(), kkpe.getKeytabPath(), exceptServiceMapping ? null : kkpe.getServiceMappingAsMultimap());
            builder.add((Object)rkp);
        }
        return builder.build();
    }

    public Map<String, Collection<String>> adjustServiceComponentFilter(Cluster cluster, boolean includeAmbariAsService, Map<String, ? extends Collection<String>> serviceComponentFilter) throws OBDPException {
        HashMap<String, Collection<String>> adjustedFilter;
        block5: {
            Map<String, Service> installedServices;
            adjustedFilter = new HashMap<String, Collection<String>>();
            Map<String, Service> map = installedServices = cluster == null ? null : cluster.getServices();
            if (includeAmbariAsService) {
                installedServices = installedServices == null ? new HashMap<String, Service>() : new HashMap<String, Service>(installedServices);
                installedServices.put("OBDP", null);
            }
            if (MapUtils.isEmpty(installedServices)) break block5;
            if (serviceComponentFilter != null) {
                for (Map.Entry<String, ? extends Collection<String>> entry : serviceComponentFilter.entrySet()) {
                    String serviceName = entry.getKey();
                    if (!installedServices.containsKey(serviceName)) continue;
                    adjustedFilter.put(serviceName, entry.getValue());
                }
            } else {
                for (String serviceName : installedServices.keySet()) {
                    adjustedFilter.put(serviceName, Collections.singletonList("*"));
                }
            }
        }
        return adjustedFilter;
    }

    public Collection<KerberosIdentityDescriptor> getServiceIdentities(String clusterName, Collection<String> services, @Nullable Map<String, DesiredConfig> desiredConfigs) throws OBDPException {
        ArrayList<KerberosIdentityDescriptor> serviceIdentities = new ArrayList<KerberosIdentityDescriptor>();
        Cluster cluster = this.clusters.getCluster(clusterName);
        if (desiredConfigs == null) {
            desiredConfigs = cluster.getDesiredConfigs();
        }
        KerberosDescriptor kerberosDescriptor = kerberosHelper.getKerberosDescriptor(cluster, false);
        KerberosDescriptor userDescriptor = kerberosHelper.getKerberosDescriptorUpdates(cluster);
        HashMap<String, Map<String, Map<String, String>>> hostConfigurations = new HashMap<String, Map<String, Map<String, String>>>();
        Map<String, Host> hostMap = this.clusters.getHostsForCluster(clusterName);
        HashSet<String> hosts = new HashSet<String>(hostMap.keySet());
        HashMap<String, String> componentHosts = new HashMap<String, String>();
        for (String hostName : hosts) {
            hostConfigurations.put(hostName, kerberosHelper.calculateConfigurations(cluster, hostName, kerberosDescriptor, userDescriptor, false, false, componentHosts, desiredConfigs));
        }
        String ambariServerHostname = StageUtils.getHostName();
        hosts.add(ambariServerHostname);
        for (String service : services) {
            kerberosHelper.getActiveIdentities(clusterName, null, service, null, true, hostConfigurations, kerberosDescriptor, desiredConfigs).values().forEach(serviceIdentities::addAll);
        }
        return serviceIdentities;
    }

    private Collection<String> populateIdentityFilter(Collection<String> identityFilters, Collection<KerberosIdentityDescriptor> serviceIdentities) {
        if (serviceIdentities != null) {
            identityFilters = identityFilters == null ? new HashSet<String>() : identityFilters;
            for (KerberosIdentityDescriptor serviceIdentity : serviceIdentities) {
                if ("obdp-server".equals(serviceIdentity.getName())) continue;
                identityFilters.add(serviceIdentity.getPrincipalDescriptor().getName());
            }
        }
        return identityFilters;
    }
}

