/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.serveraction.AbstractServerAction;
import id.onyx.obdp.server.serveraction.kerberos.AbstractKerberosDataFileReader;
import id.onyx.obdp.server.serveraction.kerberos.KerberosConfigDataFileReaderFactory;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.SecurityType;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateKerberosConfigsServerAction
extends AbstractServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateKerberosConfigsServerAction.class);
    @Inject
    private OBDPManagementController controller;
    @Inject
    private ConfigHelper configHelper;
    @Inject
    private KerberosConfigDataFileReaderFactory kerberosConfigDataFileReaderFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        File dataDirectory;
        CommandReport commandReport = null;
        String clusterName = this.getExecutionCommand().getClusterName();
        Clusters clusters = this.controller.getClusters();
        Cluster cluster = clusters.getCluster(clusterName);
        String authenticatedUserName = UpdateKerberosConfigsServerAction.getCommandParameterValue(this.getCommandParameters(), "authenticated_user_name");
        String dataDirectoryPath = UpdateKerberosConfigsServerAction.getCommandParameterValue(this.getCommandParameters(), "data_directory");
        HashMap<String, Map<String, String>> propertiesToSet = new HashMap<String, Map<String, String>>();
        HashMap<String, Collection<String>> propertiesToRemove = new HashMap<String, Collection<String>>();
        if (dataDirectoryPath != null && (dataDirectory = new File(dataDirectoryPath)).exists()) {
            AbstractKerberosDataFileReader configReader = null;
            HashSet<String> configTypes = new HashSet<String>();
            try {
                HashMap<String, String> clusterEnvProperties;
                String securityEnabled;
                File configFile = new File(dataDirectory, "configs.dat");
                if (configFile.exists()) {
                    configReader = this.kerberosConfigDataFileReaderFactory.createKerberosConfigDataFileReader(configFile);
                    for (Map<String, String> record : configReader) {
                        String configType = record.get("config");
                        String configKey = record.get("key");
                        String configOp = record.get("operation");
                        configTypes.add(configType);
                        if ("REMOVE".equals(configOp)) {
                            this.removeConfigTypeProp(propertiesToRemove, configType, configKey);
                            continue;
                        }
                        String configVal = record.get("value");
                        this.addConfigTypePropVal(propertiesToSet, configType, configKey, configVal);
                    }
                }
                String string = securityEnabled = cluster.getSecurityType() == SecurityType.KERBEROS ? "true" : "false";
                if (!configTypes.contains("cluster-env")) {
                    configTypes.add("cluster-env");
                }
                if ((clusterEnvProperties = (HashMap<String, String>)propertiesToSet.get("cluster-env")) == null) {
                    clusterEnvProperties = new HashMap<String, String>();
                    propertiesToSet.put("cluster-env", clusterEnvProperties);
                }
                clusterEnvProperties.put("security_enabled", securityEnabled);
                String configNote = UpdateKerberosConfigsServerAction.getCommandParameterValue(this.getCommandParameters(), "update_configuration_note");
                if (configNote == null || configNote.isEmpty()) {
                    configNote = cluster.getSecurityType() == SecurityType.KERBEROS ? "Enabling Kerberos" : "Disabling Kerberos";
                }
                this.configHelper.updateBulkConfigType(cluster, cluster.getDesiredStackVersion(), this.controller, configTypes, propertiesToSet, propertiesToRemove, authenticatedUserName, configNote);
            }
            catch (IOException e) {
                String message = "Could not update services configs to enable kerberos";
                this.actionLog.writeStdErr(message);
                LOG.error(message, (Throwable)e);
                commandReport = this.createCommandReport(1, HostRoleStatus.FAILED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
            }
            finally {
                if (configReader != null && !configReader.isClosed()) {
                    try {
                        configReader.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return commandReport == null ? this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr()) : commandReport;
    }

    private static String getCommandParameterValue(Map<String, String> commandParameters, String propertyName) {
        return commandParameters == null || propertyName == null ? null : commandParameters.get(propertyName);
    }

    private void addConfigTypePropVal(HashMap<String, Map<String, String>> configurations, String configType, String prop, String val) {
        Map<String, String> configTypePropsVal = configurations.get(configType);
        if (configTypePropsVal == null) {
            configTypePropsVal = new HashMap<String, String>();
            configurations.put(configType, configTypePropsVal);
        }
        configTypePropsVal.put(prop, val);
        this.actionLog.writeStdOut(String.format("Setting property %s/%s: %s", configType, prop, val == null ? "<null>" : val));
    }

    private void removeConfigTypeProp(HashMap<String, Collection<String>> configurations, String configType, String prop) {
        Collection<String> configTypeProps = configurations.get(configType);
        if (configTypeProps == null) {
            configTypeProps = new HashSet<String>();
            configurations.put(configType, configTypeProps);
        }
        configTypeProps.add(prop);
        this.actionLog.writeStdOut(String.format("Removing property %s/%s", configType, prop));
    }
}

