/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.controller.UpdateConfigurationPolicy;
import id.onyx.obdp.server.serveraction.kerberos.AbstractPrepareKerberosServerAction;
import id.onyx.obdp.server.serveraction.kerberos.KerberosServerAction;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.kerberos.KerberosComponentDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosIdentityDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareKerberosIdentitiesServerAction
extends AbstractPrepareKerberosServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(PrepareKerberosIdentitiesServerAction.class);

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        Cluster cluster = this.getCluster();
        if (cluster == null) {
            throw new OBDPException("Missing cluster object");
        }
        KerberosHelper kerberosHelper = this.getKerberosHelper();
        KerberosDescriptor kerberosDescriptor = this.getKerberosDescriptor(cluster, false);
        Map<String, String> commandParameters = this.getCommandParameters();
        KerberosServerAction.OperationType operationType = PrepareKerberosIdentitiesServerAction.getOperationType(this.getCommandParameters());
        Map<String, Collection<String>> serviceComponentFilter = this.getServiceComponentFilter();
        Set<String> hostFilter = this.getHostFilter();
        Collection<String> identityFilter = this.getIdentityFilter();
        List<ServiceComponentHost> schToProcess = kerberosHelper.getServiceComponentHostsToProcess(cluster, kerberosDescriptor, operationType == KerberosServerAction.OperationType.DEFAULT ? serviceComponentFilter : null, hostFilter);
        String dataDirectory = PrepareKerberosIdentitiesServerAction.getCommandParameterValue(commandParameters, "data_directory");
        HashMap<String, Map<String, String>> kerberosConfigurations = new HashMap<String, Map<String, String>>();
        int schCount = schToProcess.size();
        if (schCount == 0) {
            this.actionLog.writeStdOut("There are no components to process");
        } else if (schCount == 1) {
            this.actionLog.writeStdOut(String.format("Processing %d component", schCount));
        } else {
            this.actionLog.writeStdOut(String.format("Processing %d components", schCount));
        }
        Set<String> services = cluster.getServices().keySet();
        HashMap<String, Set<String>> propertiesToRemove = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> propertiesToIgnore = new HashMap<String, Set<String>>();
        boolean includeAmbariIdentity = "true".equalsIgnoreCase(PrepareKerberosIdentitiesServerAction.getCommandParameterValue(commandParameters, "include_ambari_identity"));
        includeAmbariIdentity &= hostFilter == null;
        if (serviceComponentFilter != null) {
            includeAmbariIdentity &= serviceComponentFilter.get(RootService.OBDP.name()) != null && serviceComponentFilter.get(RootService.OBDP.name()).contains(RootComponent.OBDP_SERVER.name());
            if (operationType != KerberosServerAction.OperationType.DEFAULT) {
                identityFilter = this.updateIdentityFilter(kerberosDescriptor, identityFilter, serviceComponentFilter);
            }
        }
        Map<String, Map<String, String>> configurations = kerberosHelper.calculateConfigurations(cluster, null, kerberosDescriptor, false, false, null);
        this.processServiceComponentHosts(cluster, kerberosDescriptor, schToProcess, identityFilter, dataDirectory, configurations, kerberosConfigurations, includeAmbariIdentity, propertiesToIgnore);
        UpdateConfigurationPolicy updateConfigurationPolicy = PrepareKerberosIdentitiesServerAction.getUpdateConfigurationPolicy(commandParameters);
        if (updateConfigurationPolicy != UpdateConfigurationPolicy.NONE) {
            if (updateConfigurationPolicy.invokeStackAdvisor()) {
                kerberosHelper.applyStackAdvisorUpdates(cluster, services, configurations, kerberosConfigurations, propertiesToIgnore, propertiesToRemove, true);
            }
            Map<String, Map<String, String>> calculatedConfigurations = kerberosHelper.calculateConfigurations(cluster, null, kerberosDescriptor, false, false, null);
            if (updateConfigurationPolicy.applyIdentityChanges()) {
                this.processAuthToLocalRules(cluster, calculatedConfigurations, kerberosDescriptor, schToProcess, kerberosConfigurations, PrepareKerberosIdentitiesServerAction.getDefaultRealm(commandParameters), false);
            }
            this.processConfigurationChanges(dataDirectory, kerberosConfigurations, propertiesToRemove, kerberosDescriptor, updateConfigurationPolicy);
        }
        return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
    }

    protected KerberosDescriptor getKerberosDescriptor(Cluster cluster, boolean includePreconfigureData) throws OBDPException {
        return this.getKerberosHelper().getKerberosDescriptor(cluster, includePreconfigureData);
    }

    void processAuthToLocalRules(Cluster cluster, Map<String, Map<String, String>> calculatedConfiguration, KerberosDescriptor kerberosDescriptor, List<ServiceComponentHost> schToProcess, Map<String, Map<String, String>> kerberosConfigurations, String defaultRealm, boolean includePreconfiguredData) throws OBDPException {
        if (!schToProcess.isEmpty()) {
            this.actionLog.writeStdOut("Creating auth-to-local rules");
            HashMap<String, Set<String>> services = new HashMap<String, Set<String>>();
            for (ServiceComponentHost sch : schToProcess) {
                HashSet<String> components = (HashSet<String>)services.get(sch.getServiceName());
                if (components == null) {
                    components = new HashSet<String>();
                    services.put(sch.getServiceName(), components);
                }
                components.add(sch.getServiceComponentName());
            }
            KerberosHelper kerberosHelper = this.getKerberosHelper();
            kerberosHelper.setAuthToLocalRules(cluster, kerberosDescriptor, defaultRealm, services, calculatedConfiguration, kerberosConfigurations, includePreconfiguredData);
        }
    }

    private Collection<String> updateIdentityFilter(KerberosDescriptor kerberosDescriptor, Collection<String> identityFilter, Map<String, ? extends Collection<String>> serviceComponentFilter) {
        HashSet<String> updatedFilter = identityFilter == null ? new HashSet<String>() : new HashSet<String>(identityFilter);
        Map<String, KerberosServiceDescriptor> serviceDescriptors = kerberosDescriptor.getServices();
        if (serviceDescriptors != null) {
            for (KerberosServiceDescriptor serviceDescriptor : serviceDescriptors.values()) {
                Map<String, KerberosComponentDescriptor> componentDescriptors;
                boolean anyComponent;
                String serviceName = serviceDescriptor.getName();
                if (!serviceComponentFilter.containsKey("*") && !serviceComponentFilter.containsKey(serviceName)) continue;
                Collection<String> componentFilter = serviceComponentFilter.get(serviceName);
                boolean bl = anyComponent = componentFilter == null || componentFilter.contains("*");
                if (anyComponent) {
                    this.addIdentitiesToFilter(serviceDescriptor.getIdentities(), updatedFilter, true);
                }
                if ((componentDescriptors = serviceDescriptor.getComponents()) == null) continue;
                for (KerberosComponentDescriptor componentDescriptor : componentDescriptors.values()) {
                    String componentName = componentDescriptor.getName();
                    if (!anyComponent && !componentFilter.contains(componentName)) continue;
                    this.addIdentitiesToFilter(componentDescriptor.getIdentities(), updatedFilter, true);
                }
            }
        }
        return updatedFilter;
    }

    private void addIdentitiesToFilter(List<KerberosIdentityDescriptor> identityDescriptors, Collection<String> identityFilter, boolean skipReferences) {
        if (!CollectionUtils.isEmpty(identityDescriptors)) {
            for (KerberosIdentityDescriptor identityDescriptor : identityDescriptors) {
                String identityPath;
                if (skipReferences && identityDescriptor.isReference() || StringUtils.isEmpty((String)(identityPath = identityDescriptor.getPath()))) continue;
                identityFilter.add(identityPath);
                this.addIdentitiesToFilter(identityDescriptor.findReferences(), identityFilter, false);
            }
        }
    }
}

