/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.PreconfigureServiceType;
import id.onyx.obdp.server.serveraction.kerberos.PrepareKerberosIdentitiesServerAction;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosPrincipal;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareEnableKerberosServerAction
extends PrepareKerberosIdentitiesServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(PrepareEnableKerberosServerAction.class);

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        Map<String, KerberosServiceDescriptor> serviceDescriptors;
        Cluster cluster = this.getCluster();
        if (cluster == null) {
            throw new OBDPException("Missing cluster object");
        }
        Map<String, String> commandParameters = this.getCommandParameters();
        PreconfigureServiceType type = this.getCommandPreconfigureType();
        KerberosDescriptor kerberosDescriptor = this.getKerberosDescriptor(cluster, type != PreconfigureServiceType.NONE);
        if (type == PreconfigureServiceType.ALL && (serviceDescriptors = kerberosDescriptor.getServices()) != null) {
            for (KerberosServiceDescriptor serviceDescriptor : serviceDescriptors.values()) {
                serviceDescriptor.setPreconfigure(true);
            }
        }
        KerberosHelper kerberosHelper = this.getKerberosHelper();
        Map<String, Collection<String>> serviceComponentFilter = this.getServiceComponentFilter();
        Set<String> hostFilter = this.getHostFilter();
        Collection<String> identityFilter = this.getIdentityFilter();
        List<ServiceComponentHost> schToProcess = kerberosHelper.getServiceComponentHostsToProcess(cluster, kerberosDescriptor, serviceComponentFilter, hostFilter);
        String dataDirectory = PrepareEnableKerberosServerAction.getCommandParameterValue(commandParameters, "data_directory");
        Map<String, Map<String, String>> kerberosConfigurations = new HashMap<String, Map<String, String>>();
        int schCount = schToProcess.size();
        if (schCount == 0) {
            this.actionLog.writeStdOut("There are no components to process");
        } else if (schCount == 1) {
            this.actionLog.writeStdOut(String.format("Processing %d component", schCount));
        } else {
            this.actionLog.writeStdOut(String.format("Processing %d components", schCount));
        }
        HashMap<String, Set<String>> propertiesToRemove = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> propertiesToIgnore = new HashMap<String, Set<String>>();
        Set<String> services = cluster.getServices().keySet();
        Map<String, Map<String, String>> configurations = kerberosHelper.calculateConfigurations(cluster, null, kerberosDescriptor, false, false, null);
        this.processServiceComponentHosts(cluster, kerberosDescriptor, schToProcess, identityFilter, dataDirectory, configurations, kerberosConfigurations, true, propertiesToIgnore);
        kerberosConfigurations = kerberosHelper.processPreconfiguredServiceConfigurations(kerberosConfigurations, configurations, cluster, kerberosDescriptor);
        kerberosHelper.applyStackAdvisorUpdates(cluster, services, configurations, kerberosConfigurations, propertiesToIgnore, propertiesToRemove, true);
        this.processAuthToLocalRules(cluster, configurations, kerberosDescriptor, schToProcess, kerberosConfigurations, PrepareEnableKerberosServerAction.getDefaultRealm(commandParameters), true);
        Map<String, String> clusterEnvProperties = kerberosConfigurations.get("cluster-env");
        if (clusterEnvProperties == null) {
            clusterEnvProperties = new HashMap<String, String>();
            kerberosConfigurations.put("cluster-env", clusterEnvProperties);
        }
        clusterEnvProperties.put("security_enabled", "true");
        this.processConfigurationChanges(dataDirectory, kerberosConfigurations, propertiesToRemove, kerberosDescriptor, PrepareEnableKerberosServerAction.getUpdateConfigurationPolicy(commandParameters));
        return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
    }

    @Override
    protected CommandReport processIdentity(ResolvedKerberosPrincipal resolvedPrincipal, KerberosOperationHandler operationHandler, Map<String, String> kerberosConfiguration, boolean includedInFilter, Map<String, Object> requestSharedDataContext) throws OBDPException {
        throw new UnsupportedOperationException();
    }
}

