/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.serveraction.kerberos.AbstractPrepareKerberosServerAction;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareDisableKerberosServerAction
extends AbstractPrepareKerberosServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(PrepareDisableKerberosServerAction.class);
    @Inject
    private ConfigHelper configHelper;

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        Cluster cluster = this.getCluster();
        if (cluster == null) {
            throw new OBDPException("Missing cluster object");
        }
        KerberosHelper kerberosHelper = this.getKerberosHelper();
        KerberosDescriptor kerberosDescriptor = kerberosHelper.getKerberosDescriptor(cluster, false);
        Collection<String> identityFilter = this.getIdentityFilter();
        List<ServiceComponentHost> schToProcess = kerberosHelper.getServiceComponentHostsToProcess(cluster, kerberosDescriptor, this.getServiceComponentFilter(), null);
        HashMap<String, Map<String, String>> kerberosConfigurations = new HashMap<String, Map<String, String>>();
        Map<String, String> commandParameters = this.getCommandParameters();
        String dataDirectory = PrepareDisableKerberosServerAction.getCommandParameterValue(commandParameters, "data_directory");
        int schCount = schToProcess.size();
        if (schCount == 0) {
            this.actionLog.writeStdOut("There are no components to process");
        } else if (schCount == 1) {
            this.actionLog.writeStdOut(String.format("Processing %d component", schCount));
        } else {
            this.actionLog.writeStdOut(String.format("Processing %d components", schCount));
        }
        Set<String> services = cluster.getServices().keySet();
        boolean includeAmbariIdentity = "true".equalsIgnoreCase(PrepareDisableKerberosServerAction.getCommandParameterValue(commandParameters, "include_ambari_identity"));
        HashMap<String, Set<String>> propertiesToIgnore = new HashMap<String, Set<String>>();
        Map<String, Map<String, String>> configurations = kerberosHelper.calculateConfigurations(cluster, null, kerberosDescriptor, false, false, null);
        this.processServiceComponentHosts(cluster, kerberosDescriptor, schToProcess, identityFilter, dataDirectory, configurations, kerberosConfigurations, includeAmbariIdentity, propertiesToIgnore);
        Map<String, Set<String>> authToLocalProperties = kerberosHelper.translateConfigurationSpecifications(kerberosDescriptor.getAllAuthToLocalProperties());
        if (authToLocalProperties != null) {
            for (Map.Entry<String, Set<String>> entry : authToLocalProperties.entrySet()) {
                String configType = entry.getKey();
                Set<String> set = entry.getValue();
                if (CollectionUtils.isEmpty(set)) continue;
                for (String propertyName : set) {
                    Map configuration = (Map)kerberosConfigurations.get(configType);
                    if (configuration == null) continue;
                    configuration.put(propertyName, "DEFAULT");
                }
            }
        }
        this.actionLog.writeStdOut("Determining configuration changes");
        HashMap<String, String> clusterEnvProperties = (HashMap<String, String>)kerberosConfigurations.get("cluster-env");
        if (clusterEnvProperties == null) {
            clusterEnvProperties = new HashMap<String, String>();
            kerberosConfigurations.put("cluster-env", clusterEnvProperties);
        }
        clusterEnvProperties.put("security_enabled", "false");
        if (!kerberosConfigurations.isEmpty()) {
            if (dataDirectory == null) {
                String message = "The data directory has not been set.  Generated data can not be stored.";
                LOG.error(message);
                throw new OBDPException(message);
            }
            HashMap<String, Set<String>> configurationsToRemove = new HashMap<String, Set<String>>();
            for (Map.Entry entry : kerberosConfigurations.entrySet()) {
                configurationsToRemove.put((String)entry.getKey(), new HashSet(((Map)entry.getValue()).keySet()));
            }
            configurationsToRemove.remove("cluster-env");
            if (!schToProcess.isEmpty()) {
                HashSet<String> visitedServices = new HashSet<String>();
                for (ServiceComponentHost sch : schToProcess) {
                    Set<PropertyInfo> serviceProperties;
                    String serviceName = sch.getServiceName();
                    if (visitedServices.contains(serviceName)) continue;
                    ServiceComponent serviceComponent = sch.getServiceComponent();
                    StackId stackVersion = serviceComponent.getDesiredStackId();
                    visitedServices.add(serviceName);
                    if (stackVersion == null || (serviceProperties = this.configHelper.getServiceProperties(stackVersion, serviceName, true)) == null) continue;
                    for (PropertyInfo propertyInfo : serviceProperties) {
                        Collection propertiesToRemove;
                        String filename = propertyInfo.getFilename();
                        if (filename == null) continue;
                        String type = ConfigHelper.fileNameToConfigType(filename);
                        String propertyName = propertyInfo.getName();
                        Map kerberosConfiguration = (Map)kerberosConfigurations.get(type);
                        if (kerberosConfiguration != null && kerberosConfiguration.containsKey(propertyName)) {
                            kerberosConfiguration.put(propertyName, propertyInfo.getValue());
                        }
                        if ((propertiesToRemove = (Collection)configurationsToRemove.get(type)) == null) continue;
                        propertiesToRemove.remove(propertyName);
                    }
                }
            }
            kerberosHelper.applyStackAdvisorUpdates(cluster, services, configurations, kerberosConfigurations, propertiesToIgnore, configurationsToRemove, false);
            this.processConfigurationChanges(dataDirectory, kerberosConfigurations, configurationsToRemove, kerberosDescriptor, PrepareDisableKerberosServerAction.getUpdateConfigurationPolicy(commandParameters));
        }
        return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
    }

    @Override
    protected boolean pruneServiceFilter() {
        return false;
    }
}

