/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import com.google.inject.Inject;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.security.credential.PrincipalKeyCredential;
import id.onyx.obdp.server.serveraction.kerberos.KDCKerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.KerberosAdminAuthenticationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosKDCConnectionException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosPrincipalAlreadyExistsException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosRealmException;
import id.onyx.obdp.server.state.kerberos.VariableReplacementHelper;
import id.onyx.obdp.server.utils.ShellCommandUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MITKerberosOperationHandler
extends KDCKerberosOperationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MITKerberosOperationHandler.class);
    @Inject
    private Configuration configuration;
    @Inject
    private VariableReplacementHelper variableReplacementHelper;
    private String createAttributes = null;
    private String executableKadmin = null;

    @Override
    public void open(PrincipalKeyCredential administratorCredentials, String realm, Map<String, String> kerberosConfiguration) throws KerberosOperationException {
        if (kerberosConfiguration != null) {
            this.createAttributes = kerberosConfiguration.get("kdc_create_attributes");
        }
        this.executableKadmin = this.getExecutable("kadmin");
        super.open(administratorCredentials, realm, kerberosConfiguration);
    }

    @Override
    public void close() throws KerberosOperationException {
        this.createAttributes = null;
        this.executableKadmin = null;
        super.close();
    }

    @Override
    public boolean principalExists(String principal, boolean service) throws KerberosOperationException {
        if (!this.isOpen()) {
            throw new KerberosOperationException("This operation handler has not been opened");
        }
        if (!StringUtils.isEmpty((String)principal)) {
            ShellCommandUtil.Result result = this.invokeKAdmin(String.format("get_principal %s", principal));
            String stdOut = result.getStdout();
            return stdOut != null && stdOut.contains(String.format("Principal: %s", principal));
        }
        return false;
    }

    @Override
    public Integer createPrincipal(String principal, String password, boolean service) throws KerberosOperationException {
        if (!this.isOpen()) {
            throw new KerberosOperationException("This operation handler has not been opened");
        }
        if (StringUtils.isEmpty((String)principal)) {
            throw new KerberosOperationException("Failed to create new principal - no principal specified");
        }
        ShellCommandUtil.Result result = this.invokeKAdmin(String.format("add_principal -randkey %s %s", this.createAttributes == null ? "" : this.createAttributes, principal));
        String stdOut = result.getStdout();
        String stdErr = result.getStderr();
        if (stdOut != null && stdOut.contains(String.format("Principal \"%s\" created", principal))) {
            return 0;
        }
        if (stdErr != null && stdErr.contains(String.format("Principal or policy already exists while creating \"%s\"", principal))) {
            throw new KerberosPrincipalAlreadyExistsException(principal);
        }
        LOG.error("Failed to execute kadmin query: add_principal -pw \"********\" {} {}\nSTDOUT: {}\nSTDERR: {}", new Object[]{this.createAttributes == null ? "" : this.createAttributes, principal, stdOut, result.getStderr()});
        throw new KerberosOperationException(String.format("Failed to create service principal for %s\nSTDOUT: %s\nSTDERR: %s", principal, stdOut, result.getStderr()));
    }

    @Override
    public boolean removePrincipal(String principal, boolean service) throws KerberosOperationException {
        if (!this.isOpen()) {
            throw new KerberosOperationException("This operation handler has not been opened");
        }
        if (StringUtils.isEmpty((String)principal)) {
            throw new KerberosOperationException("Failed to remove principal - no principal specified");
        }
        ShellCommandUtil.Result result = this.invokeKAdmin(String.format("delete_principal -force %s", principal));
        String stdOut = result.getStdout();
        return stdOut != null && !stdOut.contains("Principal does not exist");
    }

    protected ShellCommandUtil.Result invokeKAdmin(String query) throws KerberosOperationException {
        String defaultRealm;
        String adminSeverHost;
        if (StringUtils.isEmpty((String)query)) {
            throw new KerberosOperationException("Missing kadmin query");
        }
        if (StringUtils.isEmpty((String)this.executableKadmin)) {
            throw new KerberosOperationException("No path for kadmin is available - this KerberosOperationHandler may not have been opened.");
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.executableKadmin);
        String credentialCacheFilePath = this.getCredentialCacheFilePath();
        if (!StringUtils.isEmpty((String)credentialCacheFilePath)) {
            command.add("-c");
            command.add(credentialCacheFilePath);
        }
        if (!StringUtils.isEmpty((String)(adminSeverHost = this.getAdminServerHost(true)))) {
            command.add("-s");
            command.add(adminSeverHost);
        }
        if (!StringUtils.isEmpty((String)(defaultRealm = this.getDefaultRealm()))) {
            command.add("-r");
            command.add(defaultRealm);
        }
        command.add("-q");
        command.add(query);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing: {}", command);
        }
        ShellCommandUtil.Result result = null;
        int retryCount = this.configuration.getKerberosOperationRetries();
        int tries = 0;
        while (tries <= retryCount) {
            block19: {
                try {
                    result = this.executeCommand(command.toArray(new String[command.size()]));
                }
                catch (KerberosOperationException exception) {
                    if (tries != retryCount) break block19;
                    throw exception;
                }
            }
            if (result != null && result.isSuccessful()) break;
            ++tries;
            try {
                Thread.sleep(1000 * this.configuration.getKerberosOperationRetryTimeout());
            }
            catch (InterruptedException exception) {
                // empty catch block
            }
            String message = String.format("Retrying to execute kadmin after a wait of %d seconds :\n\tCommand: %s", this.configuration.getKerberosOperationRetryTimeout(), command);
            LOG.warn(message);
        }
        if (result == null || !result.isSuccessful()) {
            int exitCode = result == null ? -999 : result.getExitCode();
            String stdOut = result == null ? "" : result.getStdout();
            String stdErr = result == null ? "" : result.getStderr();
            String message = String.format("Failed to execute kadmin:\n\tCommand: %s\n\tExitCode: %s\n\tSTDOUT: %s\n\tSTDERR: %s", command, exitCode, stdOut, stdErr);
            LOG.warn(message);
            if (stdErr.contains("Client not found in Kerberos database")) {
                throw new KerberosAdminAuthenticationException(stdErr);
            }
            if (stdErr.contains("Incorrect password while initializing")) {
                throw new KerberosAdminAuthenticationException(stdErr);
            }
            if (stdErr.contains("Cannot contact any KDC")) {
                throw new KerberosKDCConnectionException(stdErr);
            }
            if (stdErr.contains("Cannot resolve network address for admin server in requested realm while initializing kadmin interface")) {
                throw new KerberosKDCConnectionException(stdErr);
            }
            if (stdErr.contains("Missing parameters in krb5.conf required for kadmin client")) {
                throw new KerberosRealmException(stdErr);
            }
            if (stdErr.contains("Cannot find KDC for requested realm while initializing kadmin interface")) {
                throw new KerberosRealmException(stdErr);
            }
            throw new KerberosOperationException(String.format("Unexpected error condition executing the kadmin command. STDERR: %s", stdErr));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executed the following command:\n{}\nSTDOUT: {}\nSTDERR: {}", new Object[]{StringUtils.join(command, (String)" "), result.getStdout(), result.getStderr()});
        }
        return result;
    }

    @Override
    protected String[] getKinitCommand(String executableKinit, PrincipalKeyCredential credentials, String credentialsCache, Map<String, String> kerberosConfiguration) throws KerberosOperationException {
        String[] command;
        String kadminPrincipalName = this.variableReplacementHelper.replaceVariables(kerberosConfiguration.get("kadmin_principal_name"), this.buildReplacementsMap(kerberosConfiguration));
        if (kadminPrincipalName == null) {
            kadminPrincipalName = String.format("kadmin/%s", this.getAdminServerHost(false));
        }
        if (Arrays.asList(command = new String[]{executableKinit, "-c", credentialsCache, "-S", kadminPrincipalName, credentials.getPrincipal()}).contains(null)) {
            throw new KerberosOperationException("Got a null value, can not create 'kinit' command");
        }
        return command;
    }

    private Map<String, Map<String, String>> buildReplacementsMap(Map<String, String> kerberosConfiguration) {
        HashMap<String, Map<String, String>> replacementsMap = new HashMap<String, Map<String, String>>();
        replacementsMap.put("", kerberosConfiguration);
        return replacementsMap;
    }

    @Override
    protected void exportKeytabFile(String principal, String keytabFileDestinationPath, Set<EncryptionType> keyEncryptionTypes) throws KerberosOperationException {
        String query;
        ShellCommandUtil.Result result;
        String encryptionTypeSpec = null;
        if (!CollectionUtils.isEmpty(keyEncryptionTypes)) {
            StringBuilder encryptionTypeSpecBuilder = new StringBuilder();
            for (EncryptionType encryptionType : keyEncryptionTypes) {
                if (encryptionTypeSpecBuilder.length() > 0) {
                    encryptionTypeSpecBuilder.append(',');
                }
                encryptionTypeSpecBuilder.append(encryptionType.getName());
                encryptionTypeSpecBuilder.append(":normal");
            }
            encryptionTypeSpec = encryptionTypeSpecBuilder.toString();
        }
        if (!(result = this.invokeKAdmin(query = StringUtils.isEmpty(encryptionTypeSpec) ? String.format("xst -k \"%s\" %s", keytabFileDestinationPath, principal) : String.format("xst -k \"%s\" -e %s %s", keytabFileDestinationPath, encryptionTypeSpec, principal))).isSuccessful()) {
            String message = String.format("Failed to export the keytab file for %s:\n\tExitCode: %s\n\tSTDOUT: %s\n\tSTDERR: %s", principal, result.getExitCode(), result.getStdout(), result.getStderr());
            LOG.warn(message);
            throw new KerberosOperationException(message);
        }
    }
}

