/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.OBDPRuntimeException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.agent.ExecutionCommand;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.UpdateConfigurationPolicy;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.security.credential.PrincipalKeyCredential;
import id.onyx.obdp.server.serveraction.AbstractServerAction;
import id.onyx.obdp.server.serveraction.kerberos.KDCType;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandlerFactory;
import id.onyx.obdp.server.serveraction.kerberos.PreconfigureServiceType;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.KerberosKeytabController;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosPrincipal;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.kerberos.KerberosIdentityDescriptor;
import id.onyx.obdp.server.utils.StageUtils;
import id.onyx.obdp.server.utils.ThreadPools;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KerberosServerAction
extends AbstractServerAction {
    public static final String AUTHENTICATED_USER_NAME = "authenticated_user_name";
    public static final String DATA_DIRECTORY = "data_directory";
    public static final String DEFAULT_REALM = "default_realm";
    public static final String SERVICE_COMPONENT_FILTER = "service_component_filter";
    public static final String HOST_FILTER = "host_filter";
    public static final String IDENTITY_FILTER = "identity_filter";
    public static final String KDC_TYPE = "kdc_type";
    public static final String UPDATE_CONFIGURATION_POLICY = "update_configuration_policy";
    public static final String UPDATE_CONFIGURATION_NOTE = "update_configuration_note";
    public static final String DATA_DIRECTORY_PREFIX = ".ambari_";
    private static final String PRINCIPAL_PASSWORD_MAP = "principal_password_map";
    private static final String PRINCIPAL_KEY_NUMBER_MAP = "principal_key_number_map";
    public static final String KEYTAB_CONTENT_BASE64 = "keytab_content_base64";
    public static final String OPERATION_TYPE = "operation_type";
    public static final String INCLUDE_AMBARI_IDENTITY = "include_ambari_identity";
    public static final String PRECONFIGURE_SERVICES = "preconfigure_services";
    private static final Logger LOG = LoggerFactory.getLogger(KerberosServerAction.class);
    @Inject
    private Clusters clusters = null;
    @Inject
    private KerberosOperationHandlerFactory kerberosOperationHandlerFactory;
    @Inject
    private KerberosHelper kerberosHelper;
    @Inject
    private HostDAO hostDAO;
    @Inject
    private KerberosKeytabController kerberosKeytabController;
    @Inject
    private Configuration configuration;
    @Inject
    private ThreadPools threadPools;

    protected static String getCommandParameterValue(Map<String, String> commandParameters, String propertyName) {
        return commandParameters == null || propertyName == null ? null : commandParameters.get(propertyName);
    }

    protected static UpdateConfigurationPolicy getUpdateConfigurationPolicy(Map<String, String> commandParameters) {
        String stringValue = KerberosServerAction.getCommandParameterValue(commandParameters, UPDATE_CONFIGURATION_POLICY);
        UpdateConfigurationPolicy value = UpdateConfigurationPolicy.translate(stringValue);
        return value == null ? UpdateConfigurationPolicy.ALL : value;
    }

    protected static String getDefaultRealm(Map<String, String> commandParameters) {
        return KerberosServerAction.getCommandParameterValue(commandParameters, DEFAULT_REALM);
    }

    protected static KDCType getKDCType(Map<String, String> commandParameters) {
        String kdcType = KerberosServerAction.getCommandParameterValue(commandParameters, KDC_TYPE);
        return kdcType == null || kdcType.isEmpty() ? KDCType.NONE : KDCType.translate(kdcType);
    }

    protected static String getDataDirectoryPath(Map<String, String> commandParameters) {
        return KerberosServerAction.getCommandParameterValue(commandParameters, DATA_DIRECTORY);
    }

    protected static OperationType getOperationType(Map<String, String> commandParameters) {
        String value = KerberosServerAction.getCommandParameterValue(commandParameters, OPERATION_TYPE);
        if (StringUtils.isEmpty((String)value)) {
            return OperationType.DEFAULT;
        }
        return OperationType.valueOf(value.toUpperCase());
    }

    protected static void setPrincipalPasswordMap(Map<String, Object> requestSharedDataContext, Map<String, String> principalPasswordMap) {
        if (requestSharedDataContext != null) {
            requestSharedDataContext.put(PRINCIPAL_PASSWORD_MAP, principalPasswordMap);
        }
    }

    protected static Map<String, String> getPrincipalPasswordMap(Map<String, Object> requestSharedDataContext) {
        if (requestSharedDataContext == null) {
            return null;
        }
        Object map = requestSharedDataContext.computeIfAbsent(PRINCIPAL_PASSWORD_MAP, k -> new HashMap());
        return (Map)map;
    }

    protected static Map<String, Integer> getPrincipalKeyNumberMap(Map<String, Object> requestSharedDataContext) {
        if (requestSharedDataContext == null) {
            return null;
        }
        Object map = requestSharedDataContext.computeIfAbsent(PRINCIPAL_KEY_NUMBER_MAP, k -> new HashMap());
        return (Map)map;
    }

    protected String getClusterName() throws OBDPException {
        String clusterName;
        ExecutionCommand executionCommand = this.getExecutionCommand();
        String string = clusterName = executionCommand == null ? null : executionCommand.getClusterName();
        if (clusterName == null || clusterName.isEmpty()) {
            throw new OBDPException("Failed to retrieve the cluster name from the execution command");
        }
        return clusterName;
    }

    protected Cluster getCluster() throws OBDPException {
        Cluster cluster = this.clusters.getCluster(this.getClusterName());
        if (cluster == null) {
            throw new OBDPException(String.format("Failed to retrieve cluster for %s", this.getClusterName()));
        }
        return cluster;
    }

    protected Clusters getClusters() {
        return this.clusters;
    }

    protected String getDataDirectoryPath() {
        return KerberosServerAction.getDataDirectoryPath(this.getCommandParameters());
    }

    protected PreconfigureServiceType getCommandPreconfigureType() {
        String preconfigureServices = KerberosServerAction.getCommandParameterValue(this.getCommandParameters(), PRECONFIGURE_SERVICES);
        PreconfigureServiceType type = null;
        if (!StringUtils.isEmpty((String)preconfigureServices)) {
            try {
                type = PreconfigureServiceType.valueOf(preconfigureServices.toUpperCase());
            }
            catch (Throwable t) {
                LOG.warn("Invalid preconfigure_services value, assuming DEFAULT: {}", (Object)preconfigureServices);
                type = PreconfigureServiceType.DEFAULT;
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommandReport processIdentities(Map<String, Object> requestSharedDataContext) throws OBDPException {
        CommandReport[] commandReport = new CommandReport[]{null};
        Map<String, String> commandParameters = this.getCommandParameters();
        this.actionLog.writeStdOut("Processing identities...");
        LOG.info("Processing identities...");
        if (commandParameters != null) {
            PrincipalKeyCredential administratorCredential = this.kerberosHelper.getKDCAdministratorCredentials(this.getClusterName());
            KDCType kdcType = KerberosServerAction.getKDCType(commandParameters);
            String defaultRealm = KerberosServerAction.getDefaultRealm(commandParameters);
            KerberosOperationHandler handler = this.kerberosOperationHandlerFactory.getKerberosOperationHandler(kdcType);
            Map<String, String> kerberosConfiguration = this.getConfigurationProperties("kerberos-env");
            try {
                handler.open(administratorCredential, defaultRealm, kerberosConfiguration);
            }
            catch (KerberosOperationException e) {
                String message = String.format("Failed to process the identities, could not properly open the KDC operation handler: %s", e.getMessage());
                this.actionLog.writeStdErr(message);
                LOG.error(message);
                throw new OBDPException(message, (Throwable)e);
            }
            try {
                ExecutionCommand executionCommand = this.getExecutionCommand();
                int threadCount = this.configuration.getKerberosServerActionThreadPoolSize();
                String factoryName = executionCommand == null ? "process-identity-%d" : "process-identity-task-" + executionCommand.getTaskId() + "-thread-%d";
                Map<String, Collection<String>> serviceComponentFilter = this.getServiceComponentFilter();
                if (serviceComponentFilter != null && this.pruneServiceFilter()) {
                    this.kerberosKeytabController.adjustServiceComponentFilter(this.clusters.getCluster(this.getClusterName()), true, serviceComponentFilter);
                }
                Collection<KerberosIdentityDescriptor> serviceIdentities = serviceComponentFilter == null ? null : this.kerberosKeytabController.getServiceIdentities(this.getClusterName(), serviceComponentFilter.keySet(), null);
                this.threadPools.parallelOperation(factoryName, threadCount, "identities", this.kerberosKeytabController.getFilteredKeytabs(serviceIdentities, this.getHostFilter(), this.getIdentityFilter()).stream().flatMap(rkk -> rkk.getPrincipals().stream()).map(principal -> () -> {
                    try {
                        return this.processIdentity((ResolvedKerberosPrincipal)principal, handler, kerberosConfiguration, this.isRelevantIdentity(serviceIdentities, (ResolvedKerberosPrincipal)principal), requestSharedDataContext);
                    }
                    catch (OBDPException ambariException) {
                        throw new OBDPRuntimeException(ambariException);
                    }
                }).collect(Collectors.toList()), cr -> {
                    boolean isFailed = Objects.isNull(cr);
                    if (!isFailed) {
                        commandReport[0] = cr;
                    }
                    return isFailed;
                });
            }
            catch (Exception exception) {
                LOG.error("Unable to process identities asynchronously", (Throwable)exception);
                CommandReport commandReport2 = this.createCommandReport(0, HostRoleStatus.FAILED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
                return commandReport2;
            }
            finally {
                try {
                    handler.close();
                }
                catch (KerberosOperationException kerberosOperationException) {}
            }
        }
        this.actionLog.writeStdOut("Processing identities completed.");
        LOG.info("Processing identities completed.");
        return commandReport[0] == null ? this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr()) : commandReport[0];
    }

    protected boolean pruneServiceFilter() {
        return true;
    }

    private boolean isRelevantIdentity(Collection<KerberosIdentityDescriptor> serviceIdentities, ResolvedKerberosPrincipal principal) {
        if (serviceIdentities != null) {
            boolean hasValidIdentity = false;
            for (KerberosIdentityDescriptor serviceIdentity : serviceIdentities) {
                if (!principal.getPrincipal().equals(serviceIdentity.getPrincipalDescriptor().getName()) || !StringUtils.isBlank((String)serviceIdentity.getReference())) continue;
                hasValidIdentity = true;
                break;
            }
            return hasValidIdentity;
        }
        return true;
    }

    protected abstract CommandReport processIdentity(ResolvedKerberosPrincipal var1, KerberosOperationHandler var2, Map<String, String> var3, boolean var4, Map<String, Object> var5) throws OBDPException;

    protected void deleteDataDirectory(String dataDirectoryPath) {
        File dataDirectory;
        File dataDirectoryParent;
        if (dataDirectoryPath != null && dataDirectoryPath.contains("/.ambari_") && (dataDirectoryParent = (dataDirectory = new File(dataDirectoryPath)).getParentFile()) != null && dataDirectory.isDirectory() && dataDirectoryParent.isDirectory() && dataDirectoryParent.canWrite()) {
            try {
                FileUtils.deleteDirectory((File)dataDirectory);
            }
            catch (IOException e) {
                String message = String.format("The data directory (%s) was not deleted due to an error condition - {%s}", dataDirectory.getAbsolutePath(), e.getMessage());
                LOG.warn(message, (Throwable)e);
            }
        }
    }

    protected Set<String> getHostFilter() {
        String serializedValue = this.getCommandParameterValue(HOST_FILTER);
        if (serializedValue != null) {
            Type type = new TypeToken<Set<String>>(){}.getType();
            return (Set)StageUtils.getGson().fromJson(serializedValue, type);
        }
        return null;
    }

    protected boolean hasHostFilters() {
        Set<String> hostFilers = this.getHostFilter();
        return hostFilers != null && hostFilers.size() > 0;
    }

    protected Map<String, Collection<String>> getServiceComponentFilter() {
        String serializedValue = this.getCommandParameterValue(SERVICE_COMPONENT_FILTER);
        if (serializedValue != null) {
            Type type = new TypeToken<Map<String, ? extends Collection<String>>>(){}.getType();
            return (Map)StageUtils.getGson().fromJson(serializedValue, type);
        }
        return null;
    }

    protected Collection<String> getIdentityFilter() {
        String serializedValue = this.getCommandParameterValue(IDENTITY_FILTER);
        if (serializedValue != null) {
            Type type = new TypeToken<Collection<String>>(){}.getType();
            return (Collection)StageUtils.getGson().fromJson(serializedValue, type);
        }
        return null;
    }

    protected Long ambariServerHostID() {
        String ambariServerHostName = StageUtils.getHostName();
        HostEntity ambariServerHostEntity = this.hostDAO.findByName(ambariServerHostName);
        return ambariServerHostEntity == null ? null : ambariServerHostEntity.getHostId();
    }

    protected Map<String, String> getConfigurationProperties(String configType) throws OBDPException {
        if (StringUtils.isNotEmpty((String)configType)) {
            Map<String, String> properties;
            Cluster cluster = this.getCluster();
            Config config = cluster == null ? null : cluster.getDesiredConfigByType(configType);
            Map<String, String> map = properties = config == null ? null : config.getProperties();
            if (properties == null) {
                LOG.warn("The '{}' configuration data is not available:\n\tcluster: {}\n\tconfig: {}\n\tproperties: null", new Object[]{configType, cluster == null ? "null" : "not null", config == null ? "null" : "not null"});
            }
            return properties;
        }
        return null;
    }

    public static enum OperationType {
        RECREATE_ALL,
        CREATE_MISSING,
        DEFAULT;

    }

    public static class KerberosCommandParameters {
        private Map<String, String> params;

        public KerberosCommandParameters(ExecutionCommand ec) {
            this.params = ec.getCommandParams();
        }

        public KerberosCommandParameters(AbstractServerAction serverAction) {
            this(serverAction.getExecutionCommand());
        }

        public Set<String> getHostFilter() {
            String serializedValue = this.getCommandParameterValue(KerberosServerAction.HOST_FILTER);
            if (serializedValue != null) {
                Type type = new TypeToken<Set<String>>(){}.getType();
                return (Set)StageUtils.getGson().fromJson(serializedValue, type);
            }
            return null;
        }

        public boolean hasHostFilters() {
            Set<String> hostFilers = this.getHostFilter();
            return hostFilers != null && hostFilers.size() > 0;
        }

        public Map<String, ? extends Collection<String>> getServiceComponentFilter() {
            String serializedValue = this.getCommandParameterValue(KerberosServerAction.SERVICE_COMPONENT_FILTER);
            if (serializedValue != null) {
                Type type = new TypeToken<Map<String, ? extends Collection<String>>>(){}.getType();
                return (Map)StageUtils.getGson().fromJson(serializedValue, type);
            }
            return null;
        }

        public Collection<String> getIdentityFilter() {
            String serializedValue = this.getCommandParameterValue(KerberosServerAction.IDENTITY_FILTER);
            if (serializedValue != null) {
                Type type = new TypeToken<Collection<String>>(){}.getType();
                return (Collection)StageUtils.getGson().fromJson(serializedValue, type);
            }
            return null;
        }

        public String getCommandParameterValue(String propertyName) {
            Map<String, String> commandParameters = this.params;
            return commandParameters == null ? null : commandParameters.get(propertyName);
        }
    }
}

