/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import id.onyx.obdp.server.serveraction.kerberos.ADKerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.IPAKerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.KDCType;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.MITKerberosOperationHandler;

@Singleton
public class KerberosOperationHandlerFactory {
    @Inject
    private Injector injector;

    public KerberosOperationHandler getKerberosOperationHandler(KDCType kdcType) {
        if (kdcType == null) {
            throw new IllegalArgumentException("kdcType may not be null");
        }
        switch (kdcType) {
            case MIT_KDC: {
                return (KerberosOperationHandler)this.injector.getInstance(MITKerberosOperationHandler.class);
            }
            case ACTIVE_DIRECTORY: {
                return (KerberosOperationHandler)this.injector.getInstance(ADKerberosOperationHandler.class);
            }
            case IPA: {
                return (KerberosOperationHandler)this.injector.getInstance(IPAKerberosOperationHandler.class);
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected kdcType value: %s", kdcType.name()));
    }
}

