/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import id.onyx.obdp.server.security.credential.PrincipalKeyCredential;
import id.onyx.obdp.server.serveraction.kerberos.DeconstructedPrincipal;
import id.onyx.obdp.server.serveraction.kerberos.KerberosAdminAuthenticationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationException;
import id.onyx.obdp.server.utils.ShellCommandUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KerberosOperationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosOperationHandler.class);
    public static final String KERBEROS_ENV_LDAP_URL = "ldap_url";
    public static final String KERBEROS_ENV_PRINCIPAL_CONTAINER_DN = "container_dn";
    public static final String KERBEROS_ENV_USER_PRINCIPAL_GROUP = "ipa_user_group";
    public static final String KERBEROS_ENV_AD_CREATE_ATTRIBUTES_TEMPLATE = "ad_create_attributes_template";
    public static final String KERBEROS_ENV_KDC_CREATE_ATTRIBUTES = "kdc_create_attributes";
    public static final String KERBEROS_ENV_ENCRYPTION_TYPES = "encryption_types";
    public static final String KERBEROS_ENV_KDC_HOSTS = "kdc_hosts";
    public static final String KERBEROS_ENV_ADMIN_SERVER_HOST = "admin_server_host";
    public static final String KERBEROS_ENV_KADMIN_PRINCIPAL_NAME = "kadmin_principal_name";
    public static final String KERBEROS_ENV_EXECUTABLE_SEARCH_PATHS = "executable_search_paths";
    private static final String[] DEFAULT_EXECUTABLE_SEARCH_PATHS = new String[]{"/usr/bin", "/usr/kerberos/bin", "/usr/sbin", "/usr/lib/mit/bin", "/usr/lib/mit/sbin"};
    private static final Map<String, Set<EncryptionType>> ENCRYPTION_TYPE_TRANSLATION_MAP = Collections.unmodifiableMap(new HashMap<String, Set<EncryptionType>>(){
        {
            this.put("aes", EnumSet.of(EncryptionType.AES256_CTS_HMAC_SHA1_96, EncryptionType.AES128_CTS_HMAC_SHA1_96));
            this.put("aes256-cts-hmac-sha1-96", EnumSet.of(EncryptionType.AES256_CTS_HMAC_SHA1_96));
            this.put("aes256-cts", EnumSet.of(EncryptionType.AES256_CTS_HMAC_SHA1_96));
            this.put("aes-256", EnumSet.of(EncryptionType.AES256_CTS_HMAC_SHA1_96));
            this.put("aes128-cts-hmac-sha1-96", EnumSet.of(EncryptionType.AES128_CTS_HMAC_SHA1_96));
            this.put("aes128-cts", EnumSet.of(EncryptionType.AES128_CTS_HMAC_SHA1_96));
            this.put("aes-128", EnumSet.of(EncryptionType.AES128_CTS_HMAC_SHA1_96));
            this.put("rc4", EnumSet.of(EncryptionType.RC4_HMAC));
            this.put("arcfour-hmac", EnumSet.of(EncryptionType.RC4_HMAC));
            this.put("rc4-hmac", EnumSet.of(EncryptionType.RC4_HMAC));
            this.put("arcfour-hmac-md5", EnumSet.of(EncryptionType.UNKNOWN));
            this.put("arcfour-hmac-exp", EnumSet.of(EncryptionType.RC4_HMAC_EXP));
            this.put("rc4-hmac-exp", EnumSet.of(EncryptionType.RC4_HMAC_EXP));
            this.put("arcfour-hmac-md5-exp", EnumSet.of(EncryptionType.UNKNOWN));
            this.put("camellia", EnumSet.of(EncryptionType.UNKNOWN));
            this.put("camellia256-cts-cmac", EnumSet.of(EncryptionType.UNKNOWN));
            this.put("camellia256-cts", EnumSet.of(EncryptionType.UNKNOWN));
            this.put("camellia128-cts-cmac", EnumSet.of(EncryptionType.UNKNOWN));
            this.put("camellia128-cts", EnumSet.of(EncryptionType.UNKNOWN));
            this.put("des", EnumSet.of(EncryptionType.DES_CBC_CRC, EncryptionType.DES_CBC_MD5, EncryptionType.DES_CBC_MD4));
            this.put("des-cbc-md4", EnumSet.of(EncryptionType.DES_CBC_MD4));
            this.put("des-cbc-md5", EnumSet.of(EncryptionType.DES_CBC_MD5));
            this.put("des-cbc-crc", EnumSet.of(EncryptionType.DES_CBC_CRC));
            this.put("des-cbc-raw", EnumSet.of(EncryptionType.UNKNOWN));
            this.put("des-hmac-sha1", EnumSet.of(EncryptionType.UNKNOWN));
            this.put("des3", EnumSet.of(EncryptionType.DES3_CBC_SHA1_KD));
            this.put("des3-cbc-raw", EnumSet.of(EncryptionType.UNKNOWN));
            this.put("des3-cbc-sha1", EnumSet.of(EncryptionType.DES3_CBC_SHA1_KD));
            this.put("des3-hmac-sha1", EnumSet.of(EncryptionType.UNKNOWN));
            this.put("des3-cbc-sha1-kd", EnumSet.of(EncryptionType.DES3_CBC_SHA1_KD));
        }
    });
    private static final Set<EncryptionType> DEFAULT_CIPHERS = Collections.unmodifiableSet(new HashSet<EncryptionType>(){
        {
            this.add(EncryptionType.DES_CBC_MD5);
            this.add(EncryptionType.DES3_CBC_SHA1_KD);
            this.add(EncryptionType.RC4_HMAC);
            this.add(EncryptionType.AES128_CTS_HMAC_SHA1_96);
            this.add(EncryptionType.AES256_CTS_HMAC_SHA1_96);
        }
    });
    private PrincipalKeyCredential administratorCredential = null;
    private String defaultRealm = null;
    private Set<EncryptionType> keyEncryptionTypes = new HashSet<EncryptionType>(DEFAULT_CIPHERS);
    private boolean open = false;
    private String[] executableSearchPaths = null;

    public void open(PrincipalKeyCredential administratorCredential, String defaultRealm, Map<String, String> kerberosConfiguration) throws KerberosOperationException {
        this.setAdministratorCredential(administratorCredential);
        this.setDefaultRealm(defaultRealm);
        if (kerberosConfiguration != null) {
            this.setKeyEncryptionTypes(this.translateEncryptionTypes(kerberosConfiguration.get(KERBEROS_ENV_ENCRYPTION_TYPES), "\\s+"));
            this.setExecutableSearchPaths(kerberosConfiguration.get(KERBEROS_ENV_EXECUTABLE_SEARCH_PATHS));
        }
    }

    public void close() throws KerberosOperationException {
        this.setOpen(false);
    }

    public abstract boolean principalExists(String var1, boolean var2) throws KerberosOperationException;

    public abstract Integer createPrincipal(String var1, String var2, boolean var3) throws KerberosOperationException;

    public abstract Integer setPrincipalPassword(String var1, String var2, boolean var3) throws KerberosOperationException;

    public abstract boolean removePrincipal(String var1, boolean var2) throws KerberosOperationException;

    public boolean testAdministratorCredentials() throws KerberosOperationException {
        if (!this.isOpen()) {
            throw new KerberosOperationException("This operation handler has not been opened");
        }
        PrincipalKeyCredential credential = this.getAdministratorCredential();
        if (credential == null) {
            throw new KerberosOperationException("Missing KDC administrator credential");
        }
        return this.principalExists(credential.getPrincipal(), false);
    }

    protected Keytab createKeytab(String principal, String password, Integer keyNumber) throws KerberosOperationException {
        Map keys;
        if (StringUtils.isEmpty((String)principal)) {
            throw new KerberosOperationException("Failed to create keytab file, missing principal");
        }
        if (password == null) {
            throw new KerberosOperationException(String.format("Failed to create keytab file for %s, missing password", principal));
        }
        HashSet<EncryptionType> ciphers = new HashSet<EncryptionType>(this.keyEncryptionTypes);
        ArrayList<KeytabEntry> keytabEntries = new ArrayList<KeytabEntry>();
        Keytab keytab = new Keytab();
        if (!ciphers.isEmpty() && (keys = KerberosKeyFactory.getKerberosKeys((String)principal, (String)password, ciphers)) != null) {
            byte keyVersion = keyNumber == null ? (byte)0 : keyNumber.byteValue();
            KerberosTime timestamp = new KerberosTime();
            for (EncryptionKey encryptionKey : keys.values()) {
                keytabEntries.add(new KeytabEntry(principal, 1, timestamp, keyVersion, encryptionKey));
            }
            keytab.setEntries(keytabEntries);
        }
        return keytab;
    }

    protected boolean createKeytabFile(File sourceKeytabFile, File destinationKeytabFile) throws KerberosOperationException {
        return this.createKeytabFile(this.readKeytabFile(sourceKeytabFile), destinationKeytabFile);
    }

    protected boolean createKeytabFile(String principal, String password, Integer keyNumber, File destinationKeytabFile) throws KerberosOperationException {
        return this.createKeytabFile(this.createKeytab(principal, password, keyNumber), destinationKeytabFile);
    }

    public boolean createKeytabFile(Keytab keytab, File destinationKeytabFile) throws KerberosOperationException {
        if (destinationKeytabFile == null) {
            throw new KerberosOperationException("The destination file path is null");
        }
        try {
            this.mergeKeytabs(this.readKeytabFile(destinationKeytabFile), keytab).write(destinationKeytabFile);
            return true;
        }
        catch (IOException e) {
            String message = "Failed to export keytab file";
            LOG.error(message, (Throwable)e);
            if (!destinationKeytabFile.delete()) {
                destinationKeytabFile.deleteOnExit();
            }
            throw new KerberosOperationException(message, e);
        }
    }

    protected Keytab mergeKeytabs(Keytab keytab, Keytab updates) {
        ArrayList keytabEntries = keytab == null ? Collections.emptyList() : new ArrayList(keytab.getEntries());
        ArrayList updateEntries = updates == null ? Collections.emptyList() : new ArrayList(updates.getEntries());
        ArrayList mergedEntries = new ArrayList();
        if (keytabEntries.isEmpty()) {
            mergedEntries.addAll(updateEntries);
        } else if (updateEntries.isEmpty()) {
            mergedEntries.addAll(keytabEntries);
        } else {
            Iterator iterator = keytabEntries.iterator();
            block0: while (iterator.hasNext()) {
                KeytabEntry keytabEntry = (KeytabEntry)iterator.next();
                for (KeytabEntry entry : updateEntries) {
                    if (!entry.getPrincipalName().equals(keytabEntry.getPrincipalName()) || !entry.getKey().getKeyType().equals((Object)keytabEntry.getKey().getKeyType())) continue;
                    iterator.remove();
                    continue block0;
                }
            }
            mergedEntries.addAll(keytabEntries);
            mergedEntries.addAll(updateEntries);
        }
        Keytab mergedKeytab = new Keytab();
        mergedKeytab.setEntries(mergedEntries);
        return mergedKeytab;
    }

    protected Keytab readKeytabFile(File file) {
        Keytab keytab;
        if (file.exists() && file.canRead() && file.length() > 0L) {
            try {
                keytab = Keytab.read((File)file);
            }
            catch (IOException e) {
                keytab = null;
            }
        } else {
            keytab = null;
        }
        return keytab;
    }

    public PrincipalKeyCredential getAdministratorCredential() {
        return this.administratorCredential;
    }

    public void setAdministratorCredential(PrincipalKeyCredential administratorCredential) throws KerberosAdminAuthenticationException {
        if (administratorCredential == null) {
            throw new KerberosAdminAuthenticationException("The administrator credential must not be null");
        }
        String principal = administratorCredential.getPrincipal();
        if (StringUtils.isEmpty((String)principal)) {
            throw new KerberosAdminAuthenticationException("Must specify a principal but it is null or empty");
        }
        char[] password = administratorCredential.getKey();
        if (ArrayUtils.isEmpty((char[])password)) {
            throw new KerberosAdminAuthenticationException("Must specify a password but it is null or empty");
        }
        this.administratorCredential = administratorCredential;
    }

    public String getDefaultRealm() {
        return this.defaultRealm;
    }

    public void setDefaultRealm(String defaultRealm) {
        this.defaultRealm = defaultRealm;
    }

    public Set<EncryptionType> getKeyEncryptionTypes() {
        return this.keyEncryptionTypes;
    }

    public void setKeyEncryptionTypes(Set<EncryptionType> keyEncryptionTypes) {
        this.keyEncryptionTypes = Collections.unmodifiableSet(new HashSet<EncryptionType>(keyEncryptionTypes == null ? DEFAULT_CIPHERS : keyEncryptionTypes));
    }

    public String[] getExecutableSearchPaths() {
        return this.executableSearchPaths;
    }

    public void setExecutableSearchPaths(String[] executableSearchPaths) {
        this.executableSearchPaths = executableSearchPaths;
    }

    public void setExecutableSearchPaths(String delimitedExecutableSearchPaths) {
        ArrayList<String> searchPaths = null;
        if (delimitedExecutableSearchPaths != null) {
            searchPaths = new ArrayList<String>();
            for (String path : delimitedExecutableSearchPaths.split(",")) {
                if ((path = path.trim()).isEmpty()) continue;
                searchPaths.add(path);
            }
        }
        this.setExecutableSearchPaths(searchPaths == null ? null : searchPaths.toArray(new String[searchPaths.size()]));
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    protected File createKeytabFile(String keytabData) throws KerberosOperationException {
        boolean success = false;
        File tempFile = null;
        try {
            tempFile = File.createTempFile("temp", ".dat");
        }
        catch (IOException e) {
            LOG.error(String.format("Failed to create temporary keytab file: %s", e.getLocalizedMessage()), (Throwable)e);
        }
        if (tempFile != null && keytabData != null) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(tempFile);
                ((OutputStream)fos).write(Base64.decodeBase64((String)keytabData));
                success = true;
            }
            catch (IOException e) {
                String message = String.format("Failed to write to temporary keytab file %s: %s", tempFile.getAbsolutePath(), e.getLocalizedMessage());
                LOG.error(message, (Throwable)e);
                throw new KerberosOperationException(message, e);
            }
            finally {
                if (fos != null) {
                    try {
                        ((OutputStream)fos).close();
                    }
                    catch (IOException iOException) {}
                }
                if (!success) {
                    if (!tempFile.delete()) {
                        tempFile.deleteOnExit();
                    }
                    tempFile = null;
                }
            }
        }
        return tempFile;
    }

    protected ShellCommandUtil.Result executeCommand(String[] command, Map<String, String> envp, ShellCommandUtil.InteractiveHandler interactiveHandler) throws KerberosOperationException {
        if (command == null || command.length == 0) {
            return null;
        }
        try {
            return ShellCommandUtil.runCommand(command, envp, interactiveHandler, false);
        }
        catch (IOException e) {
            String message = String.format("Failed to execute the command: %s", e.getLocalizedMessage());
            LOG.error(message, (Throwable)e);
            throw new KerberosOperationException(message, e);
        }
        catch (InterruptedException e) {
            String message = String.format("Failed to wait for the command to complete: %s", e.getLocalizedMessage());
            LOG.error(message, (Throwable)e);
            throw new KerberosOperationException(message, e);
        }
    }

    protected ShellCommandUtil.Result executeCommand(String[] command) throws KerberosOperationException {
        return this.executeCommand(command, null);
    }

    protected ShellCommandUtil.Result executeCommand(String[] command, ShellCommandUtil.InteractiveHandler interactiveHandler) throws KerberosOperationException {
        return this.executeCommand(command, null, interactiveHandler);
    }

    protected DeconstructedPrincipal createDeconstructPrincipal(String principal) throws KerberosOperationException {
        try {
            return DeconstructedPrincipal.valueOf(principal, this.getDefaultRealm());
        }
        catch (IllegalArgumentException e) {
            throw new KerberosOperationException(e.getMessage(), e);
        }
    }

    protected Set<EncryptionType> translateEncryptionType(String name) {
        Set<EncryptionType> encryptionTypes = null;
        if (!StringUtils.isEmpty((String)name)) {
            encryptionTypes = ENCRYPTION_TYPE_TRANSLATION_MAP.get(name.toLowerCase());
        }
        if (encryptionTypes == null) {
            LOG.warn("The given encryption type name ({}) is not supported.", (Object)name);
            return Collections.emptySet();
        }
        return encryptionTypes;
    }

    protected Set<EncryptionType> translateEncryptionTypes(String names, String delimiter) throws KerberosOperationException {
        HashSet<EncryptionType> encryptionTypes = new HashSet<EncryptionType>();
        if (!StringUtils.isEmpty((String)names)) {
            for (String name : names.split(delimiter == null ? "\\s+" : delimiter)) {
                encryptionTypes.addAll(this.translateEncryptionType(name.trim()));
            }
        }
        if (encryptionTypes.isEmpty()) {
            throw new KerberosOperationException("All the encryption type names you set are not supported. Aborting.");
        }
        return encryptionTypes;
    }

    protected String escapeCharacters(String string, Set<Character> charactersToEscape, Character escapeCharacter) {
        if (StringUtils.isEmpty((String)string) || charactersToEscape == null || charactersToEscape.isEmpty()) {
            return string;
        }
        StringBuilder builder = new StringBuilder();
        for (char character : string.toCharArray()) {
            if (charactersToEscape.contains(Character.valueOf(character))) {
                builder.append(escapeCharacter);
            }
            builder.append(character);
        }
        return builder.toString();
    }

    protected String getExecutable(String executable) {
        String[] searchPaths = this.getExecutableSearchPaths();
        String executablePath = null;
        if (searchPaths == null) {
            searchPaths = DEFAULT_EXECUTABLE_SEARCH_PATHS;
        }
        for (String searchPath : searchPaths) {
            File executableFile = new File(searchPath, executable);
            if (!executableFile.canExecute()) continue;
            executablePath = executableFile.getAbsolutePath();
            break;
        }
        return executablePath == null ? executable : executablePath;
    }
}

