/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.security.credential.PrincipalKeyCredential;
import id.onyx.obdp.server.serveraction.kerberos.KerberosAdminAuthenticationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.KerberosPrincipalDoesNotExistException;
import id.onyx.obdp.server.utils.HTTPUtils;
import id.onyx.obdp.server.utils.HostAndPort;
import id.onyx.obdp.server.utils.ShellCommandUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class KDCKerberosOperationHandler
extends KerberosOperationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(KDCKerberosOperationHandler.class);
    private String adminServerHost = null;
    private String adminServerHostAndPort = null;
    private HashMap<String, Keytab> cachedKeytabs = null;
    private String executableKinit = null;
    private File credentialsCacheFile = null;
    private Map<String, String> environmentMap = null;

    KDCKerberosOperationHandler() {
    }

    @Override
    public void open(PrincipalKeyCredential administratorCredentials, String realm, Map<String, String> kerberosConfiguration) throws KerberosOperationException {
        super.open(administratorCredentials, realm, kerberosConfiguration);
        if (kerberosConfiguration != null) {
            String value = kerberosConfiguration.get("admin_server_host");
            HostAndPort hostAndPort = HTTPUtils.getHostAndPortFromProperty(value);
            if (hostAndPort == null) {
                this.adminServerHost = value;
                this.adminServerHostAndPort = value;
            } else {
                this.adminServerHost = hostAndPort.host;
                this.adminServerHostAndPort = value;
            }
        }
        this.executableKinit = this.getExecutable("kinit");
        this.setOpen(this.init(kerberosConfiguration));
    }

    @Override
    public void close() throws KerberosOperationException {
        if (this.credentialsCacheFile != null) {
            if (this.credentialsCacheFile.delete()) {
                LOG.debug("Failed to remove the cache file, {}", (Object)this.credentialsCacheFile.getAbsolutePath());
            }
            this.credentialsCacheFile = null;
        }
        this.environmentMap = null;
        this.executableKinit = null;
        this.cachedKeytabs = null;
        this.adminServerHost = null;
        this.adminServerHostAndPort = null;
        super.close();
    }

    @Override
    public Integer setPrincipalPassword(String principal, String password, boolean service) throws KerberosOperationException {
        if (!this.isOpen()) {
            throw new KerberosOperationException("This operation handler has not been opened");
        }
        if (!this.principalExists(principal, service)) {
            throw new KerberosPrincipalDoesNotExistException(String.format("Principal does not exist while attempting to set its password: %s", principal));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Keytab createKeytab(String principal, String password, Integer keyNumber) throws KerberosOperationException {
        if (principal == null || principal.isEmpty()) {
            throw new KerberosOperationException("Failed to create keytab file, missing principal");
        }
        if (this.cachedKeytabs.containsKey(principal)) {
            return this.cachedKeytabs.get(principal);
        }
        File keytabFile = null;
        try {
            try {
                keytabFile = File.createTempFile("obdp_tmp", ".keytab");
                if (!keytabFile.delete()) {
                    LOG.warn("Failed to remove temporary file to hold keytab.  Exporting the keytab file for {} may fail.", (Object)principal);
                }
            }
            catch (IOException e) {
                throw new KerberosOperationException(String.format("Failed to create the temporary file needed to hold the exported keytab file for %s: %s", principal, e.getLocalizedMessage()), e);
            }
            this.exportKeytabFile(principal, keytabFile.getAbsolutePath(), this.getKeyEncryptionTypes());
            Keytab keytab = this.readKeytabFile(keytabFile);
            this.cachedKeytabs.put(principal, keytab);
            Keytab keytab2 = keytab;
            return keytab2;
        }
        finally {
            if (keytabFile != null && keytabFile.exists() && !keytabFile.delete()) {
                LOG.debug("Failed to remove the temporary keytab file, {}", (Object)keytabFile.getAbsolutePath());
            }
        }
    }

    @Override
    protected ShellCommandUtil.Result executeCommand(String[] command, Map<String, String> envp, ShellCommandUtil.InteractiveHandler interactiveHandler) throws KerberosOperationException {
        Map<String, String> _envp;
        if (MapUtils.isEmpty(this.environmentMap)) {
            _envp = envp;
        } else if (MapUtils.isEmpty(envp)) {
            _envp = this.environmentMap;
        } else {
            _envp = new HashMap<String, String>();
            _envp.putAll(envp);
            _envp.putAll(this.environmentMap);
        }
        return super.executeCommand(command, _envp, interactiveHandler);
    }

    String getAdminServerHost(boolean includePort) {
        return includePort ? this.adminServerHostAndPort : this.adminServerHost;
    }

    String getCredentialCacheFilePath() {
        return this.credentialsCacheFile == null ? null : this.credentialsCacheFile.getAbsolutePath();
    }

    protected abstract String[] getKinitCommand(String var1, PrincipalKeyCredential var2, String var3, Map<String, String> var4) throws KerberosOperationException;

    protected abstract void exportKeytabFile(String var1, String var2, Set<EncryptionType> var3) throws KerberosOperationException;

    protected boolean init(Map<String, String> kerberosConfiguration) throws KerberosOperationException {
        if (this.credentialsCacheFile != null) {
            if (!this.credentialsCacheFile.delete()) {
                LOG.debug("Failed to remove the orphaned cache file, {}", (Object)this.credentialsCacheFile.getAbsolutePath());
            }
            this.credentialsCacheFile = null;
        }
        try {
            this.credentialsCacheFile = File.createTempFile("obdp_krb_", "cc");
            this.credentialsCacheFile.deleteOnExit();
            this.ensureAmbariOnlyAccess(this.credentialsCacheFile);
        }
        catch (IOException e) {
            throw new KerberosOperationException(String.format("Failed to create the temporary file needed to hold the administrator ticket cache: %s", e.getLocalizedMessage()), e);
        }
        String credentialsCache = String.format("FILE:%s", this.credentialsCacheFile.getAbsolutePath());
        this.environmentMap = new HashMap<String, String>();
        this.environmentMap.put("KRB5CCNAME", credentialsCache);
        PrincipalKeyCredential credentials = this.getAdministratorCredential();
        ShellCommandUtil.Result result = this.executeCommand(this.getKinitCommand(this.executableKinit, credentials, credentialsCache, kerberosConfiguration), this.environmentMap, new InteractivePasswordHandler(String.valueOf(credentials.getKey()), null));
        if (!result.isSuccessful()) {
            String message = String.format("Failed to kinit as the KDC administrator user, %s:\n\tExitCode: %s\n\tSTDOUT: %s\n\tSTDERR: %s", credentials.getPrincipal(), result.getExitCode(), result.getStdout(), result.getStderr());
            LOG.warn(message);
            throw new KerberosAdminAuthenticationException(message);
        }
        this.cachedKeytabs = new HashMap();
        return true;
    }

    private void ensureAmbariOnlyAccess(File file) throws OBDPException {
        if (file.exists()) {
            if (!file.setReadable(false, false) || !file.setReadable(true, true)) {
                String message = String.format("Failed to set %s readable only by OBDP", file.getAbsolutePath());
                LOG.warn(message);
                throw new OBDPException(message);
            }
            if (!file.setWritable(false, false) || !file.setWritable(true, true)) {
                String message = String.format("Failed to set %s writable only by OBDP", file.getAbsolutePath());
                LOG.warn(message);
                throw new OBDPException(message);
            }
            if (file.isDirectory()) {
                if (!file.setExecutable(false, false) || !file.setExecutable(true, true)) {
                    String message = String.format("Failed to set %s executable by OBDP", file.getAbsolutePath());
                    LOG.warn(message);
                    throw new OBDPException(message);
                }
            } else if (!file.setExecutable(false, false)) {
                String message = String.format("Failed to set %s not executable", file.getAbsolutePath());
                LOG.warn(message);
                throw new OBDPException(message);
            }
        }
    }

    protected static class InteractivePasswordHandler
    implements ShellCommandUtil.InteractiveHandler {
        private LinkedList<String> responses = new LinkedList();
        private Queue<String> currentResponses;

        InteractivePasswordHandler(String adminPassword, String userPassword) {
            if (adminPassword != null) {
                this.responses.offer(adminPassword);
            }
            if (userPassword != null) {
                this.responses.offer(userPassword);
                this.responses.offer(userPassword);
            }
            this.currentResponses = new LinkedList<String>(this.responses);
        }

        @Override
        public boolean done() {
            return this.currentResponses.size() == 0;
        }

        @Override
        public String getResponse(String query) {
            return this.currentResponses.poll();
        }

        @Override
        public void start() {
            this.currentResponses = new LinkedList<String>(this.responses);
        }
    }
}

