/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import id.onyx.obdp.server.security.credential.PrincipalKeyCredential;
import id.onyx.obdp.server.serveraction.kerberos.DeconstructedPrincipal;
import id.onyx.obdp.server.serveraction.kerberos.KDCKerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosPrincipalAlreadyExistsException;
import id.onyx.obdp.server.utils.ShellCommandUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPAKerberosOperationHandler
extends KDCKerberosOperationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(IPAKerberosOperationHandler.class);
    private String userPrincipalGroup = null;
    private String executableIpaGetKeytab = null;
    private String executableIpa = null;

    @Override
    public void open(PrincipalKeyCredential administratorCredentials, String realm, Map<String, String> kerberosConfiguration) throws KerberosOperationException {
        if (kerberosConfiguration != null) {
            this.userPrincipalGroup = kerberosConfiguration.get("ipa_user_group");
        }
        this.executableIpa = this.getExecutable("ipa");
        this.executableIpaGetKeytab = this.getExecutable("ipa-getkeytab");
        super.open(administratorCredentials, realm, kerberosConfiguration);
    }

    @Override
    public void close() throws KerberosOperationException {
        this.userPrincipalGroup = null;
        this.executableIpa = null;
        this.executableIpaGetKeytab = null;
        super.close();
    }

    @Override
    public boolean principalExists(String principal, boolean service) throws KerberosOperationException {
        if (!this.isOpen()) {
            throw new KerberosOperationException("This operation handler has not been opened");
        }
        if (!StringUtils.isEmpty((String)principal)) {
            DeconstructedPrincipal deconstructedPrincipal = this.createDeconstructPrincipal(principal);
            String principalName = deconstructedPrincipal.getPrincipalName();
            String[] ipaCommand = new String[]{service ? "service-show" : "user-show", principalName};
            ShellCommandUtil.Result result = this.invokeIpa(ipaCommand);
            if (result.isSuccessful()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Integer createPrincipal(String principal, String password, boolean service) throws KerberosOperationException {
        Object[] ipaCommand;
        if (!this.isOpen()) {
            throw new KerberosOperationException("This operation handler has not been opened");
        }
        if (StringUtils.isEmpty((String)principal)) {
            throw new KerberosOperationException("Failed to create new principal - no principal specified");
        }
        DeconstructedPrincipal deconstructedPrincipal = this.createDeconstructPrincipal(principal);
        String normalizedPrincipal = deconstructedPrincipal.getNormalizedPrincipal();
        if (service) {
            ipaCommand = new String[]{"service-add", normalizedPrincipal};
        } else {
            String principalName = deconstructedPrincipal.getPrincipalName();
            if (!principalName.equals(principalName.toLowerCase())) {
                LOG.warn("{} is not in lowercase. FreeIPA does not recognize user principals that are not entirely in lowercase. This can lead to issues with kinit and keytabs. Make sure users are in lowercase.", (Object)principalName);
            }
            ipaCommand = new String[]{"user-add", deconstructedPrincipal.getPrimary(), "--principal", principalName, "--first", deconstructedPrincipal.getPrimary(), "--last", deconstructedPrincipal.getPrimary(), "--cn", deconstructedPrincipal.getPrimary()};
        }
        ShellCommandUtil.Result result = this.invokeIpa((String[])ipaCommand);
        if (!result.isSuccessful()) {
            String message = String.format("Failed to create principal for %s\n%s\nSTDOUT: %s\nSTDERR: %s", normalizedPrincipal, StringUtils.join((Object[])ipaCommand, (String)" "), result.getStdout(), result.getStderr());
            LOG.error(message);
            String stdErr = result.getStderr();
            if (stdErr != null && (service && stdErr.contains(String.format("service with name \"%s\" already exists", normalizedPrincipal)) || !service && stdErr.contains(String.format("user with name \"%s\" already exists", deconstructedPrincipal.getPrimary())))) {
                throw new KerberosPrincipalAlreadyExistsException(principal);
            }
            throw new KerberosOperationException(String.format("Failed to create principal for %s\nSTDOUT: %s\nSTDERR: %s", normalizedPrincipal, result.getStdout(), result.getStderr()));
        }
        if (!(service || StringUtils.isEmpty((String)this.userPrincipalGroup) || (result = this.invokeIpa(new String[]{"group-add-member", this.userPrincipalGroup, "--users", deconstructedPrincipal.getPrimary()})).isSuccessful())) {
            LOG.warn("Failed to add account for {} to group {}: \nSTDOUT: {}\nSTDERR: {}", new Object[]{normalizedPrincipal, this.userPrincipalGroup, result.getStdout(), result.getStderr()});
        }
        return 0;
    }

    @Override
    public boolean removePrincipal(String principal, boolean service) throws KerberosOperationException {
        String[] stringArray;
        if (!this.isOpen()) {
            throw new KerberosOperationException("This operation handler has not been opened");
        }
        if (StringUtils.isEmpty((String)principal)) {
            throw new KerberosOperationException("Failed to remove principal - no principal specified");
        }
        DeconstructedPrincipal deconstructedPrincipal = this.createDeconstructPrincipal(principal);
        if (service) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "service-del";
            stringArray = stringArray2;
            stringArray2[1] = deconstructedPrincipal.getNormalizedPrincipal();
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "user-del";
            stringArray = stringArray3;
            stringArray3[1] = deconstructedPrincipal.getPrincipalName();
        }
        String[] ipaCommand = stringArray;
        return this.invokeIpa(ipaCommand).isSuccessful();
    }

    @Override
    protected String[] getKinitCommand(String executableKinit, PrincipalKeyCredential credentials, String credentialsCache, Map<String, String> kerberosConfiguration) throws KerberosOperationException {
        String[] command = new String[]{executableKinit, "-c", credentialsCache, credentials.getPrincipal()};
        if (Arrays.asList(command).contains(null)) {
            throw new KerberosOperationException("Got a null value, can not create 'kinit' command");
        }
        return command;
    }

    @Override
    protected void exportKeytabFile(String principal, String keytabFileDestinationPath, Set<EncryptionType> keyEncryptionTypes) throws KerberosOperationException {
        String[] stringArray;
        String encryptionTypeSpec = null;
        if (!CollectionUtils.isEmpty(keyEncryptionTypes)) {
            StringBuilder encryptionTypeSpecBuilder = new StringBuilder();
            for (EncryptionType encryptionType : keyEncryptionTypes) {
                if (encryptionTypeSpecBuilder.length() > 0) {
                    encryptionTypeSpecBuilder.append(',');
                }
                encryptionTypeSpecBuilder.append(encryptionType.getName());
            }
            encryptionTypeSpec = encryptionTypeSpecBuilder.toString();
        }
        if (StringUtils.isEmpty(encryptionTypeSpec)) {
            String[] stringArray2 = new String[7];
            stringArray2[0] = this.executableIpaGetKeytab;
            stringArray2[1] = "-s";
            stringArray2[2] = this.getAdminServerHost(true);
            stringArray2[3] = "-p";
            stringArray2[4] = principal;
            stringArray2[5] = "-k";
            stringArray = stringArray2;
            stringArray2[6] = keytabFileDestinationPath;
        } else {
            String[] stringArray3 = new String[9];
            stringArray3[0] = this.executableIpaGetKeytab;
            stringArray3[1] = "-s";
            stringArray3[2] = this.getAdminServerHost(true);
            stringArray3[3] = "-e";
            stringArray3[4] = encryptionTypeSpec;
            stringArray3[5] = "-p";
            stringArray3[6] = principal;
            stringArray3[7] = "-k";
            stringArray = stringArray3;
            stringArray3[8] = keytabFileDestinationPath;
        }
        String[] createKeytabFileCommand = stringArray;
        ShellCommandUtil.Result result = this.executeCommand(createKeytabFileCommand);
        if (!result.isSuccessful()) {
            String message = String.format("Failed to export the keytab file for %s:\n\tExitCode: %s\n\tSTDOUT: %s\n\tSTDERR: %s", principal, result.getExitCode(), result.getStdout(), result.getStderr());
            LOG.warn(message);
            throw new KerberosOperationException(message);
        }
    }

    private ShellCommandUtil.Result invokeIpa(String[] query) throws KerberosOperationException {
        if (query == null || query.length == 0) {
            throw new KerberosOperationException("Missing ipa query");
        }
        if (StringUtils.isEmpty((String)this.executableIpa)) {
            throw new KerberosOperationException("No path for ipa is available - this KerberosOperationHandler may not have been opened.");
        }
        Object[] command = new String[query.length + 1];
        command[0] = this.executableIpa;
        System.arraycopy(query, 0, command, 1, query.length);
        ShellCommandUtil.Result result = this.executeCommand((String[])command);
        if (result.isSuccessful()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executed the following command:\n{}\nSTDOUT: {}\nSTDERR: {}", new Object[]{StringUtils.join((Object[])command, (String)" "), result.getStdout(), result.getStderr()});
            }
        } else {
            LOG.error("Failed to execute the following command:\n{}\nSTDOUT: {}\nSTDERR: {}", new Object[]{StringUtils.join((Object[])command, (String)" "), result.getStdout(), result.getStderr()});
        }
        return result;
    }
}

