/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import com.google.common.util.concurrent.Striped;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.agent.stomp.TopologyHolder;
import id.onyx.obdp.server.events.TopologyUpdateEvent;
import id.onyx.obdp.server.serveraction.kerberos.KDCType;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.KerberosServerAction;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosPrincipal;
import id.onyx.obdp.server.utils.ShellCommandUtil;
import id.onyx.obdp.server.utils.StageUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalizeKerberosServerAction
extends KerberosServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(FinalizeKerberosServerAction.class);
    private final TopologyHolder topologyHolder;
    private Striped<Lock> m_locksByKeytab = Striped.lazyWeakLock((int)25);

    @Inject
    public FinalizeKerberosServerAction(TopologyHolder topologyHolder) {
        this.topologyHolder = topologyHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CommandReport processIdentity(ResolvedKerberosPrincipal resolvedPrincipal, KerberosOperationHandler operationHandler, Map<String, String> kerberosConfiguration, boolean includedInFilter, Map<String, Object> requestSharedDataContext) throws OBDPException {
        Map<String, String> principalPasswordMap;
        if (resolvedPrincipal != null && StageUtils.getHostName().equals(resolvedPrincipal.getHostName()) && ((principalPasswordMap = FinalizeKerberosServerAction.getPrincipalPasswordMap(requestSharedDataContext)) == null || !principalPasswordMap.containsKey(resolvedPrincipal.getPrincipal()))) {
            String keytabFilePath = resolvedPrincipal.getKeytabPath();
            if (StringUtils.isEmpty((CharSequence)keytabFilePath)) {
                return null;
            }
            Lock lock = (Lock)this.m_locksByKeytab.get((Object)keytabFilePath);
            lock.lock();
            try {
                Set visited = (Set)requestSharedDataContext.get(this.getClass().getName() + "_visited");
                if (!visited.contains(keytabFilePath)) {
                    String message;
                    String ownerName = resolvedPrincipal.getResolvedKerberosKeytab().getOwnerName();
                    String ownerAccess = resolvedPrincipal.getResolvedKerberosKeytab().getOwnerAccess();
                    boolean ownerWritable = "w".equalsIgnoreCase(ownerAccess) || "rw".equalsIgnoreCase(ownerAccess);
                    boolean ownerReadable = "r".equalsIgnoreCase(ownerAccess) || "rw".equalsIgnoreCase(ownerAccess);
                    String groupName = resolvedPrincipal.getResolvedKerberosKeytab().getGroupName();
                    String groupAccess = resolvedPrincipal.getResolvedKerberosKeytab().getGroupAccess();
                    boolean groupWritable = "w".equalsIgnoreCase(groupAccess) || "rw".equalsIgnoreCase(groupAccess);
                    boolean groupReadable = "r".equalsIgnoreCase(groupAccess) || "rw".equalsIgnoreCase(groupAccess);
                    ShellCommandUtil.Result result = ShellCommandUtil.setFileOwner(keytabFilePath, ownerName);
                    if (result.isSuccessful()) {
                        message = String.format("Updated the owner of the keytab file at %s to %s", keytabFilePath, ownerName);
                        LOG.info(message);
                        this.actionLog.writeStdOut(message);
                    } else {
                        message = String.format("Failed to update the owner of the keytab file at %s to %s: %s", keytabFilePath, ownerName, result.getStderr());
                        LOG.error(message);
                        this.actionLog.writeStdOut(message);
                        this.actionLog.writeStdErr(message);
                    }
                    result = ShellCommandUtil.setFileGroup(keytabFilePath, groupName);
                    if (result.isSuccessful()) {
                        message = String.format("Updated the group of the keytab file at %s to %s", keytabFilePath, groupName);
                        LOG.info(message);
                        this.actionLog.writeStdOut(message);
                    } else {
                        message = String.format("Failed to update the group of the keytab file at %s to %s: %s", keytabFilePath, groupName, result.getStderr());
                        LOG.error(message);
                        this.actionLog.writeStdOut(message);
                        this.actionLog.writeStdErr(message);
                    }
                    result = ShellCommandUtil.setFileMode(keytabFilePath, ownerReadable, ownerWritable, false, groupReadable, groupWritable, false, false, false, false);
                    if (result.isSuccessful()) {
                        message = String.format("Updated the access mode of the keytab file at %s to owner:'%s' and group:'%s'", keytabFilePath, ownerAccess, groupAccess);
                        LOG.info(message);
                        this.actionLog.writeStdOut(message);
                    } else {
                        message = String.format("Failed to update the access mode of the keytab file at %s to owner:'%s' and group:'%s': %s", keytabFilePath, ownerAccess, groupAccess, result.getStderr());
                        LOG.error(message);
                        this.actionLog.writeStdOut(message);
                        this.actionLog.writeStdErr(message);
                    }
                    visited.add(keytabFilePath);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return null;
    }

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        String dataDirectoryPath = this.getCommandParameterValue("data_directory");
        if (FinalizeKerberosServerAction.getKDCType(this.getCommandParameters()) != KDCType.NONE) {
            requestSharedDataContext.put(this.getClass().getName() + "_visited", new HashSet());
            this.processIdentities(requestSharedDataContext);
            requestSharedDataContext.remove(this.getClass().getName() + "_visited");
        }
        this.deleteDataDirectory(dataDirectoryPath);
        return this.sendTopologyUpdateEvent();
    }

    private CommandReport sendTopologyUpdateEvent() throws OBDPException, InterruptedException {
        CommandReport commandReport = null;
        try {
            TopologyUpdateEvent updateEvent = this.topologyHolder.getCurrentData();
            this.topologyHolder.updateData(updateEvent);
        }
        catch (Exception e) {
            String message = "Could not send topology update event when enabling kerberos";
            this.actionLog.writeStdErr(message);
            LOG.error(message, (Throwable)e);
            commandReport = this.createCommandReport(1, HostRoleStatus.FAILED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
        }
        return commandReport == null ? this.createCompletedCommandReport() : commandReport;
    }
}

