/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.audit.event.kerberos.DestroyPrincipalKerberosAuditEvent;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.orm.dao.KerberosKeytabDAO;
import id.onyx.obdp.server.orm.dao.KerberosKeytabPrincipalDAO;
import id.onyx.obdp.server.orm.dao.KerberosPrincipalDAO;
import id.onyx.obdp.server.orm.entities.KerberosKeytabEntity;
import id.onyx.obdp.server.orm.entities.KerberosKeytabPrincipalEntity;
import id.onyx.obdp.server.orm.entities.KerberosKeytabServiceMappingEntity;
import id.onyx.obdp.server.orm.entities.KerberosPrincipalEntity;
import id.onyx.obdp.server.security.credential.PrincipalKeyCredential;
import id.onyx.obdp.server.serveraction.kerberos.KDCType;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandlerFactory;
import id.onyx.obdp.server.serveraction.kerberos.KerberosServerAction;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosPrincipal;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestroyPrincipalsServerAction
extends KerberosServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(DestroyPrincipalsServerAction.class);
    @Inject
    private KerberosOperationHandlerFactory kerberosOperationHandlerFactory;
    @Inject
    private KerberosHelper kerberosHelper;
    @Inject
    private KerberosPrincipalDAO kerberosPrincipalDAO;
    @Inject
    private KerberosKeytabPrincipalDAO kerberosKeytabPrincipalDAO;
    @Inject
    private KerberosKeytabDAO kerberosKeytabDAO;
    private Set<String> seenPrincipals = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        List<KerberosKeytabPrincipalEntity> kerberosKeytabPrincipalEntities;
        Map<String, String> commandParameters = this.getCommandParameters();
        KDCType kdcType = DestroyPrincipalsServerAction.getKDCType(commandParameters);
        PrincipalKeyCredential administratorCredential = this.kerberosHelper.getKDCAdministratorCredentials(this.getClusterName());
        String defaultRealm = DestroyPrincipalsServerAction.getDefaultRealm(commandParameters);
        KerberosOperationHandler operationHandler = this.kerberosOperationHandlerFactory.getKerberosOperationHandler(kdcType);
        Map<String, String> kerberosConfiguration = this.getConfigurationProperties("kerberos-env");
        try {
            operationHandler.open(administratorCredential, defaultRealm, kerberosConfiguration);
        }
        catch (KerberosOperationException e) {
            String message = String.format("Failed to process the identities, could not properly open the KDC operation handler: %s", e.getMessage());
            this.actionLog.writeStdErr(message);
            LOG.error(message);
            throw new OBDPException(message, (Throwable)e);
        }
        this.actionLog.writeStdOut("Cleaning up Kerberos identities.");
        Map<String, Collection<String>> serviceComponentFilter = this.getServiceComponentFilter();
        Set<String> hostFilter = this.getHostFilter();
        Collection<String> principalNameFilter = this.getIdentityFilter();
        if (MapUtils.isEmpty(serviceComponentFilter) && CollectionUtils.isEmpty(hostFilter) && CollectionUtils.isEmpty(principalNameFilter)) {
            kerberosKeytabPrincipalEntities = this.kerberosKeytabPrincipalDAO.findAll();
        } else {
            ArrayList<KerberosKeytabPrincipalDAO.KerberosKeytabPrincipalFilter> filters = new ArrayList<KerberosKeytabPrincipalDAO.KerberosKeytabPrincipalFilter>();
            if (MapUtils.isEmpty(serviceComponentFilter)) {
                filters.add(KerberosKeytabPrincipalDAO.KerberosKeytabPrincipalFilter.createFilter(null, null, hostFilter, principalNameFilter));
            } else {
                for (Map.Entry<String, Collection<String>> entry : serviceComponentFilter.entrySet()) {
                    filters.add(KerberosKeytabPrincipalDAO.KerberosKeytabPrincipalFilter.createFilter(entry.getKey(), entry.getValue(), hostFilter, principalNameFilter));
                }
            }
            kerberosKeytabPrincipalEntities = this.kerberosKeytabPrincipalDAO.findByFilters(filters);
        }
        if (kerberosKeytabPrincipalEntities != null) {
            try {
                HashSet<Long> visitedKKPID = new HashSet<Long>();
                for (KerberosKeytabPrincipalEntity kerberosKeytabPrincipalEntity : kerberosKeytabPrincipalEntities) {
                    String message;
                    if (visitedKKPID.contains(kerberosKeytabPrincipalEntity.getKkpId())) continue;
                    visitedKKPID.add(kerberosKeytabPrincipalEntity.getKkpId());
                    KerberosKeytabEntity kerberosKeytabEntity = kerberosKeytabPrincipalEntity.getKerberosKeytabEntity();
                    KerberosPrincipalEntity kerberosPrincipalEntity = kerberosKeytabPrincipalEntity.getKerberosPrincipalEntity();
                    if (serviceComponentFilter == null) {
                        kerberosKeytabPrincipalEntity.setServiceMapping(null);
                    } else {
                        List<KerberosKeytabServiceMappingEntity> serviceMapping = kerberosKeytabPrincipalEntity.getServiceMapping();
                        if (CollectionUtils.isNotEmpty(serviceMapping)) {
                            Iterator<KerberosKeytabServiceMappingEntity> iterator = serviceMapping.iterator();
                            while (iterator.hasNext()) {
                                Collection<String> components;
                                KerberosKeytabServiceMappingEntity entity = iterator.next();
                                if (!serviceComponentFilter.containsKey(entity.getServiceName()) || !CollectionUtils.isEmpty(components = serviceComponentFilter.get(entity.getServiceName())) && !components.contains(entity.getComponentName())) continue;
                                iterator.remove();
                            }
                            kerberosKeytabPrincipalEntity.setServiceMapping(serviceMapping);
                        }
                    }
                    kerberosKeytabPrincipalEntity = this.kerberosKeytabPrincipalDAO.merge(kerberosKeytabPrincipalEntity);
                    if (CollectionUtils.isEmpty(kerberosKeytabPrincipalEntity.getServiceMapping())) {
                        this.kerberosKeytabPrincipalDAO.remove(kerberosKeytabPrincipalEntity);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Cleaning up keytab/principal entry: {}:{}:{}:{}", new Object[]{kerberosKeytabPrincipalEntity.getKkpId(), kerberosKeytabEntity.getKeytabPath(), kerberosPrincipalEntity.getPrincipalName(), kerberosKeytabPrincipalEntity.getHostName()});
                        } else {
                            LOG.info("Cleaning up keytab/principal entry: {}:{}:{}", new Object[]{kerberosKeytabEntity.getKeytabPath(), kerberosPrincipalEntity.getPrincipalName(), kerberosKeytabPrincipalEntity.getHostName()});
                        }
                        kerberosKeytabEntity.getKerberosKeytabPrincipalEntities().remove(kerberosKeytabPrincipalEntity);
                        kerberosKeytabEntity = this.kerberosKeytabDAO.merge(kerberosKeytabEntity);
                        kerberosPrincipalEntity.getKerberosKeytabPrincipalEntities().remove(kerberosKeytabPrincipalEntity);
                        kerberosPrincipalEntity = this.kerberosPrincipalDAO.merge(kerberosPrincipalEntity);
                    }
                    if (this.kerberosKeytabDAO.removeIfNotReferenced(kerberosKeytabEntity)) {
                        message = String.format("Cleaning up keytab entry: %s", kerberosKeytabEntity.getKeytabPath());
                        LOG.info(message);
                        this.actionLog.writeStdOut(message);
                    }
                    if (!this.kerberosPrincipalDAO.removeIfNotReferenced(kerberosPrincipalEntity)) continue;
                    message = String.format("Cleaning up principal entry: %s", kerberosPrincipalEntity.getPrincipalName());
                    LOG.info(message);
                    this.actionLog.writeStdOut(message);
                    this.destroyIdentity(operationHandler, kerberosPrincipalEntity);
                }
            }
            finally {
                try {
                    operationHandler.close();
                }
                catch (KerberosOperationException kerberosOperationException) {}
            }
        }
        return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
    }

    @Override
    protected boolean pruneServiceFilter() {
        return false;
    }

    @Override
    protected CommandReport processIdentity(ResolvedKerberosPrincipal resolvedPrincipal, KerberosOperationHandler operationHandler, Map<String, String> kerberosConfiguration, boolean includedInFilter, Map<String, Object> requestSharedDataContext) throws OBDPException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyIdentity(KerberosOperationHandler operationHandler, KerberosPrincipalEntity kerberosPrincipalEntity) {
        String principalName = kerberosPrincipalEntity.getPrincipalName();
        String message = String.format("Destroying identity, %s", principalName);
        LOG.info(message);
        this.actionLog.writeStdOut(message);
        DestroyPrincipalKerberosAuditEvent.DestroyPrincipalKerberosAuditEventBuilder auditEventBuilder = ((DestroyPrincipalKerberosAuditEvent.DestroyPrincipalKerberosAuditEventBuilder)((DestroyPrincipalKerberosAuditEvent.DestroyPrincipalKerberosAuditEventBuilder)((DestroyPrincipalKerberosAuditEvent.DestroyPrincipalKerberosAuditEventBuilder)DestroyPrincipalKerberosAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestId(this.getHostRoleCommand().getRequestId())).withTaskId(this.getHostRoleCommand().getTaskId())).withPrincipal(principalName);
        try {
            try {
                operationHandler.removePrincipal(principalName, kerberosPrincipalEntity.isService());
            }
            catch (KerberosOperationException e) {
                message = String.format("Failed to remove identity for %s from the KDC - %s", principalName, e.getMessage());
                LOG.warn(message, (Throwable)e);
                this.actionLog.writeStdErr(message);
                auditEventBuilder.withReasonOfFailure(message);
            }
            try {
                String cachedKeytabPath;
                KerberosPrincipalEntity principalEntity = this.kerberosPrincipalDAO.find(principalName);
                if (principalEntity != null && (cachedKeytabPath = principalEntity.getCachedKeytabPath()) != null && !new File(cachedKeytabPath).delete()) {
                    LOG.debug("Failed to remove cached keytab for {}", (Object)principalName);
                }
            }
            catch (Throwable t) {
                message = String.format("Failed to remove identity for %s from the Ambari database - %s", principalName, t.getMessage());
                LOG.warn(message, t);
                this.actionLog.writeStdErr(message);
                auditEventBuilder.withReasonOfFailure(message);
            }
        }
        finally {
            this.auditLog(auditEventBuilder.build());
        }
    }
}

