/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class DeconstructedPrincipal {
    private static Pattern PATTERN_PRINCIPAL = Pattern.compile("^([^ /@]+)(?:/([^ /@]+))?(?:@(.+)?)?$");
    private final String primary;
    private final String instance;
    private final String realm;
    private final String principalName;
    private final String normalizedPrincipal;

    public static DeconstructedPrincipal valueOf(String principal, @Nullable String defaultRealm) {
        if (principal == null) {
            throw new IllegalArgumentException("The principal may not be null");
        }
        Matcher matcher = PATTERN_PRINCIPAL.matcher(principal);
        if (matcher.matches()) {
            String primary = matcher.group(1);
            String instance = matcher.group(2);
            String realm = matcher.group(3);
            if (realm == null || realm.isEmpty()) {
                realm = defaultRealm;
            }
            return new DeconstructedPrincipal(primary, instance, realm);
        }
        throw new IllegalArgumentException(String.format("Invalid principal value: %s", principal));
    }

    protected DeconstructedPrincipal(String primary, String instance, String realm) {
        this.primary = primary;
        this.instance = instance;
        this.realm = realm;
        StringBuilder builder = new StringBuilder();
        if (this.primary != null) {
            builder.append(primary);
        }
        if (this.instance != null) {
            builder.append('/');
            builder.append(this.instance);
        }
        this.principalName = builder.toString();
        if (this.realm != null) {
            builder.append('@');
            builder.append(this.realm);
        }
        this.normalizedPrincipal = builder.toString();
    }

    public String getPrimary() {
        return this.primary;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public String getNormalizedPrincipal() {
        return this.normalizedPrincipal;
    }
}

