/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import com.google.common.util.concurrent.Striped;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.audit.event.kerberos.CreatePrincipalKerberosAuditEvent;
import id.onyx.obdp.server.orm.dao.KerberosKeytabPrincipalDAO;
import id.onyx.obdp.server.orm.dao.KerberosPrincipalDAO;
import id.onyx.obdp.server.orm.entities.KerberosKeytabPrincipalEntity;
import id.onyx.obdp.server.orm.entities.KerberosPrincipalEntity;
import id.onyx.obdp.server.security.SecurePasswordHelper;
import id.onyx.obdp.server.serveraction.ActionLog;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.KerberosPrincipalAlreadyExistsException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosPrincipalDoesNotExistException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosServerAction;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosPrincipal;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePrincipalsServerAction
extends KerberosServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(CreatePrincipalsServerAction.class);
    @Inject
    private KerberosPrincipalDAO kerberosPrincipalDAO;
    @Inject
    private SecurePasswordHelper securePasswordHelper;
    @Inject
    private KerberosKeytabPrincipalDAO kerberosKeytabPrincipalDAO;
    private Striped<Lock> locksByPrincipal = Striped.lazyWeakLock((int)25);
    private Set<String> seenPrincipals = new HashSet<String>();

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        return this.processIdentities(requestSharedDataContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CommandReport processIdentity(ResolvedKerberosPrincipal resolvedPrincipal, KerberosOperationHandler operationHandler, Map<String, String> kerberosConfiguration, boolean includedInFilter, Map<String, Object> requestSharedDataContext) throws OBDPException {
        CommandReport commandReport;
        block10: {
            commandReport = null;
            if (!this.seenPrincipals.contains(resolvedPrincipal.getPrincipal())) {
                File file;
                boolean processPrincipal;
                this.seenPrincipals.add(resolvedPrincipal.getPrincipal());
                KerberosPrincipalEntity kerberosPrincipalEntity = this.kerberosPrincipalDAO.find(resolvedPrincipal.getPrincipal());
                boolean regenerateKeytabs = CreatePrincipalsServerAction.getOperationType(this.getCommandParameters()) == KerberosServerAction.OperationType.RECREATE_ALL;
                boolean servicePrincipal = resolvedPrincipal.isService();
                if (!includedInFilter) {
                    regenerateKeytabs = false;
                }
                if (processPrincipal = regenerateKeytabs ? !this.hasHostFilters() || servicePrincipal : (kerberosPrincipalEntity == null ? true : (!StringUtils.isEmpty((String)kerberosPrincipalEntity.getCachedKeytabPath()) ? !(file = new File(kerberosPrincipalEntity.getCachedKeytabPath())).exists() : true))) {
                    Map<String, String> principalPasswordMap = CreatePrincipalsServerAction.getPrincipalPasswordMap(requestSharedDataContext);
                    String principal = resolvedPrincipal.getPrincipal();
                    Lock lock = (Lock)this.locksByPrincipal.get((Object)principal);
                    lock.lock();
                    String password = principalPasswordMap.get(principal);
                    try {
                        if (password != null) break block10;
                        CreatePrincipalResult result = this.createPrincipal(resolvedPrincipal.getPrincipal(), servicePrincipal, kerberosConfiguration, operationHandler, regenerateKeytabs, this.actionLog);
                        if (result == null) {
                            commandReport = this.createCommandReport(1, HostRoleStatus.FAILED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
                            break block10;
                        }
                        Map<String, Integer> principalKeyNumberMap = CreatePrincipalsServerAction.getPrincipalKeyNumberMap(requestSharedDataContext);
                        principalPasswordMap.put(resolvedPrincipal.getPrincipal(), result.getPassword());
                        principalKeyNumberMap.put(resolvedPrincipal.getPrincipal(), result.getKeyNumber());
                        for (KerberosKeytabPrincipalEntity kkpe : this.kerberosKeytabPrincipalDAO.findByPrincipal(resolvedPrincipal.getPrincipal())) {
                            kkpe.setDistributed(false);
                            this.kerberosKeytabPrincipalDAO.merge(kkpe);
                        }
                        KerberosPrincipalEntity principalEntity = this.kerberosPrincipalDAO.find(resolvedPrincipal.getPrincipal());
                        try {
                            new File(principalEntity.getCachedKeytabPath()).delete();
                        }
                        catch (Exception e) {
                            LOG.debug("Failed to delete cache file '{}'", (Object)principalEntity.getCachedKeytabPath());
                        }
                        principalEntity.setCachedKeytabPath(null);
                        this.kerberosPrincipalDAO.merge(principalEntity);
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
        }
        return commandReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreatePrincipalResult createPrincipal(String principal, boolean isServicePrincipal, Map<String, String> kerberosConfiguration, KerberosOperationHandler kerberosOperationHandler, boolean regenerateKeytabs, ActionLog actionLog) {
        CreatePrincipalResult result;
        CreatePrincipalKerberosAuditEvent.CreatePrincipalKerberosAuditEventBuilder auditEventBuilder;
        block21: {
            auditEventBuilder = ((CreatePrincipalKerberosAuditEvent.CreatePrincipalKerberosAuditEventBuilder)((CreatePrincipalKerberosAuditEvent.CreatePrincipalKerberosAuditEventBuilder)((CreatePrincipalKerberosAuditEvent.CreatePrincipalKerberosAuditEventBuilder)CreatePrincipalKerberosAuditEvent.builder().withTimestamp(System.currentTimeMillis())).withRequestId(this.getHostRoleCommand() != null ? this.getHostRoleCommand().getRequestId() : -1L)).withTaskId(this.getHostRoleCommand() != null ? this.getHostRoleCommand().getTaskId() : -1L)).withPrincipal(principal);
            result = null;
            String message = null;
            try {
                block20: {
                    Integer minWhitespace;
                    Integer minPunctuation;
                    Integer minDigits;
                    Integer minUppercaseLetters;
                    Integer minLowercaseLetters;
                    Integer length;
                    message = String.format("Processing principal, %s", principal);
                    LOG.info(message);
                    if (actionLog != null) {
                        actionLog.writeStdOut(message);
                    }
                    if (kerberosConfiguration == null) {
                        length = null;
                        minLowercaseLetters = null;
                        minUppercaseLetters = null;
                        minDigits = null;
                        minPunctuation = null;
                        minWhitespace = null;
                    } else {
                        length = CreatePrincipalsServerAction.toInt(kerberosConfiguration.get("password_length"));
                        minLowercaseLetters = CreatePrincipalsServerAction.toInt(kerberosConfiguration.get("password_min_lowercase_letters"));
                        minUppercaseLetters = CreatePrincipalsServerAction.toInt(kerberosConfiguration.get("password_min_uppercase_letters"));
                        minDigits = CreatePrincipalsServerAction.toInt(kerberosConfiguration.get("password_min_digits"));
                        minPunctuation = CreatePrincipalsServerAction.toInt(kerberosConfiguration.get("password_min_punctuation"));
                        minWhitespace = CreatePrincipalsServerAction.toInt(kerberosConfiguration.get("password_min_whitespace"));
                    }
                    String password = this.securePasswordHelper.createSecurePassword(length, minLowercaseLetters, minUppercaseLetters, minDigits, minPunctuation, minWhitespace);
                    try {
                        boolean created;
                        Integer keyNumber;
                        if (regenerateKeytabs) {
                            try {
                                keyNumber = kerberosOperationHandler.setPrincipalPassword(principal, password, isServicePrincipal);
                                created = false;
                            }
                            catch (KerberosPrincipalDoesNotExistException e) {
                                message = String.format("Principal, %s, does not exist, creating new principal", principal);
                                LOG.warn(message);
                                if (actionLog != null) {
                                    actionLog.writeStdOut(message);
                                }
                                keyNumber = kerberosOperationHandler.createPrincipal(principal, password, isServicePrincipal);
                                created = true;
                            }
                        } else {
                            try {
                                keyNumber = kerberosOperationHandler.createPrincipal(principal, password, isServicePrincipal);
                                created = true;
                            }
                            catch (KerberosPrincipalAlreadyExistsException e) {
                                message = String.format("Principal, %s, already exists, setting new password", principal);
                                LOG.warn(message);
                                if (actionLog != null) {
                                    actionLog.writeStdOut(message);
                                }
                                keyNumber = kerberosOperationHandler.setPrincipalPassword(principal, password, isServicePrincipal);
                                created = false;
                            }
                        }
                        if (keyNumber != null) {
                            result = new CreatePrincipalResult(principal, password, keyNumber);
                            message = created ? String.format("Successfully created new principal, %s", principal) : String.format("Successfully set password for %s", principal);
                            LOG.debug(message);
                        } else {
                            message = created ? String.format("Failed to create principal, %s - unknown reason", principal) : String.format("Failed to set password for %s - unknown reason", principal);
                            LOG.error(message);
                            if (actionLog != null) {
                                actionLog.writeStdErr(message);
                            }
                        }
                        if (!this.kerberosPrincipalDAO.exists(principal)) {
                            this.kerberosPrincipalDAO.create(principal, isServicePrincipal);
                        }
                    }
                    catch (KerberosOperationException e) {
                        message = String.format("Failed to create principal, %s - %s", principal, e.getMessage());
                        LOG.error(message, (Throwable)e);
                        if (actionLog == null) break block20;
                        actionLog.writeStdErr(message);
                    }
                }
                if (result != null) break block21;
                auditEventBuilder.withReasonOfFailure(message == null ? "Unknown error" : message);
            }
            catch (Throwable throwable) {
                if (result == null) {
                    auditEventBuilder.withReasonOfFailure(message == null ? "Unknown error" : message);
                }
                this.auditLog(auditEventBuilder.build());
                throw throwable;
            }
        }
        this.auditLog(auditEventBuilder.build());
        return result;
    }

    private static Integer toInt(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static class CreatePrincipalResult {
        private final String principal;
        private final String password;
        private final Integer keyNumber;

        public CreatePrincipalResult(String principal, String password, Integer keyNumber) {
            this.principal = principal;
            this.password = password;
            this.keyNumber = keyNumber;
        }

        public String getPrincipal() {
            return this.principal;
        }

        public String getPassword() {
            return this.password;
        }

        public Integer getKeyNumber() {
            return this.keyNumber;
        }
    }
}

