/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import com.google.common.util.concurrent.Striped;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.audit.event.kerberos.CreateKeyTabKerberosAuditEvent;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.dao.KerberosPrincipalDAO;
import id.onyx.obdp.server.orm.entities.KerberosPrincipalEntity;
import id.onyx.obdp.server.serveraction.ActionLog;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.KerberosServerAction;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.KerberosKeytabController;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosKeytab;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosPrincipal;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateKeytabFilesServerAction
extends KerberosServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(CreateKeytabFilesServerAction.class);
    @Inject
    private KerberosPrincipalDAO kerberosPrincipalDAO;
    @Inject
    private Configuration configuration;
    @Inject
    private KerberosKeytabController kerberosKeytabController;
    private Striped<Lock> m_locksByKeytab = Striped.lazyWeakLock((int)25);
    Map<String, Set<String>> visitedIdentities = new ConcurrentHashMap<String, Set<String>>();

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        return this.processIdentities(requestSharedDataContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CommandReport processIdentity(ResolvedKerberosPrincipal resolvedPrincipal, KerberosOperationHandler operationHandler, Map<String, String> kerberosConfiguration, boolean includedInFilter, Map<String, Object> requestSharedDataContext) throws OBDPException {
        CommandReport commandReport;
        CreateKeyTabKerberosAuditEvent.CreateKeyTabKerberosAuditEventBuilder auditEventBuilder;
        block29: {
            auditEventBuilder = CreateKeyTabKerberosAuditEvent.builder();
            auditEventBuilder.withTimestamp(System.currentTimeMillis());
            auditEventBuilder.withRequestId(this.getHostRoleCommand() != null ? this.getHostRoleCommand().getRequestId() : -1L);
            auditEventBuilder.withTaskId(this.getHostRoleCommand() != null ? this.getHostRoleCommand().getTaskId() : -1L);
            commandReport = null;
            String message = null;
            Set<ResolvedKerberosKeytab> keytabsToCreate = this.kerberosKeytabController.getFromPrincipalExceptServiceMapping(resolvedPrincipal);
            KerberosPrincipalEntity principalEntity = this.kerberosPrincipalDAO.find(resolvedPrincipal.getPrincipal());
            try {
                String dataDirectory = this.getDataDirectoryPath();
                if (operationHandler == null) {
                    message = String.format("Failed to create keytab file for %s, missing KerberosOperationHandler", resolvedPrincipal.getPrincipal());
                    this.actionLog.writeStdErr(message);
                    LOG.error(message);
                    commandReport = this.createCommandReport(1, HostRoleStatus.FAILED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
                } else if (dataDirectory == null) {
                    message = "The data directory has not been set. Generated keytab files can not be stored.";
                    LOG.error(message);
                    commandReport = this.createCommandReport(1, HostRoleStatus.FAILED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
                } else {
                    Map<String, String> principalPasswordMap = CreateKeytabFilesServerAction.getPrincipalPasswordMap(requestSharedDataContext);
                    Map<String, Integer> principalKeyNumberMap = CreateKeytabFilesServerAction.getPrincipalKeyNumberMap(requestSharedDataContext);
                    for (ResolvedKerberosKeytab rkk : keytabsToCreate) {
                        String hostName = resolvedPrincipal.getHostName();
                        String keytabFilePath = rkk.getFile();
                        if (hostName == null || hostName.isEmpty() || keytabFilePath == null || keytabFilePath.isEmpty()) continue;
                        Lock lock = (Lock)this.m_locksByKeytab.get((Object)keytabFilePath);
                        lock.lock();
                        try {
                            Set<String> visitedPrincipalKeys = this.visitedIdentities.get(resolvedPrincipal.getPrincipal());
                            String visitationKey = String.format("%s|%s", hostName, keytabFilePath);
                            if (visitedPrincipalKeys == null || !visitedPrincipalKeys.contains(visitationKey)) {
                                String password = principalPasswordMap.get(resolvedPrincipal.getPrincipal());
                                Integer keyNumber = principalKeyNumberMap.get(resolvedPrincipal.getPrincipal());
                                message = String.format("Creating keytab file for %s on host %s", resolvedPrincipal.getPrincipal(), hostName);
                                LOG.info(message);
                                this.actionLog.writeStdOut(message);
                                auditEventBuilder.withPrincipal(resolvedPrincipal.getPrincipal()).withHostName(hostName).withKeyTabFilePath(keytabFilePath);
                                File hostDirectory = new File(dataDirectory, hostName);
                                if (!hostDirectory.exists() && hostDirectory.mkdirs()) {
                                    this.ensureAmbariOnlyAccess(hostDirectory);
                                }
                                if (hostDirectory.exists()) {
                                    block28: {
                                        String cachedKeytabPath;
                                        boolean regenerateKeytabs;
                                        File destinationKeytabFile = new File(hostDirectory, DigestUtils.sha256Hex((String)keytabFilePath));
                                        boolean bl = regenerateKeytabs = CreateKeytabFilesServerAction.getOperationType(this.getCommandParameters()) == KerberosServerAction.OperationType.RECREATE_ALL;
                                        if (!includedInFilter) {
                                            regenerateKeytabs = false;
                                        }
                                        String string = cachedKeytabPath = principalEntity == null ? null : principalEntity.getCachedKeytabPath();
                                        if (password == null) {
                                            if (!regenerateKeytabs && hostName.equalsIgnoreCase("obdp_server")) {
                                                message = String.format("Skipping keytab file for %s, missing password indicates nothing to do", resolvedPrincipal.getPrincipal());
                                                LOG.info(message);
                                                continue;
                                            }
                                            if (cachedKeytabPath == null) {
                                                message = String.format("Failed to create keytab for %s, missing cached file", resolvedPrincipal.getPrincipal());
                                                this.actionLog.writeStdErr(message);
                                                LOG.error(message);
                                                commandReport = this.createCommandReport(1, HostRoleStatus.FAILED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
                                                continue;
                                            }
                                            try {
                                                operationHandler.createKeytabFile(new File(cachedKeytabPath), destinationKeytabFile);
                                            }
                                            catch (KerberosOperationException e) {
                                                message = String.format("Failed to create keytab file for %s - %s", resolvedPrincipal.getPrincipal(), e.getMessage());
                                                this.actionLog.writeStdErr(message);
                                                LOG.error(message, (Throwable)e);
                                                commandReport = this.createCommandReport(1, HostRoleStatus.FAILED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
                                            }
                                            continue;
                                        }
                                        Keytab keytab = this.createKeytab(resolvedPrincipal.getPrincipal(), principalEntity, password, keyNumber, operationHandler, visitedPrincipalKeys != null, true, this.actionLog);
                                        if (keytab != null) {
                                            try {
                                                if (operationHandler.createKeytabFile(keytab, destinationKeytabFile)) {
                                                    this.ensureAmbariOnlyAccess(destinationKeytabFile);
                                                    message = String.format("Successfully created keytab file for %s at %s", resolvedPrincipal.getPrincipal(), destinationKeytabFile.getAbsolutePath());
                                                    LOG.info(message);
                                                    auditEventBuilder.withPrincipal(resolvedPrincipal.getPrincipal()).withHostName(hostName).withKeyTabFilePath(destinationKeytabFile.getAbsolutePath());
                                                    break block28;
                                                }
                                                message = String.format("Failed to create keytab file for %s at %s", resolvedPrincipal.getPrincipal(), destinationKeytabFile.getAbsolutePath());
                                                this.actionLog.writeStdErr(message);
                                                LOG.error(message);
                                                commandReport = this.createCommandReport(1, HostRoleStatus.FAILED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
                                            }
                                            catch (KerberosOperationException e) {
                                                message = String.format("Failed to create keytab file for %s - %s", resolvedPrincipal.getPrincipal(), e.getMessage());
                                                this.actionLog.writeStdErr(message);
                                                LOG.error(message, (Throwable)e);
                                                commandReport = this.createCommandReport(1, HostRoleStatus.FAILED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
                                            }
                                        } else {
                                            commandReport = this.createCommandReport(1, HostRoleStatus.FAILED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
                                        }
                                    }
                                    if (visitedPrincipalKeys == null) {
                                        visitedPrincipalKeys = new HashSet<String>();
                                        this.visitedIdentities.put(resolvedPrincipal.getPrincipal(), visitedPrincipalKeys);
                                    }
                                    visitedPrincipalKeys.add(visitationKey);
                                    continue;
                                }
                                message = String.format("Failed to create keytab file for %s, the container directory does not exist: %s", resolvedPrincipal.getPrincipal(), hostDirectory.getAbsolutePath());
                                this.actionLog.writeStdErr(message);
                                LOG.error(message);
                                commandReport = this.createCommandReport(1, HostRoleStatus.FAILED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
                                continue;
                            }
                            LOG.debug("Skipping previously processed keytab for {} on host {}", (Object)resolvedPrincipal.getPrincipal(), (Object)hostName);
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }
                if (commandReport == null || !HostRoleStatus.FAILED.toString().equals(commandReport.getStatus())) break block29;
                auditEventBuilder.withReasonOfFailure(message == null ? "Unknown error" : message);
            }
            catch (Throwable throwable) {
                if (commandReport != null && HostRoleStatus.FAILED.toString().equals(commandReport.getStatus())) {
                    auditEventBuilder.withReasonOfFailure(message == null ? "Unknown error" : message);
                }
                if (commandReport != null || auditEventBuilder.hasPrincipal()) {
                    this.auditLog(auditEventBuilder.build());
                }
                throw throwable;
            }
        }
        if (commandReport != null || auditEventBuilder.hasPrincipal()) {
            this.auditLog(auditEventBuilder.build());
        }
        return commandReport;
    }

    public Keytab createKeytab(String principal, KerberosPrincipalEntity principalEntity, String password, Integer keyNumber, KerberosOperationHandler operationHandler, boolean checkCache, boolean canCache, ActionLog actionLog) throws OBDPException {
        LOG.debug("Creating keytab for {} with kvno {}", (Object)principal, (Object)keyNumber);
        Keytab keytab = null;
        if (checkCache) {
            String cachedKeytabPath;
            String string = cachedKeytabPath = principalEntity == null ? null : principalEntity.getCachedKeytabPath();
            if (cachedKeytabPath != null) {
                try {
                    keytab = Keytab.read((File)new File(cachedKeytabPath));
                }
                catch (IOException e) {
                    LOG.warn("Failed to read the cached keytab for {}, recreating if possible - {}", (Object)principal, (Object)e.getMessage());
                }
            }
        }
        if (keytab == null) {
            try {
                keytab = operationHandler.createKeytab(principal, password, keyNumber);
                if (principalEntity != null && canCache) {
                    String cachedKeytabFilePath;
                    File cachedKeytabFile = this.cacheKeytab(principal, keytab);
                    String previousCachedFilePath = principalEntity.getCachedKeytabPath();
                    String string = cachedKeytabFilePath = cachedKeytabFile.exists() ? cachedKeytabFile.getAbsolutePath() : null;
                    if (previousCachedFilePath == null || !previousCachedFilePath.equals(cachedKeytabFilePath)) {
                        principalEntity.setCachedKeytabPath(cachedKeytabFilePath);
                        this.kerberosPrincipalDAO.merge(principalEntity);
                    }
                    if (previousCachedFilePath != null && !new File(previousCachedFilePath).delete()) {
                        LOG.debug("Failed to remove orphaned cache file {}", (Object)previousCachedFilePath);
                    }
                }
            }
            catch (KerberosOperationException e) {
                String message = String.format("Failed to create keytab file for %s - %s", principal, e.getMessage());
                if (actionLog != null) {
                    actionLog.writeStdErr(message);
                }
                LOG.error(message, (Throwable)e);
            }
        }
        return keytab;
    }

    private File cacheKeytab(String principal, Keytab keytab) throws OBDPException {
        File cacheDirectory = this.configuration.getKerberosKeytabCacheDir();
        if (cacheDirectory == null) {
            String message = "The Kerberos keytab cache directory is not configured in the Ambari properties";
            LOG.error(message);
            throw new OBDPException(message);
        }
        if (!cacheDirectory.exists() && cacheDirectory.mkdirs()) {
            this.ensureAmbariOnlyAccess(cacheDirectory);
            if (!cacheDirectory.exists()) {
                String message = String.format("Failed to create the keytab cache directory %s", cacheDirectory.getAbsolutePath());
                LOG.error(message);
                throw new OBDPException(message);
            }
        }
        File cachedKeytabFile = new File(cacheDirectory, DigestUtils.sha256Hex((String)(principal + String.valueOf(System.currentTimeMillis()))));
        try {
            keytab.write(cachedKeytabFile);
        }
        catch (IOException e) {
            String message = String.format("Failed to write the keytab for %s to the cache location (%s)", principal, cachedKeytabFile.getAbsolutePath());
            LOG.error(message, (Throwable)e);
            throw new OBDPException(message, (Throwable)e);
        }
        this.ensureAmbariOnlyAccess(cachedKeytabFile);
        return cachedKeytabFile;
    }

    protected void ensureAmbariOnlyAccess(File file) throws OBDPException {
        if (file.exists()) {
            if (!file.setReadable(false, false) || !file.setReadable(true, true)) {
                String message = String.format("Failed to set %s readable only by Ambari", file.getAbsolutePath());
                LOG.warn(message);
                throw new OBDPException(message);
            }
            if (!file.setWritable(false, false) || !file.setWritable(true, true)) {
                String message = String.format("Failed to set %s writable only by Ambari", file.getAbsolutePath());
                LOG.warn(message);
                throw new OBDPException(message);
            }
            if (file.isDirectory()) {
                if (!file.setExecutable(false, false) || !file.setExecutable(true, true)) {
                    String message = String.format("Failed to set %s executable by Ambari", file.getAbsolutePath());
                    LOG.warn(message);
                    throw new OBDPException(message);
                }
            } else if (!file.setExecutable(false, false)) {
                String message = String.format("Failed to set %s not executable", file.getAbsolutePath());
                LOG.warn(message);
                throw new OBDPException(message);
            }
        }
    }
}

