/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import com.google.common.util.concurrent.Striped;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.orm.dao.HostDAO;
import id.onyx.obdp.server.orm.dao.KerberosKeytabDAO;
import id.onyx.obdp.server.orm.dao.KerberosKeytabPrincipalDAO;
import id.onyx.obdp.server.orm.dao.KerberosPrincipalDAO;
import id.onyx.obdp.server.orm.entities.HostEntity;
import id.onyx.obdp.server.orm.entities.KerberosKeytabEntity;
import id.onyx.obdp.server.orm.entities.KerberosKeytabPrincipalEntity;
import id.onyx.obdp.server.orm.entities.KerberosPrincipalEntity;
import id.onyx.obdp.server.serveraction.ActionLog;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.KerberosServerAction;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosKeytab;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosPrincipal;
import id.onyx.obdp.server.utils.ShellCommandUtil;
import id.onyx.obdp.server.utils.StageUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigureOBDPIdentitiesServerAction
extends KerberosServerAction {
    private static final String KEYTAB_PATTERN = "keyTab=\"(.+)?\"";
    private static final String PRINCIPAL_PATTERN = "principal=\"(.+)?\"";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigureOBDPIdentitiesServerAction.class);
    @Inject
    private KerberosKeytabDAO kerberosKeytabDAO;
    @Inject
    private KerberosKeytabPrincipalDAO kerberosKeytabPrincipalDAO;
    @Inject
    private KerberosPrincipalDAO kerberosPrincipalDAO;
    @Inject
    private HostDAO hostDAO;
    private Striped<Lock> m_locksByKeytab = Striped.lazyWeakLock((int)25);

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        return this.processIdentities(requestSharedDataContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CommandReport processIdentity(ResolvedKerberosPrincipal resolvedPrincipal, KerberosOperationHandler operationHandler, Map<String, String> kerberosConfiguration, boolean includedInFilter, Map<String, Object> requestSharedDataContext) throws OBDPException {
        CommandReport commandReport = null;
        if (includedInFilter && resolvedPrincipal != null && StageUtils.getHostName().equals(resolvedPrincipal.getHostName())) {
            String hostName = resolvedPrincipal.getHostName();
            String dataDirectory = this.getDataDirectoryPath();
            for (Map.Entry serviceMappingEntry : resolvedPrincipal.getServiceMapping().entries()) {
                if (!RootService.OBDP.name().equals(serviceMappingEntry.getKey())) continue;
                ResolvedKerberosKeytab keytab = resolvedPrincipal.getResolvedKerberosKeytab();
                String destKeytabFilePath = resolvedPrincipal.getResolvedKerberosKeytab().getFile();
                File hostDirectory = new File(dataDirectory, hostName);
                File srcKeytabFile = new File(hostDirectory, DigestUtils.sha256Hex((String)destKeytabFilePath));
                Lock lock = (Lock)this.m_locksByKeytab.get((Object)destKeytabFilePath);
                lock.lock();
                try {
                    if (!srcKeytabFile.exists()) continue;
                    String ownerAccess = keytab.getOwnerAccess();
                    String groupAccess = keytab.getGroupAccess();
                    this.installAmbariServerIdentity(resolvedPrincipal, srcKeytabFile.getAbsolutePath(), destKeytabFilePath, keytab.getOwnerName(), ownerAccess, keytab.getGroupName(), groupAccess, this.actionLog);
                    if (!((String)serviceMappingEntry.getValue()).contains("AMBARI_SERVER_SELF")) continue;
                    this.configureJAAS(resolvedPrincipal.getPrincipal(), destKeytabFilePath, this.actionLog);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return commandReport;
    }

    public boolean installAmbariServerIdentity(ResolvedKerberosPrincipal principal, String srcKeytabFilePath, String destKeytabFilePath, String ownerName, String ownerAccess, String groupName, String groupAccess, ActionLog actionLog) throws OBDPException {
        try {
            KerberosPrincipalEntity kpe;
            KerberosKeytabEntity kke;
            boolean ownerWritable = "w".equalsIgnoreCase(ownerAccess) || "rw".equalsIgnoreCase(ownerAccess);
            boolean ownerReadable = "r".equalsIgnoreCase(ownerAccess) || "rw".equalsIgnoreCase(ownerAccess);
            boolean groupWritable = "w".equalsIgnoreCase(groupAccess) || "rw".equalsIgnoreCase(groupAccess);
            boolean groupReadable = "r".equalsIgnoreCase(groupAccess) || "rw".equalsIgnoreCase(groupAccess);
            this.copyFile(srcKeytabFilePath, destKeytabFilePath);
            this.setFileACL(destKeytabFilePath, ownerName, ownerReadable, ownerWritable, groupName, groupReadable, groupWritable);
            Long ambariServerHostID = this.ambariServerHostID();
            HostEntity hostEntity = null;
            if (ambariServerHostID != null) {
                hostEntity = this.hostDAO.findById(ambariServerHostID);
            }
            if ((kke = this.kerberosKeytabDAO.find(destKeytabFilePath)) == null) {
                kke = new KerberosKeytabEntity(destKeytabFilePath);
                kke.setOwnerName(ownerName);
                kke.setOwnerAccess(ownerAccess);
                kke.setGroupName(groupName);
                kke.setGroupAccess(groupAccess);
                this.kerberosKeytabDAO.create(kke);
            }
            if ((kpe = this.kerberosPrincipalDAO.find(principal.getPrincipal())) == null) {
                kpe = new KerberosPrincipalEntity(principal.getPrincipal(), principal.isService(), principal.getCacheFile());
                this.kerberosPrincipalDAO.create(kpe);
            }
            for (Map.Entry mapping : principal.getServiceMapping().entries()) {
                String serviceName = (String)mapping.getKey();
                String componentName = (String)mapping.getValue();
                KerberosKeytabPrincipalEntity entity = this.kerberosKeytabPrincipalDAO.findOrCreate((KerberosKeytabEntity)kke, (HostEntity)hostEntity, (KerberosPrincipalEntity)kpe, null).kkp;
                entity.setDistributed(true);
                entity.putServiceMapping(serviceName, componentName);
                this.kerberosKeytabPrincipalDAO.merge(entity);
                kke.addKerberosKeytabPrincipal(entity);
                this.kerberosKeytabDAO.merge(kke);
                kpe.addKerberosKeytabPrincipal(entity);
                this.kerberosPrincipalDAO.merge(kpe);
            }
            if (actionLog != null) {
                actionLog.writeStdOut(String.format("Created Ambari server keytab file for %s at %s", principal, destKeytabFilePath));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new OBDPException(e.getLocalizedMessage(), (Throwable)e);
        }
        return true;
    }

    public void configureJAAS(String principal, String keytabFilePath, ActionLog actionLog) {
        String jaasConfPath = this.getJAASConfFilePath();
        if (jaasConfPath != null) {
            File jaasConfigFile = new File(jaasConfPath);
            try {
                String jaasConfig = FileUtils.readFileToString((File)jaasConfigFile, (Charset)Charset.defaultCharset());
                File oldJaasConfigFile = new File(jaasConfPath + ".bak");
                FileUtils.writeStringToFile((File)oldJaasConfigFile, (String)jaasConfig, (Charset)Charset.defaultCharset());
                jaasConfig = jaasConfig.replaceFirst(KEYTAB_PATTERN, "keyTab=\"" + keytabFilePath + "\"");
                jaasConfig = jaasConfig.replaceFirst(PRINCIPAL_PATTERN, "principal=\"" + principal + "\"");
                FileUtils.writeStringToFile((File)jaasConfigFile, (String)jaasConfig, (Charset)Charset.defaultCharset());
                String message = String.format("JAAS config file %s modified successfully for principal %s.", jaasConfigFile.getName(), principal);
                if (actionLog != null) {
                    actionLog.writeStdOut(message);
                }
            }
            catch (IOException e) {
                String message = String.format("Failed to configure JAAS file %s for %s - %s", jaasConfigFile, principal, e.getMessage());
                if (actionLog != null) {
                    actionLog.writeStdErr(message);
                }
                LOG.error(message, (Throwable)e);
            }
        } else {
            String message = String.format("Failed to configure JAAS, config file should be passed to Ambari server as: %s.", "java.security.auth.login.config");
            if (actionLog != null) {
                actionLog.writeStdErr(message);
            }
            LOG.error(message);
        }
    }

    void copyFile(String srcKeytabFilePath, String destKeytabFilePath) throws IOException, InterruptedException {
        File destKeytabFile = new File(destKeytabFilePath);
        ShellCommandUtil.Result result = ShellCommandUtil.mkdir(destKeytabFile.getParent(), true);
        if (!result.isSuccessful()) {
            throw new OBDPException(result.getStderr());
        }
        result = ShellCommandUtil.copyFile(srcKeytabFilePath, destKeytabFilePath, true, true);
        if (!result.isSuccessful()) {
            throw new OBDPException(result.getStderr());
        }
    }

    void setFileACL(String filePath, String ownerName, boolean ownerReadable, boolean ownerWritable, String groupName, boolean groupReadable, boolean groupWritable) throws OBDPException {
        ShellCommandUtil.Result result = ShellCommandUtil.setFileOwner(filePath, ownerName);
        if (result.isSuccessful()) {
            result = ShellCommandUtil.setFileGroup(filePath, groupName);
            if (!result.isSuccessful()) {
                LOG.warn("Failed to set the group for the file at {} to {}: {}", new Object[]{filePath, groupName, result.getStderr()});
            }
            result = ShellCommandUtil.setFileMode(filePath, ownerReadable, ownerWritable, false, groupReadable, groupWritable, false, false, false, false);
        }
        if (!result.isSuccessful()) {
            throw new OBDPException(result.getStderr());
        }
    }

    String getJAASConfFilePath() {
        return System.getProperty("java.security.auth.login.config");
    }
}

