/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.controller.internal.RequestImpl;
import id.onyx.obdp.server.controller.spi.ClusterController;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.controller.utilities.ClusterControllerHelper;
import id.onyx.obdp.server.controller.utilities.PredicateBuilder;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.KerberosServerAction;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosPrincipal;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.SecurityType;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupServerAction
extends KerberosServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(CleanupServerAction.class);

    @Override
    protected boolean pruneServiceFilter() {
        return false;
    }

    @Override
    protected CommandReport processIdentity(ResolvedKerberosPrincipal resolvedPrincipal, KerberosOperationHandler operationHandler, Map<String, String> kerberosConfiguration, boolean includedInFilter, Map<String, Object> requestSharedDataContext) throws OBDPException {
        return null;
    }

    @Override
    public CommandReport execute(ConcurrentMap<String, Object> requestSharedDataContext) throws OBDPException, InterruptedException {
        Cluster cluster = this.getCluster();
        if (cluster.getSecurityType().equals((Object)SecurityType.NONE)) {
            this.removeKerberosArtifact(cluster);
        }
        return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
    }

    private void removeKerberosArtifact(Cluster cluster) throws OBDPException {
        PredicateBuilder pb = new PredicateBuilder();
        Predicate predicate = pb.begin().property("Artifacts/cluster_name").equals(cluster.getClusterName()).and().property("Artifacts/artifact_name").equals("kerberos_descriptor").end().toPredicate();
        ClusterController clusterController = ClusterControllerHelper.getClusterController();
        ResourceProvider artifactProvider = clusterController.ensureResourceProvider(Resource.Type.Artifact);
        try {
            artifactProvider.deleteResources(new RequestImpl(null, null, null, null), predicate);
            LOG.info("Kerberos descriptor removed successfully.");
            this.actionLog.writeStdOut("Kerberos descriptor removed successfully.");
        }
        catch (NoSuchResourceException e) {
            LOG.warn("The Kerberos descriptor was not found in the database while attempting to remove.");
            this.actionLog.writeStdOut("The Kerberos descriptor was not found in the database while attempting to remove.");
        }
        catch (Exception e) {
            throw new OBDPException("An unknown error occurred while trying to delete the cluster Kerberos descriptor", (Throwable)e);
        }
    }
}

