/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.controller.UpdateConfigurationPolicy;
import id.onyx.obdp.server.orm.dao.KerberosKeytabPrincipalDAO;
import id.onyx.obdp.server.orm.entities.KerberosKeytabPrincipalEntity;
import id.onyx.obdp.server.serveraction.kerberos.Component;
import id.onyx.obdp.server.serveraction.kerberos.KerberosConfigDataFileWriter;
import id.onyx.obdp.server.serveraction.kerberos.KerberosConfigDataFileWriterFactory;
import id.onyx.obdp.server.serveraction.kerberos.KerberosIdentityDataFileWriter;
import id.onyx.obdp.server.serveraction.kerberos.KerberosIdentityDataFileWriterFactory;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.KerberosServerAction;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosKeytab;
import id.onyx.obdp.server.serveraction.kerberos.stageutils.ResolvedKerberosPrincipal;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.kerberos.AbstractKerberosDescriptorContainer;
import id.onyx.obdp.server.state.kerberos.KerberosComponentDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosIdentityDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptor;
import id.onyx.obdp.server.utils.StageUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPrepareKerberosServerAction
extends KerberosServerAction {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPrepareKerberosServerAction.class);
    @Inject
    private KerberosHelper kerberosHelper;
    @Inject
    private KerberosIdentityDataFileWriterFactory kerberosIdentityDataFileWriterFactory;
    @Inject
    private KerberosConfigDataFileWriterFactory kerberosConfigDataFileWriterFactory;
    @Inject
    private ConfigHelper configHelper;
    @Inject
    private KerberosKeytabPrincipalDAO kerberosKeytabPrincipalDAO;

    @Override
    protected CommandReport processIdentity(ResolvedKerberosPrincipal resolvedPrincipal, KerberosOperationHandler operationHandler, Map<String, String> kerberosConfiguration, boolean includedInFilter, Map<String, Object> requestSharedDataContext) throws OBDPException {
        throw new UnsupportedOperationException();
    }

    protected KerberosHelper getKerberosHelper() {
        return this.kerberosHelper;
    }

    public void processServiceComponentHosts(Cluster cluster, KerberosDescriptor kerberosDescriptor, List<ServiceComponentHost> schToProcess, Collection<String> identityFilter, String dataDirectory, Map<String, Map<String, String>> currentConfigurations, Map<String, Map<String, String>> kerberosConfigurations, boolean includeAmbariIdentity, Map<String, Set<String>> propertiesToBeIgnored) throws OBDPException {
        ArrayList<Component> components = new ArrayList<Component>();
        for (ServiceComponentHost each : schToProcess) {
            components.add(Component.fromServiceComponentHost(each));
        }
        this.processServiceComponents(cluster, kerberosDescriptor, components, identityFilter, dataDirectory, currentConfigurations, kerberosConfigurations, includeAmbariIdentity, propertiesToBeIgnored);
    }

    protected void processServiceComponents(Cluster cluster, KerberosDescriptor kerberosDescriptor, List<Component> schToProcess, Collection<String> identityFilter, String dataDirectory, Map<String, Map<String, String>> currentConfigurations, Map<String, Map<String, String>> kerberosConfigurations, boolean includeAmbariIdentity, Map<String, Set<String>> propertiesToBeIgnored) throws OBDPException {
        this.actionLog.writeStdOut("Processing Kerberos identities and configurations");
        if (!schToProcess.isEmpty()) {
            KerberosIdentityDataFileWriter kerberosIdentityDataFileWriter;
            if (dataDirectory == null) {
                String message = "The data directory has not been set.  Generated data can not be stored.";
                LOG.error(message);
                throw new OBDPException(message);
            }
            File identityDataFile = new File(dataDirectory, "identity.dat");
            HashMap<String, Object> filterContext = new HashMap<String, Object>();
            filterContext.put("configurations", currentConfigurations);
            filterContext.put("services", cluster.getServices().keySet());
            this.actionLog.writeStdOut(String.format("Writing Kerberos identity data metadata file to %s", identityDataFile.getAbsolutePath()));
            try {
                kerberosIdentityDataFileWriter = this.kerberosIdentityDataFileWriterFactory.createKerberosIdentityDataFileWriter(identityDataFile);
            }
            catch (IOException e) {
                String message = String.format("Failed to write index file - %s", identityDataFile.getAbsolutePath());
                LOG.error(message, (Throwable)e);
                this.actionLog.writeStdOut(message);
                this.actionLog.writeStdErr(message + "\n" + e.getLocalizedMessage());
                throw new OBDPException(message, (Throwable)e);
            }
            HashMap<String, ResolvedKerberosKeytab> resolvedKeytabs = new HashMap<String, ResolvedKerberosKeytab>();
            String realm = AbstractPrepareKerberosServerAction.getDefaultRealm(this.getCommandParameters());
            try {
                List<KerberosIdentityDescriptor> ambariIdentities;
                Map<String, Set<String>> propertiesToIgnore = null;
                for (Component sch : schToProcess) {
                    String hostName = sch.getHostName();
                    Long hostId = sch.getHostId();
                    String serviceName = sch.getServiceName();
                    String componentName = sch.getServiceComponentName();
                    KerberosServiceDescriptor serviceDescriptor = kerberosDescriptor.getService(serviceName);
                    if (serviceDescriptor == null) continue;
                    List<KerberosIdentityDescriptor> serviceIdentities = serviceDescriptor.getIdentities(true, filterContext);
                    if (!StringUtils.isEmpty((String)hostName)) {
                        Map generalProperties = currentConfigurations.computeIfAbsent("", k -> new HashMap());
                        generalProperties.put("host", hostName);
                        generalProperties.put("hostname", hostName);
                    }
                    this.kerberosHelper.addIdentities(kerberosIdentityDataFileWriter, serviceIdentities, identityFilter, hostName, hostId, serviceName, componentName, kerberosConfigurations, currentConfigurations, resolvedKeytabs, realm);
                    propertiesToIgnore = this.gatherPropertiesToIgnore(serviceIdentities, propertiesToIgnore);
                    KerberosComponentDescriptor componentDescriptor = serviceDescriptor.getComponent(componentName);
                    if (componentDescriptor == null) continue;
                    List<KerberosIdentityDescriptor> componentIdentities = componentDescriptor.getIdentities(true, filterContext);
                    this.kerberosHelper.mergeConfigurations(kerberosConfigurations, componentDescriptor.getConfigurations(true), currentConfigurations, null);
                    this.kerberosHelper.addIdentities(kerberosIdentityDataFileWriter, componentIdentities, identityFilter, hostName, hostId, serviceName, componentName, kerberosConfigurations, currentConfigurations, resolvedKeytabs, realm);
                    propertiesToIgnore = this.gatherPropertiesToIgnore(componentIdentities, propertiesToIgnore);
                }
                if (includeAmbariIdentity && this.kerberosHelper.createAmbariIdentities(currentConfigurations.get("kerberos-env")) && !(ambariIdentities = this.kerberosHelper.getAmbariServerIdentities(kerberosDescriptor)).isEmpty()) {
                    for (KerberosIdentityDescriptor identity : ambariIdentities) {
                        String componentName = "obdp-server".equals(identity.getName()) ? "AMBARI_SERVER_SELF" : RootComponent.OBDP_SERVER.name();
                        List<KerberosIdentityDescriptor> componentIdentities = Collections.singletonList(identity);
                        this.kerberosHelper.addIdentities(kerberosIdentityDataFileWriter, componentIdentities, identityFilter, StageUtils.getHostName(), this.ambariServerHostID(), RootService.OBDP.name(), componentName, kerberosConfigurations, currentConfigurations, resolvedKeytabs, realm);
                        propertiesToIgnore = this.gatherPropertiesToIgnore(componentIdentities, propertiesToIgnore);
                    }
                }
                if (propertiesToBeIgnored != null && propertiesToIgnore != null) {
                    propertiesToBeIgnored.putAll(propertiesToIgnore);
                }
                List<KerberosKeytabPrincipalEntity> keytabList = this.kerberosKeytabPrincipalDAO.findAll();
                resolvedKeytabs.values().forEach(keytab -> this.kerberosHelper.createResolvedKeytab((ResolvedKerberosKeytab)keytab, keytabList));
            }
            catch (IOException e) {
                String message = String.format("Failed to write index file - %s", identityDataFile.getAbsolutePath());
                LOG.error(message, (Throwable)e);
                this.actionLog.writeStdOut(message);
                this.actionLog.writeStdErr(message + "\n" + e.getLocalizedMessage());
                throw new OBDPException(message, (Throwable)e);
            }
            finally {
                if (kerberosIdentityDataFileWriter != null) {
                    try {
                        kerberosIdentityDataFileWriter.close();
                    }
                    catch (IOException e) {
                        String message = "Failed to close the index file writer";
                        LOG.warn(message, (Throwable)e);
                        this.actionLog.writeStdOut(message);
                        this.actionLog.writeStdErr(message + "\n" + e.getLocalizedMessage());
                    }
                }
            }
        }
    }

    private Map<String, Set<String>> gatherPropertiesToIgnore(List<KerberosIdentityDescriptor> identities, Map<String, Set<String>> propertiesToIgnore) {
        Map<String, Map<String, String>> identityConfigurations = this.kerberosHelper.getIdentityConfigurations(identities);
        if (identityConfigurations != null && !identityConfigurations.isEmpty()) {
            if (propertiesToIgnore == null) {
                propertiesToIgnore = new HashMap<String, Set<String>>();
            }
            for (Map.Entry<String, Map<String, String>> entry : identityConfigurations.entrySet()) {
                String configType = entry.getKey();
                Map<String, String> properties = entry.getValue();
                if (properties == null || properties.isEmpty()) continue;
                Set<String> propertyNames = propertiesToIgnore.get(configType);
                if (propertyNames == null) {
                    propertyNames = new HashSet<String>();
                    propertiesToIgnore.put(configType, propertyNames);
                }
                propertyNames.addAll(properties.keySet());
            }
        }
        return propertiesToIgnore;
    }

    protected void processConfigurationChanges(String dataDirectory, Map<String, Map<String, String>> kerberosConfigurations, Map<String, Set<String>> propertiesToBeRemoved, KerberosDescriptor kerberosDescriptor, UpdateConfigurationPolicy updateConfigurationPolicy) throws OBDPException {
        this.actionLog.writeStdOut("Determining configuration changes");
        if (!kerberosConfigurations.isEmpty()) {
            if (dataDirectory == null) {
                String message = "The data directory has not been set.  Generated data can not be stored.";
                LOG.error(message);
                throw new OBDPException(message);
            }
            Map<String, Set<String>> kerberosIdentityProperties = this.getIdentityProperties(kerberosDescriptor, null);
            Map<String, Map<String, String>> existingProperties = this.configHelper.getEffectiveConfigProperties(this.getClusterName(), null);
            File configFile = new File(dataDirectory, "configs.dat");
            KerberosConfigDataFileWriter kerberosConfDataFileWriter = null;
            this.actionLog.writeStdOut(String.format("Writing configuration changes metadata file to %s", configFile.getAbsolutePath()));
            try {
                Object properties;
                String type;
                kerberosConfDataFileWriter = this.kerberosConfigDataFileWriterFactory.createKerberosConfigDataFileWriter(configFile);
                for (Map.Entry<String, Map<String, String>> entry : kerberosConfigurations.entrySet()) {
                    type = entry.getKey();
                    properties = entry.getValue();
                    if (properties == null) continue;
                    for (Map.Entry<String, String> configTypeEntry : properties.entrySet()) {
                        String propertyName = configTypeEntry.getKey();
                        if (!this.includeConfiguration(type, propertyName, updateConfigurationPolicy, existingProperties, kerberosIdentityProperties)) continue;
                        kerberosConfDataFileWriter.addRecord(type, propertyName, configTypeEntry.getValue(), "SET");
                    }
                }
                if (propertiesToBeRemoved != null) {
                    for (Map.Entry<String, Object> entry : propertiesToBeRemoved.entrySet()) {
                        type = entry.getKey();
                        properties = (Set)entry.getValue();
                        if (properties == null) continue;
                        Iterator<Map.Entry<String, String>> iterator = properties.iterator();
                        while (iterator.hasNext()) {
                            String property = (String)((Object)iterator.next());
                            kerberosConfDataFileWriter.addRecord(type, property, "", "REMOVE");
                        }
                    }
                }
            }
            catch (IOException e) {
                String string = String.format("Failed to write kerberos configurations file - %s", configFile.getAbsolutePath());
                LOG.error(string, (Throwable)e);
                this.actionLog.writeStdOut(string);
                this.actionLog.writeStdErr(string + "\n" + e.getLocalizedMessage());
                throw new OBDPException(string, (Throwable)e);
            }
            finally {
                if (kerberosConfDataFileWriter != null) {
                    try {
                        kerberosConfDataFileWriter.close();
                    }
                    catch (IOException e) {
                        String message = "Failed to close the kerberos configurations file writer";
                        LOG.warn(message, (Throwable)e);
                        this.actionLog.writeStdOut(message);
                        this.actionLog.writeStdErr(message + "\n" + e.getLocalizedMessage());
                    }
                }
            }
        }
    }

    private boolean includeConfiguration(String configType, String propertyName, UpdateConfigurationPolicy updateConfigurationPolicy, Map<String, Map<String, String>> existingProperties, Map<String, Set<String>> kerberosIdentityProperties) {
        boolean isNew;
        boolean isIdentity;
        if (kerberosIdentityProperties == null) {
            isIdentity = false;
        } else {
            Set<String> propertyNames = kerberosIdentityProperties.get(configType);
            boolean bl = isIdentity = !CollectionUtils.isEmpty(propertyNames) && propertyNames.contains(propertyName);
        }
        if (isIdentity) {
            return updateConfigurationPolicy.applyIdentityChanges();
        }
        if (existingProperties == null) {
            isNew = true;
        } else {
            Map<String, String> propertyNames = existingProperties.get(configType);
            boolean bl = isNew = propertyNames == null || !propertyNames.containsKey(propertyName);
        }
        if (isNew) {
            return updateConfigurationPolicy.applyAdditions();
        }
        return updateConfigurationPolicy.applyOtherChanges();
    }

    private Map<String, Set<String>> getIdentityProperties(AbstractKerberosDescriptorContainer container, Map<String, Set<String>> identityProperties) {
        if (container != null) {
            Collection<? extends AbstractKerberosDescriptorContainer> childContainers;
            Map<String, Set<String>> authToLocalProperties;
            Map<String, Map<String, String>> identityConfigurations;
            List<KerberosIdentityDescriptor> identityDescriptors;
            if (identityProperties == null) {
                identityProperties = new HashMap<String, Set<String>>();
            }
            try {
                identityDescriptors = container.getIdentities(false, null);
            }
            catch (OBDPException e) {
                LOG.error("An exception occurred getting the Kerberos identity descriptors.  No configurations will be identified.", (Throwable)e);
                identityDescriptors = null;
            }
            if (identityDescriptors != null && (identityConfigurations = this.kerberosHelper.getIdentityConfigurations(identityDescriptors)) != null) {
                for (Map.Entry<String, Object> entry : identityConfigurations.entrySet()) {
                    Map map = (Map)entry.getValue();
                    if (map == null) continue;
                    Set configProperties = identityProperties.computeIfAbsent(entry.getKey(), k -> new HashSet());
                    configProperties.addAll(map.keySet());
                }
            }
            if ((authToLocalProperties = this.kerberosHelper.translateConfigurationSpecifications(container.getAuthToLocalProperties())) != null) {
                for (Map.Entry<String, Object> entry : authToLocalProperties.entrySet()) {
                    String string = entry.getKey();
                    Set propertyNames = (Set)entry.getValue();
                    if (propertyNames == null) continue;
                    Set configProperties = identityProperties.computeIfAbsent(string, k -> new HashSet());
                    configProperties.addAll(propertyNames);
                }
            }
            if ((childContainers = container.getChildContainers()) != null) {
                for (AbstractKerberosDescriptorContainer abstractKerberosDescriptorContainer : childContainers) {
                    this.getIdentityProperties(abstractKerberosDescriptorContainer, identityProperties);
                }
            }
        }
        return identityProperties;
    }
}

