/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public abstract class AbstractKerberosDataFileWriter {
    private File file;
    private CSVPrinter csvPrinter;

    public AbstractKerberosDataFileWriter(File file) throws IOException {
        this.file = file;
        this.open();
    }

    public void open() throws IOException {
        if (this.isClosed()) {
            if (this.file == null) {
                throw new IOException("Missing file path");
            }
            this.csvPrinter = new CSVPrinter((Appendable)new FileWriter(this.file, true), CSVFormat.DEFAULT);
            if (this.file.length() == 0L) {
                Iterable<String> headerRecord = this.getHeaderRecord();
                this.csvPrinter.printRecord(headerRecord);
            }
        }
    }

    public boolean isClosed() {
        return this.csvPrinter == null;
    }

    public void close() throws IOException {
        if (this.csvPrinter != null) {
            this.csvPrinter.close();
            this.csvPrinter = null;
        }
    }

    protected void appendRecord(String ... record) throws IOException {
        if (this.csvPrinter == null) {
            throw new IOException("Data file is not open");
        }
        this.csvPrinter.printRecord((Object[])record);
    }

    protected abstract Iterable<String> getHeaderRecord();
}

