/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction.kerberos;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.inject.Inject;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.security.InternalSSLSocketFactoryNonTrusting;
import id.onyx.obdp.server.security.InternalSSLSocketFactoryTrusting;
import id.onyx.obdp.server.security.credential.PrincipalKeyCredential;
import id.onyx.obdp.server.serveraction.kerberos.DeconstructedPrincipal;
import id.onyx.obdp.server.serveraction.kerberos.KerberosAdminAuthenticationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosKDCConnectionException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosKDCSSLConnectionException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosLDAPContainerException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationHandler;
import id.onyx.obdp.server.serveraction.kerberos.KerberosPrincipalAlreadyExistsException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosPrincipalDoesNotExistException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosRealmException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADKerberosOperationHandler
extends KerberosOperationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ADKerberosOperationHandler.class);
    private static final String LDAP_CONTEXT_FACTORY_CLASS = "com.sun.jndi.ldap.LdapCtxFactory";
    private String ldapUrl = null;
    private String principalContainerDn = null;
    private LdapName principalContainerLdapName = null;
    private String createTemplate = null;
    private LdapContext ldapContext = null;
    private SearchControls searchControls = null;
    @Inject
    private Gson gson;
    @Inject
    private Configuration configuration;

    @Override
    public void open(PrincipalKeyCredential administratorCredential, String realm, Map<String, String> kerberosConfiguration) throws KerberosOperationException {
        if (this.isOpen()) {
            this.close();
        }
        if (administratorCredential == null) {
            throw new KerberosAdminAuthenticationException("administrator credential not provided");
        }
        if (realm == null) {
            throw new KerberosRealmException("realm not provided");
        }
        if (kerberosConfiguration == null) {
            throw new KerberosRealmException("kerberos-env configuration may not be null");
        }
        this.ldapUrl = kerberosConfiguration.get("ldap_url");
        if (this.ldapUrl == null) {
            throw new KerberosKDCConnectionException("ldapUrl not provided");
        }
        if (!this.ldapUrl.startsWith("ldaps://")) {
            throw new KerberosKDCConnectionException("ldapUrl is not valid ldaps URL");
        }
        this.principalContainerDn = kerberosConfiguration.get("container_dn");
        if (this.principalContainerDn == null) {
            throw new KerberosLDAPContainerException("principalContainerDn not provided");
        }
        try {
            this.principalContainerLdapName = new LdapName(this.principalContainerDn);
        }
        catch (InvalidNameException e) {
            throw new KerberosLDAPContainerException("principalContainerDn is not a valid LDAP name", e);
        }
        super.open(administratorCredential, realm, kerberosConfiguration);
        this.ldapContext = this.createLdapContext();
        this.searchControls = this.createSearchControls();
        this.createTemplate = kerberosConfiguration.get("ad_create_attributes_template");
        this.setOpen(true);
    }

    @Override
    public void close() throws KerberosOperationException {
        this.searchControls = null;
        if (this.ldapContext != null) {
            try {
                this.ldapContext.close();
            }
            catch (NamingException e) {
                throw new KerberosOperationException("Unexpected error", e);
            }
            finally {
                this.ldapContext = null;
            }
        }
        this.setOpen(false);
    }

    @Override
    public boolean principalExists(String principal, boolean service) throws KerberosOperationException {
        if (!this.isOpen()) {
            throw new KerberosOperationException("This operation handler has not been opened");
        }
        if (principal == null) {
            throw new KerberosOperationException("principal is null");
        }
        DeconstructedPrincipal deconstructPrincipal = this.createDeconstructPrincipal(principal);
        try {
            return this.findPrincipalDN(deconstructPrincipal.getNormalizedPrincipal()) != null;
        }
        catch (NamingException ne) {
            throw new KerberosOperationException("can not check if principal exists: " + principal, ne);
        }
    }

    @Override
    public Integer createPrincipal(String principal, String password, boolean service) throws KerberosOperationException {
        if (!this.isOpen()) {
            throw new KerberosOperationException("This operation handler has not been opened");
        }
        if (principal == null) {
            throw new KerberosOperationException("principal is null");
        }
        if (password == null) {
            throw new KerberosOperationException("principal password is null");
        }
        if (this.principalExists(principal, service)) {
            throw new KerberosPrincipalAlreadyExistsException(principal);
        }
        DeconstructedPrincipal deconstructedPrincipal = this.createDeconstructPrincipal(principal);
        String realm = deconstructedPrincipal.getRealm();
        if (realm == null) {
            realm = "";
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("normalized_principal", deconstructedPrincipal.getNormalizedPrincipal());
        context.put("principal_name", deconstructedPrincipal.getPrincipalName());
        context.put("principal_primary", deconstructedPrincipal.getPrimary());
        context.put("principal_instance", deconstructedPrincipal.getInstance());
        context.put("realm", realm);
        context.put("realm_lowercase", realm.toLowerCase());
        context.put("password", password);
        context.put("is_service", service);
        context.put("container_dn", this.principalContainerDn);
        context.put("principal_digest", DigestUtils.sha1Hex((String)deconstructedPrincipal.getNormalizedPrincipal()));
        context.put("principal_digest_256", DigestUtils.sha256Hex((String)deconstructedPrincipal.getNormalizedPrincipal()));
        context.put("principal_digest_512", DigestUtils.sha512Hex((String)deconstructedPrincipal.getNormalizedPrincipal()));
        Map<String, Object> data = this.processCreateTemplate(context);
        BasicAttributes attributes = new BasicAttributes();
        String cn = null;
        if (data != null) {
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if ("unicodePwd".equals(key)) {
                    if (!(value instanceof String)) continue;
                    try {
                        attributes.put(new BasicAttribute("unicodePwd", String.format("\"%s\"", password).getBytes("UTF-16LE")));
                        continue;
                    }
                    catch (UnsupportedEncodingException ue) {
                        throw new KerberosOperationException("Can not encode password with UTF-16LE", ue);
                    }
                }
                BasicAttribute attribute = new BasicAttribute(key);
                if (value instanceof Collection) {
                    for (Object object : (Collection)value) {
                        attribute.add(object);
                    }
                } else {
                    if ("cn".equals(key) && value != null) {
                        cn = value.toString();
                    } else if ("sAMAccountName".equals(key) && value != null) {
                        value = value.toString().replaceAll("\\[|\\]|\\:|\\;|\\||\\=|\\+|\\*|\\?|\\<|\\>|\\/|\\\\|\\,|\\s", "_");
                    }
                    attribute.add(value);
                }
                attributes.put(attribute);
            }
        }
        if (cn == null) {
            cn = deconstructedPrincipal.getNormalizedPrincipal();
        }
        try {
            Rdn rdn = new Rdn("cn", cn);
            LdapName name = new LdapName(this.principalContainerLdapName.getRdns());
            name.add(name.size(), rdn);
            this.ldapContext.createSubcontext(name, (Attributes)attributes);
        }
        catch (NamingException ne) {
            throw new KerberosOperationException("Can not create principal : " + principal, ne);
        }
        return 0;
    }

    @Override
    public Integer setPrincipalPassword(String principal, String password, boolean service) throws KerberosOperationException {
        if (!this.isOpen()) {
            throw new KerberosOperationException("This operation handler has not been opened");
        }
        if (principal == null) {
            throw new KerberosOperationException("principal is null");
        }
        if (password == null) {
            throw new KerberosOperationException("principal password is null");
        }
        if (!this.principalExists(principal, service)) {
            throw new KerberosPrincipalDoesNotExistException(principal);
        }
        DeconstructedPrincipal deconstructPrincipal = this.createDeconstructPrincipal(principal);
        try {
            String dn = this.findPrincipalDN(deconstructPrincipal.getNormalizedPrincipal());
            if (dn == null) {
                throw new KerberosOperationException(String.format("Can not set password for principal %s: Not Found", principal));
            }
            this.ldapContext.modifyAttributes(new LdapName(dn), new ModificationItem[]{new ModificationItem(2, new BasicAttribute("unicodePwd", String.format("\"%s\"", password).getBytes("UTF-16LE")))});
        }
        catch (NamingException e) {
            throw new KerberosOperationException(String.format("Can not set password for principal %s: %s", principal, e.getMessage()), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new KerberosOperationException("Unsupported encoding UTF-16LE", e);
        }
        return 0;
    }

    @Override
    public boolean removePrincipal(String principal, boolean service) throws KerberosOperationException {
        if (!this.isOpen()) {
            throw new KerberosOperationException("This operation handler has not been opened");
        }
        if (principal == null) {
            throw new KerberosOperationException("principal is null");
        }
        DeconstructedPrincipal deconstructPrincipal = this.createDeconstructPrincipal(principal);
        try {
            String dn = this.findPrincipalDN(deconstructPrincipal.getNormalizedPrincipal());
            if (dn != null) {
                this.ldapContext.destroySubcontext(new LdapName(dn));
            }
        }
        catch (NamingException e) {
            throw new KerberosOperationException(String.format("Can not remove principal %s: %s", principal, e.getMessage()), e);
        }
        return true;
    }

    @Override
    public boolean testAdministratorCredentials() throws KerberosOperationException {
        if (!this.isOpen()) {
            throw new KerberosOperationException("This operation handler has not been opened");
        }
        return true;
    }

    protected LdapContext createLdapContext() throws KerberosOperationException {
        PrincipalKeyCredential administratorCredential = this.getAdministratorCredential();
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", LDAP_CONTEXT_FACTORY_CLASS);
        properties.put("java.naming.provider.url", this.ldapUrl);
        properties.put("java.naming.security.principal", administratorCredential.getPrincipal());
        properties.put("java.naming.security.credentials", String.valueOf(administratorCredential.getKey()));
        properties.put("java.naming.security.authentication", "simple");
        properties.put("java.naming.referral", "follow");
        if (this.ldapUrl.startsWith("ldaps")) {
            if (this.configuration.validateKerberosOperationSSLCertTrust()) {
                properties.put("java.naming.ldap.factory.socket", InternalSSLSocketFactoryNonTrusting.class.getName());
            } else {
                properties.put("java.naming.ldap.factory.socket", InternalSSLSocketFactoryTrusting.class.getName());
            }
        }
        try {
            return this.createInitialLdapContext(properties, null);
        }
        catch (CommunicationException e) {
            Throwable rootCause = e.getRootCause();
            String message = String.format("Failed to communicate with the Active Directory at %s: %s", this.ldapUrl, e.getMessage());
            LOG.warn(message, (Throwable)e);
            if (rootCause instanceof SSLHandshakeException) {
                throw new KerberosKDCSSLConnectionException(message, e);
            }
            throw new KerberosKDCConnectionException(message, e);
        }
        catch (AuthenticationException e) {
            String message = String.format("Failed to authenticate with the Active Directory at %s: %s", this.ldapUrl, e.getMessage());
            LOG.warn(message, (Throwable)e);
            throw new KerberosAdminAuthenticationException(message, e);
        }
        catch (NamingException e) {
            String error = e.getMessage();
            if (StringUtils.isEmpty((String)error)) {
                String message = String.format("Failed to communicate with the Active Directory at %s: %s", this.ldapUrl, e.getMessage());
                LOG.warn(message, (Throwable)e);
                if (error.startsWith("Cannot parse url:")) {
                    throw new KerberosKDCConnectionException(message, e);
                }
                throw new KerberosOperationException(message, e);
            }
            throw new KerberosOperationException("Unexpected error condition", e);
        }
    }

    protected LdapContext createInitialLdapContext(Properties properties, Control[] controls) throws NamingException {
        return new InitialLdapContext(properties, controls);
    }

    protected SearchControls createSearchControls() {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        searchControls.setReturningAttributes(new String[]{"cn"});
        return searchControls;
    }

    protected Map<String, Object> processCreateTemplate(Map<String, Object> context) throws KerberosOperationException {
        if (this.gson == null) {
            throw new KerberosOperationException("The JSON parser must not be null");
        }
        Map data = null;
        StringWriter stringWriter = new StringWriter();
        String template = StringUtils.isEmpty((String)this.createTemplate) ? "{\"objectClass\": [\"top\", \"person\", \"organizationalPerson\", \"user\"],\"cn\": \"$principal_name\",#if( $is_service )  \"servicePrincipalName\": \"$principal_name\",#end\"userPrincipalName\": \"$normalized_principal\",\"unicodePwd\": \"$password\",\"accountExpires\": \"0\",\"userAccountControl\": \"66048\"}" : this.createTemplate;
        try {
            if (Velocity.evaluate((Context)new VelocityContext(context), (Writer)stringWriter, (String)"Active Directory principal create template", (String)template)) {
                String json = stringWriter.toString();
                Type type = new TypeToken<Map<String, Object>>(){}.getType();
                data = (Map)this.gson.fromJson(json, type);
            }
        }
        catch (ParseErrorException e) {
            LOG.warn("Failed to parse Active Directory create principal template", (Throwable)e);
            throw new KerberosOperationException("Failed to parse Active Directory create principal template", e);
        }
        catch (MethodInvocationException | ResourceNotFoundException e) {
            LOG.warn("Failed to process Active Directory create principal template", e);
            throw new KerberosOperationException("Failed to process Active Directory create principal template", e);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findPrincipalDN(String normalizedPrincipal) throws NamingException, KerberosOperationException {
        String dn = null;
        if (normalizedPrincipal != null) {
            NamingEnumeration<SearchResult> results = null;
            try {
                results = this.ldapContext.search((Name)this.principalContainerLdapName, String.format("(userPrincipalName=%s)", normalizedPrincipal), this.searchControls);
                if (results != null && results.hasMore()) {
                    SearchResult result = results.next();
                    dn = result.getNameInNamespace();
                }
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                catch (NamingException namingException) {}
            }
        }
        return dn;
    }
}

