/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction;

import com.google.inject.Inject;
import com.google.inject.Injector;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.actionmanager.ActionDBAccessor;
import id.onyx.obdp.server.actionmanager.ExecutionCommandWrapper;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.agent.ExecutionCommand;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.security.authorization.internal.InternalAuthenticationToken;
import id.onyx.obdp.server.serveraction.ServerAction;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeServiceSummary;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeSummary;
import id.onyx.obdp.server.state.ServiceInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.ClassUtils;

@StaticallyInject
public class ServerActionExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(ServerActionExecutor.class);
    private static final Long DEFAULT_EXECUTION_TIMEOUT_MS = 300000L;
    private static final Long POLLING_TIMEOUT_MS = 5000L;
    @Inject
    private static Injector injector;
    @Inject
    private static Configuration configuration;
    private final Map<Long, ConcurrentMap<String, Object>> requestSharedDataMap = new ConcurrentHashMap<Long, ConcurrentMap<String, Object>>();
    private final ActionDBAccessor db;
    private final Object wakeupSyncObject = new Object();
    private final long sleepTimeMS;
    private boolean activeAwakeRequest = false;
    private Thread executorThread = null;
    private final Timer cacheTimer = new Timer("server-action-executor-cache-timer", true);

    public static void init(Injector injector) {
        ServerActionExecutor.injector = injector;
    }

    public ServerActionExecutor(ActionDBAccessor db, long sleepTimeMS) {
        this.db = db;
        this.sleepTimeMS = sleepTimeMS < 1L ? POLLING_TIMEOUT_MS : sleepTimeMS;
        this.cacheTimer.schedule((TimerTask)new ServerActionSharedRequestEvictor(), TimeUnit.HOURS.toMillis(1L), TimeUnit.HOURS.toMillis(1L));
    }

    public void start() {
        LOG.info("Starting Server Action Executor thread...");
        this.executorThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    try {
                        Object object = ServerActionExecutor.this.wakeupSyncObject;
                        synchronized (object) {
                            if (!ServerActionExecutor.this.activeAwakeRequest) {
                                ServerActionExecutor.this.wakeupSyncObject.wait(ServerActionExecutor.this.sleepTimeMS);
                            }
                            ServerActionExecutor.this.activeAwakeRequest = false;
                        }
                        ServerActionExecutor.this.doWork();
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Server Action Executor thread interrupted, starting to shutdown...");
                        break;
                    }
                }
                LOG.info("Server Action Executor thread shutting down...");
            }
        }, "Server Action Executor");
        this.executorThread.start();
        if (this.executorThread.isAlive()) {
            LOG.info("Server Action Executor thread started.");
        }
    }

    public void stop() {
        LOG.info("Stopping Server Action Executor thread...");
        if (this.executorThread != null) {
            this.executorThread.interrupt();
            for (int i = 0; i < 120; ++i) {
                try {
                    this.executorThread.join(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.executorThread.isAlive()) break;
            }
            if (!this.executorThread.isAlive()) {
                this.executorThread = null;
            }
        }
        if (this.executorThread == null) {
            LOG.info("Server Action Executor thread stopped.");
        } else {
            LOG.warn("Server Action Executor thread hasn't stopped, giving up waiting.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awake() {
        Object object = this.wakeupSyncObject;
        synchronized (object) {
            this.activeAwakeRequest = true;
            this.wakeupSyncObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<String, Object> getRequestSharedDataContext(long requestId) {
        Map<Long, ConcurrentMap<String, Object>> map = this.requestSharedDataMap;
        synchronized (map) {
            ConcurrentMap<String, Object> map2 = this.requestSharedDataMap.get(requestId);
            if (map2 == null) {
                map2 = new ConcurrentHashMap<String, Object>();
                this.requestSharedDataMap.put(requestId, map2);
            }
            return map2;
        }
    }

    private CommandReport createInProgressReport() {
        CommandReport commandReport = new CommandReport();
        commandReport.setStatus(HostRoleStatus.IN_PROGRESS.toString());
        commandReport.setStdErr("");
        commandReport.setStdOut("");
        return commandReport;
    }

    private CommandReport createTimedOutReport() {
        CommandReport commandReport = new CommandReport();
        commandReport.setStatus(HostRoleStatus.TIMEDOUT.toString());
        commandReport.setStdErr("");
        commandReport.setStdOut("");
        return commandReport;
    }

    private CommandReport createErrorReport(String message) {
        CommandReport commandReport = new CommandReport();
        commandReport.setStatus(HostRoleStatus.FAILED.toString());
        commandReport.setExitCode(1);
        commandReport.setStdOut("Server action failed");
        commandReport.setStdErr(message == null ? "Server action failed" : message);
        return commandReport;
    }

    private void updateHostRoleState(HostRoleCommand hostRoleCommand, ExecutionCommand executionCommand, CommandReport commandReport) {
        if (commandReport == null) {
            commandReport = this.createErrorReport("Unknown error condition");
        }
        this.db.updateHostRoleState(null, hostRoleCommand.getRequestId(), hostRoleCommand.getStageId(), executionCommand.getRole(), commandReport);
    }

    private long determineTimeout(ExecutionCommand executionCommand) {
        Integer defaultTimeoutSeconds;
        Long timeout;
        Map<String, String> params = executionCommand.getCommandParams();
        String paramsTimeout = params == null ? null : params.get("command_timeout");
        try {
            timeout = paramsTimeout == null ? null : Long.valueOf(Long.parseLong(paramsTimeout) * 1000L);
        }
        catch (NumberFormatException e) {
            timeout = null;
        }
        if (timeout == null && (defaultTimeoutSeconds = configuration.getDefaultServerTaskTimeout()) != null) {
            timeout = (long)defaultTimeoutSeconds.intValue() * 1000L;
        }
        return timeout == null ? DEFAULT_EXECUTION_TIMEOUT_MS : (timeout < 0L ? 0L : timeout);
    }

    public void doWork() throws InterruptedException {
        List<HostRoleCommand> tasks = this.db.getTasksByRoleAndStatus(Role.AMBARI_SERVER_ACTION.name(), HostRoleStatus.QUEUED);
        if (tasks != null && !tasks.isEmpty()) {
            for (HostRoleCommand task : tasks) {
                Long taskId = task.getTaskId();
                LOG.debug("Processing task #{}", (Object)taskId);
                if (task.getStatus() == HostRoleStatus.QUEUED) {
                    ExecutionCommandWrapper executionWrapper = task.getExecutionCommandWrapper();
                    if (executionWrapper != null) {
                        ExecutionCommand executionCommand = executionWrapper.getExecutionCommand();
                        if (executionCommand != null) {
                            Worker worker = new Worker(task, executionCommand);
                            Thread workerThread = new Thread((Runnable)worker, String.format("Server Action Executor Worker %s", taskId));
                            Long timeout = this.determineTimeout(executionCommand);
                            this.updateHostRoleState(task, executionCommand, this.createInProgressReport());
                            LOG.debug("Starting Server Action Executor Worker thread for task #{}.", (Object)taskId);
                            workerThread.start();
                            try {
                                workerThread.join(timeout);
                            }
                            catch (InterruptedException e) {
                                workerThread.interrupt();
                                throw e;
                            }
                            if (workerThread.isAlive()) {
                                LOG.debug("Server Action Executor Worker thread for task #{} timed out - it failed to complete within {} ms.", (Object)taskId, (Object)timeout);
                                workerThread.interrupt();
                                this.updateHostRoleState(task, executionCommand, this.createTimedOutReport());
                                continue;
                            }
                            LOG.debug("Server Action Executor Worker thread for task #{} exited on its own.", (Object)taskId);
                            this.updateHostRoleState(task, executionCommand, worker.getCommandReport());
                            continue;
                        }
                        LOG.warn("Task #{} failed to produce an ExecutionCommand, skipping.", (Object)taskId);
                        continue;
                    }
                    LOG.warn("Task #{} failed to produce an ExecutionCommandWrapper, skipping.", (Object)taskId);
                    continue;
                }
                LOG.warn("Queued task #{} is expected to have a status of {} but has a status of {}, skipping.", new Object[]{taskId, HostRoleStatus.QUEUED, task.getStatus()});
            }
        }
    }

    private class ServerActionSharedRequestEvictor
    extends TimerTask {
        private ServerActionSharedRequestEvictor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (ServerActionExecutor.this.requestSharedDataMap.isEmpty()) {
                return;
            }
            try {
                HashSet<Long> requestsInProgress = new HashSet<Long>();
                List<Stage> currentStageInProgressPerRequest = ServerActionExecutor.this.db.getFirstStageInProgressPerRequest();
                for (Stage stage : currentStageInProgressPerRequest) {
                    requestsInProgress.add(stage.getRequestId());
                }
                Map<Long, ConcurrentMap<String, Object>> map = ServerActionExecutor.this.requestSharedDataMap;
                synchronized (map) {
                    Set<Long> cachedRequestIds = ServerActionExecutor.this.requestSharedDataMap.keySet();
                    for (long cachedRequestId : cachedRequestIds) {
                        if (requestsInProgress.contains(cachedRequestId)) continue;
                        ServerActionExecutor.this.requestSharedDataMap.remove(cachedRequestId);
                    }
                }
            }
            catch (Exception exception) {
                LOG.warn("Unable to clear the server-side action request cache", (Throwable)exception);
            }
        }
    }

    private class Worker
    implements Runnable {
        private final Long taskId;
        private final HostRoleCommand hostRoleCommand;
        private final ExecutionCommand executionCommand;
        private CommandReport commandReport = null;

        @Override
        public void run() {
            try {
                LOG.debug("Executing task #{}", (Object)this.taskId);
                InternalAuthenticationToken authentication = new InternalAuthenticationToken("server_action_executor");
                authentication.setAuthenticated(true);
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                this.commandReport = this.execute(this.hostRoleCommand, this.executionCommand);
                LOG.debug("Task #{} completed execution with status of {}", (Object)this.taskId, (Object)(this.commandReport == null ? "UNKNOWN" : this.commandReport.getStatus()));
            }
            catch (Throwable t) {
                LOG.warn("Task #{} failed to complete execution due to thrown exception: {}:{}", new Object[]{this.taskId, t.getClass().getName(), t.getLocalizedMessage(), t});
                this.commandReport = ServerActionExecutor.this.createErrorReport(t.getLocalizedMessage());
            }
        }

        public CommandReport getCommandReport() {
            return this.commandReport;
        }

        private CommandReport execute(HostRoleCommand hostRoleCommand, ExecutionCommand executionCommand) throws OBDPException, InterruptedException {
            ServerAction action;
            if (hostRoleCommand == null) {
                throw new OBDPException("Missing HostRoleCommand data");
            }
            if (executionCommand == null) {
                throw new OBDPException("Missing ExecutionCommand data");
            }
            Map<String, String> roleParams = executionCommand.getRoleParams();
            if (roleParams == null) {
                throw new OBDPException("Missing RoleParams data");
            }
            String actionClassname = roleParams.get("ACTION_NAME");
            if (actionClassname == null) {
                throw new OBDPException("Missing action classname for server action");
            }
            HashMap<String, ServiceInfo> services = new HashMap<String, ServiceInfo>();
            UpgradeSummary upgradeSummary = executionCommand.getUpgradeSummary();
            if (upgradeSummary != null) {
                Map<String, UpgradeServiceSummary> upgradeServiceSummaries = upgradeSummary.services;
                LOG.debug("UpgradeServiceSummary: " + upgradeServiceSummaries);
                OBDPManagementController ambariManagementController = (OBDPManagementController)injector.getInstance(OBDPManagementController.class);
                OBDPMetaInfo obdpMetaInfo = ambariManagementController.getAmbariMetaInfo();
                String serviceName = executionCommand.getServiceName();
                if (serviceName != null && !serviceName.isEmpty()) {
                    LOG.info(String.format("Server action %s is associated with service %s", actionClassname, serviceName));
                    UpgradeServiceSummary serviceSummary = upgradeServiceSummaries.get(serviceName);
                    this.addServiceInfo(services, obdpMetaInfo, serviceSummary.sourceStackId, serviceName);
                } else {
                    LOG.info(String.format("Server action %s is not associated with a service", actionClassname));
                    for (String key : upgradeServiceSummaries.keySet()) {
                        UpgradeServiceSummary serviceSummary = upgradeServiceSummaries.get(key);
                        this.addServiceInfo(services, obdpMetaInfo, serviceSummary.sourceStackId, key);
                    }
                }
                LOG.info(String.format("Attempt to load server action classes from %s", services.keySet().toString()));
            }
            if ((action = this.createServerAction(actionClassname, services)) == null) {
                throw new OBDPException("Failed to create server action: " + actionClassname);
            }
            action.setExecutionCommand(executionCommand);
            action.setHostRoleCommand(hostRoleCommand);
            return action.execute(ServerActionExecutor.this.getRequestSharedDataContext(hostRoleCommand.getRequestId()));
        }

        private void addServiceInfo(Map<String, ServiceInfo> services, OBDPMetaInfo obdpMetaInfo, String stackId, String serviceName) {
            List<String> stackInfo = this.getStackInfo(stackId);
            LOG.debug(String.format("Stack info list: %s", stackInfo));
            if (stackInfo.size() > 1) {
                try {
                    ServiceInfo service = obdpMetaInfo.getService(stackInfo.get(0), stackInfo.get(1), serviceName);
                    LOG.debug(String.format("Adding %s to the list of services for loading external Jars...", service.getName()));
                    services.put(serviceName, service);
                }
                catch (OBDPException e) {
                    LOG.error(String.format("Failed to obtain service info for stack %s, service name %s", stackId, serviceName), (Throwable)e);
                }
            }
        }

        private List<String> getStackInfo(String stackId) {
            LOG.debug(String.format("Stack id: %s", stackId));
            StringTokenizer tokens = new StringTokenizer(stackId, "-");
            ArrayList<String> info = new ArrayList<String>();
            while (tokens.hasMoreElements()) {
                info.add((String)tokens.nextElement());
            }
            return info;
        }

        private ServerAction createServerAction(String classname, Map<String, ServiceInfo> services) throws OBDPException {
            Class<?> actionClass = null;
            actionClass = this.getServerActionClass(classname);
            if (actionClass == null) {
                LOG.debug(String.format("Did not find %s in Ambari, try to load it from external directories", classname));
                actionClass = this.getServiceLevelServerActionClass(classname, services);
            }
            if (actionClass == null) {
                throw new OBDPException("Unable to load server action class: " + classname);
            }
            LOG.debug(String.format("Ready to init server action %s", classname));
            Class<ServerAction> serverActionClass = actionClass.asSubclass(ServerAction.class);
            if (serverActionClass == null) {
                throw new OBDPException("Unable to execute server action class, invalid type: " + classname);
            }
            return (ServerAction)injector.getInstance(serverActionClass);
        }

        private Class<?> getServiceLevelServerActionClass(String classname, Map<String, ServiceInfo> services) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (ServiceInfo service : services.values()) {
                LOG.debug(String.format("Checking service %s", service));
                File dir = service.getServerActionsFolder();
                if (dir != null) {
                    File[] jars;
                    LOG.debug(String.format("Service %s, external dir %s", service.getName(), dir.getAbsolutePath()));
                    for (File jar : jars = dir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            LOG.debug(String.format("Checking folder %s", name));
                            return name.endsWith(".jar");
                        }
                    })) {
                        try {
                            URL url = jar.toURI().toURL();
                            urls.add(url);
                            LOG.info("Adding server action jar to classpath: {}", (Object)url);
                        }
                        catch (Exception e) {
                            LOG.error("Failed to add server action jar to classpath: {}", (Object)jar.getAbsolutePath(), (Object)e);
                        }
                    }
                    continue;
                }
                LOG.error(String.format("%s service server actions folder returned null", service));
            }
            URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ClassUtils.getDefaultClassLoader());
            Class actionClass = null;
            try {
                actionClass = ClassUtils.resolveClassName((String)classname, (ClassLoader)classLoader);
                LOG.debug(String.format("Found external server action %s", classname));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.error(String.format("Unable to find server action %s in external server action directories", classname), (Throwable)illegalArgumentException);
            }
            return actionClass;
        }

        private Class<?> getServerActionClass(String classname) throws OBDPException {
            Class<?> actionClass = null;
            try {
                actionClass = Class.forName(classname);
                if (actionClass == null) {
                    LOG.warn(String.format("Unable to load server action class: %s from Ambari", classname));
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error(String.format("Unable to load server action class: %s", classname), (Throwable)e);
            }
            return actionClass;
        }

        private Worker(HostRoleCommand hostRoleCommand, ExecutionCommand executionCommand) {
            this.taskId = hostRoleCommand.getTaskId();
            this.hostRoleCommand = hostRoleCommand;
            this.executionCommand = executionCommand;
        }
    }
}

