/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.serveraction;

import com.google.gson.Gson;
import com.google.inject.Inject;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.actionmanager.ExecutionCommandWrapper;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.agent.CommandReport;
import id.onyx.obdp.server.agent.ExecutionCommand;
import id.onyx.obdp.server.audit.AuditLogger;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.serveraction.ActionLog;
import id.onyx.obdp.server.serveraction.ServerAction;
import id.onyx.obdp.server.utils.StageUtils;
import java.util.Collections;
import java.util.Map;

public abstract class AbstractServerAction
implements ServerAction {
    private ExecutionCommand executionCommand = null;
    private HostRoleCommand hostRoleCommand = null;
    protected ActionLog actionLog = new ActionLog();
    @Inject
    private AuditLogger auditLogger;
    @Inject
    protected Gson gson;

    @Override
    public ExecutionCommand getExecutionCommand() {
        return this.executionCommand;
    }

    @Override
    public void setExecutionCommand(ExecutionCommand executionCommand) {
        this.executionCommand = executionCommand;
    }

    @Override
    public HostRoleCommand getHostRoleCommand() {
        return this.hostRoleCommand;
    }

    @Override
    public void setHostRoleCommand(HostRoleCommand hostRoleCommand) {
        this.hostRoleCommand = hostRoleCommand;
    }

    protected CommandReport createCompletedCommandReport() {
        return this.createCommandReport(0, HostRoleStatus.COMPLETED, "{}", this.actionLog.getStdOut(), this.actionLog.getStdErr());
    }

    protected CommandReport createCommandReport(int exitCode, HostRoleStatus status, String structuredOut, String stdout, String stderr) {
        CommandReport report = null;
        if (this.hostRoleCommand != null) {
            ExecutionCommandWrapper wrapper;
            if (this.executionCommand == null && (wrapper = this.hostRoleCommand.getExecutionCommandWrapper()) != null) {
                this.executionCommand = wrapper.getExecutionCommand();
            }
            if (this.executionCommand != null) {
                RoleCommand roleCommand = this.executionCommand.getRoleCommand();
                report = new CommandReport();
                report.setActionId(StageUtils.getActionId(this.hostRoleCommand.getRequestId(), this.hostRoleCommand.getStageId()));
                report.setClusterId(this.executionCommand.getClusterId());
                report.setRole(this.executionCommand.getRole());
                report.setRoleCommand(roleCommand == null ? null : roleCommand.toString());
                report.setServiceName(this.executionCommand.getServiceName());
                report.setTaskId(this.executionCommand.getTaskId());
                report.setStructuredOut(structuredOut);
                report.setStdErr(stderr == null ? "" : stderr);
                report.setStdOut(stdout == null ? "" : stdout);
                report.setStatus(status == null ? null : status.toString());
                report.setExitCode(exitCode);
            }
        }
        return report;
    }

    protected Map<String, String> getCommandParameters() {
        if (this.executionCommand == null) {
            return Collections.emptyMap();
        }
        return this.executionCommand.getCommandParams();
    }

    protected String getCommandParameterValue(String propertyName) {
        Map<String, String> commandParameters = this.getCommandParameters();
        return commandParameters == null ? null : commandParameters.get(propertyName);
    }

    protected void auditLog(AuditEvent ae) {
        this.auditLogger.log(ae);
    }
}

