/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.ldap;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.configuration.LdapUsernameCollisionHandlingBehavior;
import id.onyx.obdp.server.ldap.domain.OBDPLdapConfiguration;
import id.onyx.obdp.server.security.authorization.Group;
import id.onyx.obdp.server.security.authorization.LdapServerProperties;
import id.onyx.obdp.server.security.authorization.OBDPLdapUtils;
import id.onyx.obdp.server.security.authorization.User;
import id.onyx.obdp.server.security.authorization.Users;
import id.onyx.obdp.server.security.ldap.LdapBatchDto;
import id.onyx.obdp.server.security.ldap.LdapGroupDto;
import id.onyx.obdp.server.security.ldap.LdapSyncDto;
import id.onyx.obdp.server.security.ldap.LdapUserDto;
import id.onyx.obdp.server.security.ldap.LdapUserGroupMemberDto;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.control.PagedResultsDirContextProcessor;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.HardcodedFilter;
import org.springframework.ldap.filter.LikeFilter;
import org.springframework.ldap.filter.OrFilter;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class OBDPLdapDataPopulator {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPLdapDataPopulator.class);
    private Provider<OBDPLdapConfiguration> configurationProvider;
    private Users users;
    protected LdapServerProperties ldapServerProperties;
    private LdapTemplate ldapTemplate;
    private static final String UID_ATTRIBUTE = "uid";
    private static final String OBJECT_CLASS_ATTRIBUTE = "objectClass";
    private static final int USERS_PAGE_SIZE = 500;
    private static final String SYSTEM_PROPERTY_DISABLE_ENDPOINT_IDENTIFICATION = "com.sun.jndi.ldap.object.disableEndpointIdentification";
    private static final String IS_MEMBER_DN_REGEXP = "^(?i)(uid|cn|%s|%s)=.*$";
    private static final String MEMBER_ATTRIBUTE_REPLACE_STRING = "${member}";
    private static final String MEMBER_ATTRIBUTE_VALUE_PLACEHOLDER = "{member}";

    @Inject
    public OBDPLdapDataPopulator(Provider<OBDPLdapConfiguration> configurationProvider, Users users) {
        this.configurationProvider = configurationProvider;
        this.users = users;
        this.ldapServerProperties = null;
    }

    private synchronized LdapServerProperties getLdapProperties() {
        if (this.ldapServerProperties == null) {
            this.ldapServerProperties = this.getConfiguration().getLdapServerProperties();
        }
        return this.ldapServerProperties;
    }

    public boolean isLdapEnabled() {
        if (!this.getConfiguration().ldapEnabled()) {
            return false;
        }
        try {
            LdapTemplate ldapTemplate = this.loadLdapTemplate();
            ldapTemplate.search(this.getLdapProperties().getBaseDN(), "uid=dummy_search", new AttributesMapper(){

                public Object mapFromAttributes(Attributes arg0) throws NamingException {
                    return null;
                }
            });
            return true;
        }
        catch (Exception ex) {
            LOG.error("Could not connect to LDAP server - " + ex.getMessage());
            return false;
        }
    }

    public LdapSyncDto getLdapSyncInfo() {
        LdapSyncDto syncInfo = new LdapSyncDto();
        Map<String, Group> internalGroupsMap = this.getInternalGroups();
        Set<LdapGroupDto> externalGroups = this.getExternalLdapGroupInfo();
        for (LdapGroupDto externalGroup : externalGroups) {
            if (internalGroupsMap.containsKey(externalGroup.getGroupName()) && internalGroupsMap.get(externalGroup.getGroupName()).isLdapGroup()) {
                externalGroup.setSynced(true);
                continue;
            }
            externalGroup.setSynced(false);
        }
        Map<String, User> internalUsersMap = this.getInternalUsers();
        Set<LdapUserDto> externalUsers = this.getExternalLdapUserInfo();
        for (LdapUserDto externalUser : externalUsers) {
            String userName = externalUser.getUserName();
            if (internalUsersMap.containsKey(userName) && internalUsersMap.get(userName).isLdapUser()) {
                externalUser.setSynced(true);
                continue;
            }
            externalUser.setSynced(false);
        }
        syncInfo.setGroups(externalGroups);
        syncInfo.setUsers(externalUsers);
        return syncInfo;
    }

    public LdapBatchDto synchronizeAllLdapGroups(LdapBatchDto batchInfo, boolean collectIgnoredUsers) throws OBDPException {
        LOG.trace("Synchronize All LDAP groups...");
        Set<LdapGroupDto> externalLdapGroupInfo = this.getExternalLdapGroupInfo();
        Map<String, Group> internalGroupsMap = this.getInternalGroups();
        Map<String, User> internalUsersMap = this.getInternalUsers();
        for (LdapGroupDto ldapGroupDto : externalLdapGroupInfo) {
            this.addLdapGroup(batchInfo, internalGroupsMap, ldapGroupDto);
            this.refreshGroupMembers(batchInfo, ldapGroupDto, internalUsersMap, internalGroupsMap, null, false, collectIgnoredUsers);
        }
        for (Map.Entry entry : internalGroupsMap.entrySet()) {
            if (!((Group)entry.getValue()).isLdapGroup()) continue;
            LdapGroupDto groupDto = new LdapGroupDto();
            groupDto.setGroupName(((Group)entry.getValue()).getGroupName());
            batchInfo.getGroupsToBeRemoved().add(groupDto);
        }
        return batchInfo;
    }

    public LdapBatchDto synchronizeAllLdapUsers(LdapBatchDto batchInfo, boolean collectIgnoredUsers) throws OBDPException {
        LOG.trace("Synchronize All LDAP users...");
        Set<LdapUserDto> externalLdapUserInfo = this.getExternalLdapUserInfo();
        Map<String, User> internalUsersMap = this.getInternalUsers();
        for (LdapUserDto ldapUserDto : externalLdapUserInfo) {
            String userName = ldapUserDto.getUserName();
            if (internalUsersMap.containsKey(userName)) {
                User user = internalUsersMap.get(userName);
                if (user != null && !user.isLdapUser()) {
                    if (LdapUsernameCollisionHandlingBehavior.SKIP == this.getConfiguration().syncCollisionHandlingBehavior()) {
                        LOG.info("User '{}' skipped because it is local user", (Object)userName);
                        batchInfo.getUsersSkipped().add(ldapUserDto);
                    } else {
                        batchInfo.getUsersToBecomeLdap().add(ldapUserDto);
                        LOG.trace("Convert user '{}' to LDAP user.", (Object)userName);
                    }
                } else if (collectIgnoredUsers) {
                    batchInfo.getUsersIgnored().add(ldapUserDto);
                }
                internalUsersMap.remove(userName);
                continue;
            }
            batchInfo.getUsersToBeCreated().add(ldapUserDto);
        }
        for (Map.Entry entry : internalUsersMap.entrySet()) {
            if (!((User)entry.getValue()).isLdapUser()) continue;
            LdapUserDto userDto = new LdapUserDto();
            userDto.setUserName(((User)entry.getValue()).getUserName());
            userDto.setDn(null);
            batchInfo.getUsersToBeRemoved().add(userDto);
        }
        return batchInfo;
    }

    public LdapBatchDto synchronizeLdapGroups(Set<String> groups, LdapBatchDto batchInfo, boolean collectIgnoredUsers) throws OBDPException {
        LOG.trace("Synchronize LDAP groups...");
        HashSet<LdapGroupDto> specifiedGroups = new HashSet<LdapGroupDto>();
        for (String group : groups) {
            Set<LdapGroupDto> groupDtos = this.getLdapGroups(group);
            if (groupDtos.isEmpty()) {
                throw new OBDPException("Couldn't sync LDAP group " + group + ", it doesn't exist");
            }
            specifiedGroups.addAll(groupDtos);
        }
        Map<String, Group> internalGroupsMap = this.getInternalGroups();
        Map<String, User> internalUsersMap = this.getInternalUsers();
        for (LdapGroupDto groupDto : specifiedGroups) {
            this.addLdapGroup(batchInfo, internalGroupsMap, groupDto);
            this.refreshGroupMembers(batchInfo, groupDto, internalUsersMap, internalGroupsMap, null, true, collectIgnoredUsers);
        }
        return batchInfo;
    }

    public LdapBatchDto synchronizeLdapUsers(Set<String> users, LdapBatchDto batchInfo, boolean collectIgnoredUsers) throws OBDPException {
        LOG.trace("Synchronize LDAP users...");
        HashSet<LdapUserDto> specifiedUsers = new HashSet<LdapUserDto>();
        for (String user : users) {
            Set<LdapUserDto> userDtos = this.getLdapUsers(user);
            if (userDtos.isEmpty()) {
                throw new OBDPException("Couldn't sync LDAP user " + user + ", it doesn't exist");
            }
            specifiedUsers.addAll(userDtos);
        }
        Map<String, User> internalUsersMap = this.getInternalUsers();
        for (LdapUserDto userDto : specifiedUsers) {
            String userName = userDto.getUserName();
            if (internalUsersMap.containsKey(userName)) {
                User user = internalUsersMap.get(userName);
                if (user != null && !user.isLdapUser()) {
                    if (LdapUsernameCollisionHandlingBehavior.SKIP == this.getConfiguration().syncCollisionHandlingBehavior()) {
                        LOG.info("User '{}' skipped because it is local user", (Object)userName);
                        batchInfo.getUsersSkipped().add(userDto);
                    } else {
                        batchInfo.getUsersToBecomeLdap().add(userDto);
                    }
                } else if (collectIgnoredUsers) {
                    batchInfo.getUsersIgnored().add(userDto);
                }
                internalUsersMap.remove(userName);
                continue;
            }
            batchInfo.getUsersToBeCreated().add(userDto);
        }
        return batchInfo;
    }

    public LdapBatchDto synchronizeExistingLdapGroups(LdapBatchDto batchInfo, boolean collectIgnoredUsers) throws OBDPException {
        LOG.trace("Synchronize Existing LDAP groups...");
        Map<String, Group> internalGroupsMap = this.getInternalGroups();
        Map<String, User> internalUsersMap = this.getInternalUsers();
        HashSet internalGroupSet = Sets.newHashSet(internalGroupsMap.values());
        for (Group group : internalGroupSet) {
            LdapGroupDto groupDto;
            if (!group.isLdapGroup()) continue;
            Set<LdapGroupDto> groupDtos = this.getLdapGroups(group.getGroupName());
            if (groupDtos.isEmpty()) {
                groupDto = new LdapGroupDto();
                groupDto.setGroupName(group.getGroupName());
                batchInfo.getGroupsToBeRemoved().add(groupDto);
                continue;
            }
            groupDto = groupDtos.iterator().next();
            this.refreshGroupMembers(batchInfo, groupDto, internalUsersMap, internalGroupsMap, null, true, collectIgnoredUsers);
        }
        return batchInfo;
    }

    public LdapBatchDto synchronizeExistingLdapUsers(LdapBatchDto batchInfo, boolean collectIgnoredUsers) throws OBDPException {
        LOG.trace("Synchronize Existing LDAP users...");
        Map<String, User> internalUsersMap = this.getInternalUsers();
        for (User user : internalUsersMap.values()) {
            LdapUserDto userDto;
            if (!user.isLdapUser()) continue;
            Set<LdapUserDto> userDtos = this.getLdapUsers(user.getUserName());
            if (userDtos.isEmpty()) {
                userDto = new LdapUserDto();
                userDto.setUserName(user.getUserName());
                userDto.setDn(null);
                batchInfo.getUsersToBeRemoved().add(userDto);
                continue;
            }
            if (!collectIgnoredUsers) continue;
            userDto = new LdapUserDto();
            userDto.setUserName(user.getUserName());
            batchInfo.getUsersIgnored().add(userDto);
        }
        return batchInfo;
    }

    protected void refreshGroupMembers(LdapBatchDto batchInfo, LdapGroupDto group, Map<String, User> internalUsers, Map<String, Group> internalGroupsMap, Set<String> groupMemberAttributes, boolean recursive, boolean collectIgnoredUsers) throws OBDPException {
        HashSet<LdapUserDto> externalMembers = new HashSet<LdapUserDto>();
        if (groupMemberAttributes == null) {
            groupMemberAttributes = new HashSet<String>();
        }
        for (String memberAttributeValue : group.getMemberAttributes()) {
            LdapGroupDto ldapGroupDto;
            LdapUserDto groupMember = this.getLdapUserByMemberAttr(memberAttributeValue);
            if (groupMember != null) {
                externalMembers.add(groupMember);
                continue;
            }
            if (!recursive || groupMemberAttributes.contains(memberAttributeValue) || (ldapGroupDto = this.getLdapGroupByMemberAttr(memberAttributeValue)) == null) continue;
            groupMemberAttributes.add(memberAttributeValue);
            this.addLdapGroup(batchInfo, internalGroupsMap, ldapGroupDto);
            this.refreshGroupMembers(batchInfo, ldapGroupDto, internalUsers, internalGroupsMap, groupMemberAttributes, true, collectIgnoredUsers);
        }
        String groupName = group.getGroupName();
        Map<String, User> internalMembers = this.getInternalMembers(groupName);
        for (LdapUserDto ldapUserDto : externalMembers) {
            String userName = ldapUserDto.getUserName();
            if (internalUsers.containsKey(userName)) {
                User user = internalUsers.get(userName);
                if (user == null) {
                    if (internalMembers.containsKey(userName)) continue;
                    batchInfo.getMembershipToAdd().add(new LdapUserGroupMemberDto(groupName, ldapUserDto.getUserName()));
                    continue;
                }
                if (!user.isLdapUser()) {
                    if (LdapUsernameCollisionHandlingBehavior.SKIP == this.getConfiguration().syncCollisionHandlingBehavior()) {
                        LOG.info("User '{}' skipped because it is local user", (Object)userName);
                        batchInfo.getUsersSkipped().add(ldapUserDto);
                        continue;
                    }
                    batchInfo.getUsersToBecomeLdap().add(ldapUserDto);
                } else if (collectIgnoredUsers) {
                    batchInfo.getUsersIgnored().add(ldapUserDto);
                }
                if (!internalMembers.containsKey(userName)) {
                    batchInfo.getMembershipToAdd().add(new LdapUserGroupMemberDto(groupName, ldapUserDto.getUserName()));
                }
                internalMembers.remove(userName);
                continue;
            }
            batchInfo.getUsersToBeCreated().add(ldapUserDto);
            batchInfo.getMembershipToAdd().add(new LdapUserGroupMemberDto(groupName, ldapUserDto.getUserName()));
        }
        for (Map.Entry entry : internalMembers.entrySet()) {
            User user = (User)entry.getValue();
            batchInfo.getMembershipToRemove().add(new LdapUserGroupMemberDto(groupName, user.getUserName()));
        }
    }

    protected Set<LdapGroupDto> getLdapGroups(String groupName) {
        LdapServerProperties ldapServerProperties = this.getLdapProperties();
        EqualsFilter groupObjectFilter = new EqualsFilter(OBJECT_CLASS_ATTRIBUTE, ldapServerProperties.getGroupObjectClass());
        LikeFilter groupNameFilter = new LikeFilter(ldapServerProperties.getGroupNamingAttr(), groupName);
        return this.getFilteredLdapGroups(ldapServerProperties.getBaseDN(), new Filter[]{groupObjectFilter, groupNameFilter});
    }

    protected Set<LdapUserDto> getLdapUsers(String username) {
        LdapServerProperties ldapServerProperties = this.getLdapProperties();
        EqualsFilter userObjectFilter = new EqualsFilter(OBJECT_CLASS_ATTRIBUTE, ldapServerProperties.getUserObjectClass());
        LikeFilter userNameFilter = new LikeFilter(ldapServerProperties.getUsernameAttribute(), username);
        return this.getFilteredLdapUsers(ldapServerProperties.getBaseDN(), new Filter[]{userObjectFilter, userNameFilter});
    }

    protected LdapUserDto getLdapUserByMemberAttr(String memberAttributeValue) {
        Set<LdapUserDto> filteredLdapUsers;
        LdapServerProperties ldapServerProperties = this.getLdapProperties();
        memberAttributeValue = this.getUniqueIdByMemberPattern(memberAttributeValue, ldapServerProperties.getSyncUserMemberReplacePattern());
        Filter syncMemberFilter = this.createCustomMemberFilter(memberAttributeValue, ldapServerProperties.getSyncUserMemberFilter());
        if (memberAttributeValue != null && syncMemberFilter != null) {
            LOG.trace("Use custom filter '{}' for getting member user with default baseDN ('{}')", (Object)syncMemberFilter.encode(), (Object)ldapServerProperties.getBaseDN());
            filteredLdapUsers = this.getFilteredLdapUsers(ldapServerProperties.getBaseDN(), syncMemberFilter);
        } else if (memberAttributeValue != null && this.isMemberAttributeBaseDn(memberAttributeValue)) {
            LOG.trace("Member can be used as baseDn: {}", (Object)memberAttributeValue);
            EqualsFilter filter = new EqualsFilter(OBJECT_CLASS_ATTRIBUTE, ldapServerProperties.getUserObjectClass());
            filteredLdapUsers = this.getFilteredLdapUsers(memberAttributeValue, (Filter)filter);
        } else {
            LOG.trace("Member cannot be used as baseDn: {}", (Object)memberAttributeValue);
            AndFilter filter = new AndFilter().and((Filter)new EqualsFilter(OBJECT_CLASS_ATTRIBUTE, ldapServerProperties.getUserObjectClass())).and((Filter)new EqualsFilter(ldapServerProperties.getUsernameAttribute(), memberAttributeValue));
            filteredLdapUsers = this.getFilteredLdapUsers(ldapServerProperties.getBaseDN(), (Filter)filter);
        }
        return filteredLdapUsers.isEmpty() ? null : filteredLdapUsers.iterator().next();
    }

    protected LdapGroupDto getLdapGroupByMemberAttr(String memberAttributeValue) {
        Set<LdapGroupDto> filteredLdapGroups;
        LdapServerProperties ldapServerProperties = this.getLdapProperties();
        memberAttributeValue = this.getUniqueIdByMemberPattern(memberAttributeValue, ldapServerProperties.getSyncGroupMemberReplacePattern());
        Filter syncMemberFilter = this.createCustomMemberFilter(memberAttributeValue, ldapServerProperties.getSyncGroupMemberFilter());
        if (memberAttributeValue != null && syncMemberFilter != null) {
            LOG.trace("Use custom filter '{}' for getting member group with default baseDN ('{}')", (Object)syncMemberFilter.encode(), (Object)ldapServerProperties.getBaseDN());
            filteredLdapGroups = this.getFilteredLdapGroups(ldapServerProperties.getBaseDN(), syncMemberFilter);
        } else if (memberAttributeValue != null && this.isMemberAttributeBaseDn(memberAttributeValue)) {
            LOG.trace("Member can be used as baseDn: {}", (Object)memberAttributeValue);
            EqualsFilter filter = new EqualsFilter(OBJECT_CLASS_ATTRIBUTE, ldapServerProperties.getGroupObjectClass());
            filteredLdapGroups = this.getFilteredLdapGroups(memberAttributeValue, (Filter)filter);
        } else {
            LOG.trace("Member cannot be used as baseDn: {}", (Object)memberAttributeValue);
            filteredLdapGroups = this.getFilteredLdapGroups(ldapServerProperties.getBaseDN(), new Filter[]{new EqualsFilter(OBJECT_CLASS_ATTRIBUTE, ldapServerProperties.getGroupObjectClass()), this.getMemberFilter(memberAttributeValue)});
        }
        return filteredLdapGroups.isEmpty() ? null : filteredLdapGroups.iterator().next();
    }

    protected Filter createCustomMemberFilter(String memberAttributeValue, String syncMemberFilter) {
        HardcodedFilter filter = null;
        if (StringUtils.isNotEmpty((String)syncMemberFilter)) {
            filter = new HardcodedFilter(syncMemberFilter.replace(MEMBER_ATTRIBUTE_VALUE_PLACEHOLDER, memberAttributeValue));
        }
        return filter;
    }

    protected String getUniqueIdByMemberPattern(String memberAttributeValue, String pattern) {
        if (StringUtils.isNotEmpty((String)memberAttributeValue) && StringUtils.isNotEmpty((String)pattern)) {
            try {
                Pattern p = Pattern.compile(pattern);
                Matcher m = p.matcher(memberAttributeValue);
                LOG.debug("Apply replace pattern '{}' on '{}' membership attribbute value.", (Object)memberAttributeValue, (Object)pattern);
                if (m.matches()) {
                    memberAttributeValue = m.replaceAll(MEMBER_ATTRIBUTE_REPLACE_STRING);
                    LOG.debug("Membership attribute value after replace pattern applied: '{}'", (Object)memberAttributeValue);
                } else {
                    LOG.warn("Membership attribute value pattern is not matched ({}) on '{}'", (Object)pattern, (Object)memberAttributeValue);
                }
            }
            catch (Exception e) {
                LOG.error("Error during replace memberAttribute '{}' with pattern '{}'", (Object)memberAttributeValue, (Object)pattern);
            }
        }
        return memberAttributeValue;
    }

    protected void cleanUpLdapUsersWithoutGroup() throws OBDPException {
        List<User> allUsers = this.users.getAllUsers();
        for (User user : allUsers) {
            if (!user.isLdapUser() || !user.getGroups().isEmpty()) continue;
            this.users.removeUser(user);
        }
    }

    protected void addLdapGroup(LdapBatchDto batchInfo, Map<String, Group> internalGroupsMap, LdapGroupDto groupDto) {
        String groupName = groupDto.getGroupName();
        if (internalGroupsMap.containsKey(groupName)) {
            Group group = internalGroupsMap.get(groupName);
            if (!group.isLdapGroup()) {
                batchInfo.getGroupsToBecomeLdap().add(groupDto);
                LOG.trace("Convert group '{}' to LDAP group.", (Object)groupName);
            }
            internalGroupsMap.remove(groupName);
            batchInfo.getGroupsProcessedInternal().add(groupDto);
        } else if (!batchInfo.getGroupsProcessedInternal().contains(groupDto)) {
            batchInfo.getGroupsToBeCreated().add(groupDto);
        }
    }

    protected boolean isMemberAttributeBaseDn(String memberAttributeValue) {
        LdapServerProperties ldapServerProperties = this.getLdapProperties();
        Pattern pattern = Pattern.compile(String.format(IS_MEMBER_DN_REGEXP, ldapServerProperties.getUsernameAttribute(), ldapServerProperties.getGroupNamingAttr()));
        return pattern.matcher(memberAttributeValue).find();
    }

    protected Set<LdapGroupDto> getExternalLdapGroupInfo() {
        LdapServerProperties ldapServerProperties = this.getLdapProperties();
        EqualsFilter groupObjectFilter = new EqualsFilter(OBJECT_CLASS_ATTRIBUTE, ldapServerProperties.getGroupObjectClass());
        return this.getFilteredLdapGroups(ldapServerProperties.getBaseDN(), (Filter)groupObjectFilter);
    }

    private Filter getMemberFilter(String memberAttributeValue) {
        LdapServerProperties ldapServerProperties = this.getLdapProperties();
        String dnAttribute = ldapServerProperties.getDnAttribute();
        return new OrFilter().or((Filter)new EqualsFilter(dnAttribute, memberAttributeValue)).or((Filter)new EqualsFilter(UID_ATTRIBUTE, memberAttributeValue));
    }

    private Set<LdapGroupDto> getFilteredLdapGroups(String baseDn, Filter ... filters) {
        AndFilter andFilter = new AndFilter();
        for (Filter filter : filters) {
            andFilter.and(filter);
        }
        return this.getFilteredLdapGroups(baseDn, (Filter)andFilter);
    }

    private Set<LdapGroupDto> getFilteredLdapGroups(String baseDn, Filter filter) {
        HashSet<LdapGroupDto> groups = new HashSet<LdapGroupDto>();
        LdapTemplate ldapTemplate = this.loadLdapTemplate();
        LdapServerProperties ldapServerProperties = this.getLdapProperties();
        LOG.trace("LDAP Group Query - Base DN: '{}' ; Filter: '{}'", (Object)baseDn, (Object)filter.encode());
        ldapTemplate.search(baseDn, filter.encode(), (ContextMapper)new LdapGroupContextMapper(groups, ldapServerProperties));
        return groups;
    }

    protected Set<LdapUserDto> getExternalLdapUserInfo() {
        LdapServerProperties ldapServerProperties = this.getLdapProperties();
        EqualsFilter userObjectFilter = new EqualsFilter(OBJECT_CLASS_ATTRIBUTE, ldapServerProperties.getUserObjectClass());
        return this.getFilteredLdapUsers(ldapServerProperties.getBaseDN(), (Filter)userObjectFilter);
    }

    private Set<LdapUserDto> getFilteredLdapUsers(String baseDn, Filter ... filters) {
        AndFilter andFilter = new AndFilter();
        for (Filter filter : filters) {
            andFilter.and(filter);
        }
        return this.getFilteredLdapUsers(baseDn, (Filter)andFilter);
    }

    private Set<LdapUserDto> getFilteredLdapUsers(String baseDn, Filter filter) {
        HashSet<LdapUserDto> users = new HashSet<LdapUserDto>();
        LdapTemplate ldapTemplate = this.loadLdapTemplate();
        LdapServerProperties ldapServerProperties = this.getLdapProperties();
        PagedResultsDirContextProcessor processor = this.createPagingProcessor();
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningObjFlag(true);
        searchControls.setSearchScope(2);
        LdapUserContextMapper ldapUserContextMapper = new LdapUserContextMapper(ldapServerProperties);
        String encodedFilter = filter.encode();
        do {
            LOG.trace("LDAP User Query - Base DN: '{}' ; Filter: '{}'", (Object)baseDn, (Object)encodedFilter);
            List dtos = ldapServerProperties.isPaginationEnabled() ? ldapTemplate.search((Name)LdapUtils.newLdapName((String)baseDn), encodedFilter, searchControls, (ContextMapper)ldapUserContextMapper, (DirContextProcessor)processor) : ldapTemplate.search((Name)LdapUtils.newLdapName((String)baseDn), encodedFilter, searchControls, (ContextMapper)ldapUserContextMapper);
            for (Object dto : dtos) {
                if (dto == null) continue;
                users.add((LdapUserDto)dto);
            }
        } while (ldapServerProperties.isPaginationEnabled() && processor.getCookie() != null && processor.getCookie().getCookie() != null);
        return users;
    }

    protected Map<String, Group> getInternalGroups() {
        List<Group> internalGroups = this.users.getAllGroups();
        HashMap<String, Group> internalGroupsMap = new HashMap<String, Group>();
        for (Group group : internalGroups) {
            internalGroupsMap.put(group.getGroupName(), group);
        }
        return internalGroupsMap;
    }

    protected Map<String, User> getInternalUsers() {
        List<User> internalUsers = this.users.getAllUsers();
        HashMap<String, User> internalUsersMap = new HashMap<String, User>();
        LOG.trace("Get all users from Ambari Server.");
        for (User user : internalUsers) {
            internalUsersMap.put(user.getUserName(), user);
        }
        return internalUsersMap;
    }

    protected Map<String, User> getInternalMembers(String groupName) {
        Collection<User> internalMembers = this.users.getGroupMembers(groupName);
        if (internalMembers == null) {
            return Collections.emptyMap();
        }
        HashMap<String, User> internalMembersMap = new HashMap<String, User>();
        for (User user : internalMembers) {
            internalMembersMap.put(user.getUserName(), user);
        }
        return internalMembersMap;
    }

    protected LdapTemplate loadLdapTemplate() {
        LdapServerProperties properties = this.getConfiguration().getLdapServerProperties();
        if (this.ldapTemplate == null || !properties.equals(this.getLdapProperties())) {
            LOG.info("Reloading properties");
            this.ldapServerProperties = properties;
            LdapContextSource ldapContextSource = this.createLdapContextSource();
            ldapContextSource.setPooled(true);
            List<String> ldapUrls = this.ldapServerProperties.getLdapUrls();
            ldapContextSource.setUrls(ldapUrls.toArray(new String[ldapUrls.size()]));
            if (!this.ldapServerProperties.isAnonymousBind()) {
                ldapContextSource.setUserDn(this.ldapServerProperties.getManagerDn());
                ldapContextSource.setPassword(this.ldapServerProperties.getManagerPassword());
            }
            if (this.ldapServerProperties.isUseSsl() && this.ldapServerProperties.isDisableEndpointIdentification()) {
                System.setProperty(SYSTEM_PROPERTY_DISABLE_ENDPOINT_IDENTIFICATION, "true");
                LOG.info("Disabled endpoint identification");
            } else {
                System.clearProperty(SYSTEM_PROPERTY_DISABLE_ENDPOINT_IDENTIFICATION);
                LOG.info("Removed endpoint identification disabling");
            }
            ldapContextSource.setReferral(this.ldapServerProperties.getReferralMethod());
            try {
                ldapContextSource.afterPropertiesSet();
            }
            catch (Exception e) {
                LOG.error("LDAP Context Source not loaded ", (Throwable)e);
                throw new UsernameNotFoundException("LDAP Context Source not loaded", (Throwable)e);
            }
            this.ldapTemplate = this.createLdapTemplate(ldapContextSource);
            this.ldapTemplate.setIgnorePartialResultException(true);
        }
        return this.ldapTemplate;
    }

    protected LdapContextSource createLdapContextSource() {
        return new LdapContextSource();
    }

    protected PagedResultsDirContextProcessor createPagingProcessor() {
        return new PagedResultsDirContextProcessor(500, null);
    }

    protected LdapTemplate createLdapTemplate(LdapContextSource ldapContextSource) {
        return new LdapTemplate((ContextSource)ldapContextSource);
    }

    private OBDPLdapConfiguration getConfiguration() {
        return (OBDPLdapConfiguration)this.configurationProvider.get();
    }

    protected static class LdapGroupContextMapper
    implements ContextMapper {
        private final Set<LdapGroupDto> groups;
        private final LdapServerProperties ldapServerProperties;

        public LdapGroupContextMapper(Set<LdapGroupDto> groups, LdapServerProperties ldapServerProperties) {
            this.groups = groups;
            this.ldapServerProperties = ldapServerProperties;
        }

        public Object mapFromContext(Object ctx) {
            DirContextAdapter adapter = (DirContextAdapter)ctx;
            String groupNameAttribute = adapter.getStringAttribute(this.ldapServerProperties.getGroupNamingAttr());
            boolean outOfScope = OBDPLdapUtils.isLdapObjectOutOfScopeFromBaseDn(adapter, this.ldapServerProperties.getBaseDN());
            if (outOfScope) {
                LOG.warn("Group '{}' is out of scope of the base DN. It will be skipped.", (Object)groupNameAttribute);
                return null;
            }
            if (groupNameAttribute != null) {
                LdapGroupDto group = new LdapGroupDto();
                group.setGroupName(groupNameAttribute.toLowerCase());
                String[] uniqueMembers = adapter.getStringAttributes(this.ldapServerProperties.getGroupMembershipAttr());
                if (uniqueMembers != null) {
                    for (String uniqueMember : uniqueMembers) {
                        group.getMemberAttributes().add(uniqueMember.toLowerCase());
                    }
                }
                this.groups.add(group);
            }
            return null;
        }
    }

    protected static class LdapUserContextMapper
    implements ContextMapper {
        private final LdapServerProperties ldapServerProperties;

        public LdapUserContextMapper(LdapServerProperties ldapServerProperties) {
            this.ldapServerProperties = ldapServerProperties;
        }

        public Object mapFromContext(Object ctx) {
            DirContextAdapter adapter = (DirContextAdapter)ctx;
            String usernameAttribute = adapter.getStringAttribute(this.ldapServerProperties.getUsernameAttribute());
            String uidAttribute = adapter.getStringAttribute(OBDPLdapDataPopulator.UID_ATTRIBUTE);
            boolean outOfScope = OBDPLdapUtils.isLdapObjectOutOfScopeFromBaseDn(adapter, this.ldapServerProperties.getBaseDN());
            if (outOfScope) {
                LOG.warn("User '{}' is out of scope of the base DN. It will be skipped.", (Object)usernameAttribute);
                return null;
            }
            if (usernameAttribute != null || uidAttribute != null) {
                LdapUserDto user = new LdapUserDto();
                user.setUserName(usernameAttribute != null ? usernameAttribute.toLowerCase() : null);
                user.setUid(uidAttribute != null ? uidAttribute.toLowerCase() : null);
                user.setDn(adapter.getNameInNamespace().toLowerCase());
                return user;
            }
            LOG.warn("Ignoring LDAP user " + adapter.getNameInNamespace() + " as it doesn't have required attributes uid and " + this.ldapServerProperties.getUsernameAttribute());
            return null;
        }
    }
}

