/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.encryption;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.persist.PersistService;
import id.onyx.obdp.server.audit.AuditLoggerModule;
import id.onyx.obdp.server.controller.ControllerModule;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.ldap.LdapModule;
import id.onyx.obdp.server.security.encryption.ConfigPropertiesEncryptor;
import id.onyx.obdp.server.security.encryption.Encryptor;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.utils.EventBusSynchronizer;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveDataEncryption {
    private static final Logger LOG = LoggerFactory.getLogger(SensitiveDataEncryption.class);
    private final PersistService persistService;
    private final Injector injector;

    @Inject
    public SensitiveDataEncryption(Injector injector, PersistService persistService) {
        this.injector = injector;
        this.persistService = persistService;
    }

    public void startPersistenceService() {
        this.persistService.start();
    }

    public void stopPersistenceService() {
        this.persistService.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1 || !"encryption".equals(args[0]) && !"decryption".equals(args[0])) {
            LOG.error("The action parameter (\"encryption\" or \"decryption\") is required");
            System.exit(-1);
        }
        boolean encrypt = "encryption".equals(args[0]);
        SensitiveDataEncryption sensitiveDataEncryption = null;
        try {
            Injector injector = Guice.createInjector((Module[])new Module[]{new EncryptionHelperControllerModule(), new EncryptionHelperAuditModule(), new LdapModule()});
            sensitiveDataEncryption = (SensitiveDataEncryption)injector.getInstance(SensitiveDataEncryption.class);
            sensitiveDataEncryption.startPersistenceService();
            sensitiveDataEncryption.doEncryption(encrypt);
        }
        catch (Throwable e) {
            LOG.error("Exception occurred during config encryption/decryption:", e);
        }
        finally {
            if (sensitiveDataEncryption != null) {
                sensitiveDataEncryption.stopPersistenceService();
            }
        }
    }

    public void doEncryption(boolean encrypt) {
        Map<String, Cluster> clusterMap;
        OBDPManagementController ambariManagementController = (OBDPManagementController)this.injector.getInstance(OBDPManagementController.class);
        Encryptor configEncryptor = (Encryptor)this.injector.getInstance(ConfigPropertiesEncryptor.class);
        Clusters clusters = ambariManagementController.getClusters();
        if (clusters != null && (clusterMap = clusters.getClusters()) != null && !clusterMap.isEmpty()) {
            for (Cluster cluster : clusterMap.values()) {
                Collection<Config> configs = cluster.getAllConfigs();
                for (Config config : configs) {
                    if (encrypt) {
                        configEncryptor.encryptSensitiveData(config);
                    } else {
                        configEncryptor.decryptSensitiveData(config);
                    }
                    config.save();
                }
            }
        }
    }

    private static class EncryptionHelperControllerModule
    extends ControllerModule {
        @Override
        protected void configure() {
            super.configure();
            EventBusSynchronizer.synchronizeAmbariEventPublisher(this.binder());
        }
    }

    private static class EncryptionHelperAuditModule
    extends AuditLoggerModule {
        private EncryptionHelperAuditModule() {
        }

        @Override
        protected void configure() {
            super.configure();
        }
    }
}

