/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.encryption;

import id.onyx.obdp.server.security.encryption.EncryptionService;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.utils.TextEncoding;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;

public class PropertiesEncryptor {
    private final Map<Long, Map<StackId, Map<String, Set<String>>>> clusterPasswordProperties = new ConcurrentHashMap<Long, Map<StackId, Map<String, Set<String>>>>();
    protected final EncryptionService encryptionService;

    public PropertiesEncryptor(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    protected void encrypt(Map<String, String> configProperties, Cluster cluster, String configType, String encryptionKey) {
        this.encrypt(configProperties, cluster, configType, (String value) -> this.encryptAndDecoratePropertyValue((String)value, encryptionKey));
    }

    protected void encrypt(Map<String, String> configProperties, Cluster cluster, String configType) {
        this.encrypt(configProperties, cluster, configType, (String value) -> this.encryptAndDecoratePropertyValue((String)value));
    }

    protected void encrypt(Map<String, String> configProperties, Cluster cluster, String configType, Function<String, String> encryption) {
        Set<String> passwordProperties = this.getPasswordProperties(cluster, configType);
        if (CollectionUtils.isNotEmpty(passwordProperties)) {
            for (Map.Entry<String, String> property : configProperties.entrySet()) {
                if (!this.shouldEncrypt(property, passwordProperties)) continue;
                configProperties.put(property.getKey(), encryption.apply(property.getValue()));
            }
        }
    }

    private boolean shouldEncrypt(Map.Entry<String, String> property, Set<String> passwordProperties) {
        return passwordProperties.contains(property.getKey()) && !this.isEncryptedPassword(property.getValue());
    }

    private boolean isEncryptedPassword(String password) {
        return password != null && password.startsWith("${enc=aes256_hex, value=");
    }

    private Set<String> getPasswordProperties(Cluster cluster, String configType) {
        if (cluster.getCurrentStackVersion().equals(cluster.getDesiredStackVersion())) {
            return this.getPasswordProperties(cluster, cluster.getCurrentStackVersion(), configType);
        }
        return this.getPasswordProperties(cluster, cluster.getDesiredStackVersion(), configType);
    }

    private Set<String> getPasswordProperties(Cluster cluster, StackId stackId, String configType) {
        long clusterId = cluster.getClusterId();
        this.clusterPasswordProperties.computeIfAbsent(clusterId, v -> new ConcurrentHashMap()).computeIfAbsent(stackId, v -> new ConcurrentHashMap()).computeIfAbsent(configType, v -> cluster.getConfigPropertiesTypes(configType, stackId).getOrDefault((Object)PropertyInfo.PropertyType.PASSWORD, new HashSet()));
        return this.clusterPasswordProperties.get(clusterId).get(stackId).getOrDefault(configType, new HashSet());
    }

    private String encryptAndDecoratePropertyValue(String propertyValue) {
        String encrypted = this.encryptionService.encrypt(propertyValue, TextEncoding.BIN_HEX);
        return String.format("${enc=aes256_hex, value=%s}", encrypted);
    }

    private String encryptAndDecoratePropertyValue(String propertyValue, String encryptionKey) {
        String encrypted = this.encryptionService.encrypt(propertyValue, encryptionKey, TextEncoding.BIN_HEX);
        return String.format("${enc=aes256_hex, value=%s}", encrypted);
    }

    protected void decrypt(Map<String, String> configProperties) {
        for (Map.Entry<String, String> property : configProperties.entrySet()) {
            if (!this.isEncryptedPassword(property.getValue())) continue;
            configProperties.put(property.getKey(), this.decryptProperty(property.getValue()));
        }
    }

    private String decryptProperty(String property) {
        String encrypted = property.substring("${enc=aes256_hex, value=".length(), property.indexOf(125));
        return this.encryptionService.decrypt(encrypted, TextEncoding.BIN_HEX);
    }
}

