/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.encryption;

import com.google.inject.Inject;
import id.onyx.obdp.server.configuration.OBDPServerConfiguration;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationKey;
import id.onyx.obdp.server.security.encryption.EncryptionService;
import id.onyx.obdp.server.security.encryption.Encryptor;
import id.onyx.obdp.server.utils.TextEncoding;
import java.util.Map;
import java.util.Set;

public class OBDPServerConfigurationEncryptor
implements Encryptor<OBDPServerConfiguration> {
    private final Set<String> passwordConfigurations = OBDPServerConfigurationKey.findPasswordConfigurations();
    private final EncryptionService encryptionService;

    @Inject
    public OBDPServerConfigurationEncryptor(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    @Override
    public void encryptSensitiveData(OBDPServerConfiguration encryptible) {
        encryptible.toMap().entrySet().stream().filter(f -> this.shouldEncrypt((Map.Entry<String, String>)f)).forEach(entry -> encryptible.setValueFor((String)entry.getKey(), this.encryptAndDecorateConfigValue((String)entry.getValue())));
    }

    private boolean shouldEncrypt(Map.Entry<String, String> config) {
        return this.passwordConfigurations.contains(config.getKey()) && !this.isEncryptedPassword(config.getValue());
    }

    private String encryptAndDecorateConfigValue(String propertyValue) {
        String encrypted = this.encryptionService.encrypt(propertyValue, TextEncoding.BIN_HEX);
        return String.format("${enc=aes256_hex, value=%s}", encrypted);
    }

    @Override
    public void decryptSensitiveData(OBDPServerConfiguration decryptible) {
        decryptible.toMap().entrySet().stream().filter(f -> this.passwordConfigurations.contains(f.getKey())).filter(f -> this.isEncryptedPassword((String)f.getValue())).forEach(entry -> decryptible.setValueFor((String)entry.getKey(), this.decryptConfig((String)entry.getValue())));
    }

    private boolean isEncryptedPassword(String password) {
        return password != null && password.startsWith("${enc=aes256_hex, value=");
    }

    private String decryptConfig(String property) {
        String encrypted = property.substring("${enc=aes256_hex, value=".length(), property.indexOf(125));
        return this.encryptionService.decrypt(encrypted, TextEncoding.BIN_HEX);
    }

    @Override
    public String getEncryptionKey() {
        return this.encryptionService.getAmbariMasterKey();
    }
}

