/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.encryption;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.security.encryption.AESEncryptionService;
import id.onyx.obdp.server.security.encryption.EncryptionService;
import id.onyx.obdp.server.security.encryption.MasterKeyService;
import id.onyx.obdp.server.utils.AmbariPath;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.net.ntp.TimeStamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterKeyServiceImpl
implements MasterKeyService {
    private static final Logger LOG = LoggerFactory.getLogger(MasterKeyServiceImpl.class);
    private static final String MASTER_PASSPHRASE = "masterpassphrase";
    private static final String MASTER_PERSISTENCE_TAG_PREFIX = "#1.0# ";
    private final EncryptionService encryptionService = new AESEncryptionService();
    private char[] master = null;

    public MasterKeyServiceImpl(File masterKeyFile) {
        this.initFromFile(masterKeyFile);
    }

    private void initFromFile(File masterKeyFile) {
        if (masterKeyFile == null) {
            throw new IllegalArgumentException("Master Key location not provided.");
        }
        if (masterKeyFile.exists()) {
            if (MasterKeyServiceImpl.isMasterKeyFile(masterKeyFile)) {
                try {
                    this.initializeFromFile(masterKeyFile);
                }
                catch (Exception e) {
                    LOG.error(String.format("Cannot initialize master key from %s: %s", masterKeyFile.getAbsolutePath(), e.getLocalizedMessage()), (Throwable)e);
                }
            } else {
                LOG.error(String.format("The file at %s is not a master ket file", masterKeyFile.getAbsolutePath()));
            }
        } else {
            LOG.error(String.format("Cannot open master key file, %s", masterKeyFile.getAbsolutePath()));
        }
    }

    public MasterKeyServiceImpl(String masterKey) {
        if (masterKey == null) {
            throw new IllegalArgumentException("Master key cannot be null");
        }
        this.master = masterKey.toCharArray();
    }

    public MasterKeyServiceImpl() {
    }

    public MasterKeyServiceImpl(Configuration configuration) {
        if (configuration != null && configuration.isMasterKeyPersisted()) {
            if (configuration.getMasterKeyLocation() == null) {
                throw new IllegalArgumentException("The master key file location must be specified if the master key is persisted");
            }
            this.initFromFile(configuration.getMasterKeyLocation());
        } else {
            this.initializeFromEnv();
        }
    }

    @Override
    public boolean isMasterKeyInitialized() {
        return this.master != null;
    }

    @Override
    public char[] getMasterSecret() {
        return this.master;
    }

    public static void main(String[] args) {
        String masterKey = "ThisissomeSecretPassPhrasse";
        String masterKeyLocation = AmbariPath.getPath("/var/lib/obdp-server/keys/master");
        boolean persistMasterKey = false;
        if (args != null && args.length > 0) {
            masterKey = args[0];
            if (args.length > 1) {
                masterKeyLocation = args[1];
            }
            if (args.length > 2 && !args[2].isEmpty()) {
                persistMasterKey = args[2].equalsIgnoreCase("true");
            }
        }
        MasterKeyServiceImpl masterKeyService = new MasterKeyServiceImpl(masterKey);
        if (persistMasterKey && !masterKeyService.initializeMasterKeyFile(new File(masterKeyLocation), masterKey)) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    public boolean initializeMasterKeyFile(File masterKeyFile, String masterKey) {
        LOG.debug("Persisting master key into {}", (Object)masterKeyFile.getAbsolutePath());
        String encryptedMasterKey = null;
        if (masterKey != null) {
            try {
                encryptedMasterKey = this.encryptionService.encrypt(masterKey, MASTER_PASSPHRASE);
            }
            catch (Exception e) {
                LOG.error(String.format("Failed to encrypt master key, no changes have been made: %s", e.getLocalizedMessage()), (Throwable)e);
                return false;
            }
        }
        if (masterKeyFile.exists()) {
            if (masterKeyFile.length() == 0L || MasterKeyServiceImpl.isMasterKeyFile(masterKeyFile)) {
                LOG.info(String.format("Master key file exists at %s, resetting.", masterKeyFile.getAbsolutePath()));
                try (FileOutputStream fos = new FileOutputStream(masterKeyFile);
                     FileChannel fileChannel = fos.getChannel();){
                    fileChannel.truncate(0L);
                }
                catch (FileNotFoundException e) {
                    LOG.error(String.format("Failed to open key file at %s: %s", masterKeyFile.getAbsolutePath(), e.getLocalizedMessage()), (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error(String.format("Failed to reset key file at %s: %s", masterKeyFile.getAbsolutePath(), e.getLocalizedMessage()), (Throwable)e);
                }
            } else {
                LOG.info(String.format("File exists at %s, but may not be a master key file. It must be manually removed before this file location can be used", masterKeyFile.getAbsolutePath()));
                return false;
            }
        }
        if (encryptedMasterKey != null) {
            try {
                ArrayList<Object> lines = new ArrayList<Object>();
                lines.add(MASTER_PERSISTENCE_TAG_PREFIX + TimeStamp.getCurrentTime().toDateString());
                lines.add(encryptedMasterKey);
                FileUtils.writeLines((File)masterKeyFile, (String)"UTF8", lines);
                MasterKeyServiceImpl.protectAccess(masterKeyFile);
            }
            catch (IOException e) {
                LOG.error(String.format("Failed to persist master key to %s: %s ", masterKeyFile.getAbsolutePath(), e.getLocalizedMessage()), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private static boolean isMasterKeyFile(File file) {
        boolean bl;
        FileReader reader = new FileReader(file);
        try {
            char[] buffer = new char[MASTER_PERSISTENCE_TAG_PREFIX.length()];
            bl = reader.read(buffer) == buffer.length && Arrays.equals(buffer, MASTER_PERSISTENCE_TAG_PREFIX.toCharArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return false;
            }
        }
        reader.close();
        return bl;
    }

    private static void protectAccess(File file) throws OBDPException {
        if (file.exists()) {
            if (!file.setReadable(false, false) || !file.setReadable(true, true)) {
                String message = String.format("Failed to set %s readable only by current user", file.getAbsolutePath());
                LOG.warn(message);
                throw new OBDPException(message);
            }
            if (!file.setWritable(false, false) || !file.setWritable(true, true)) {
                String message = String.format("Failed to set %s writable only by current user", file.getAbsolutePath());
                LOG.warn(message);
                throw new OBDPException(message);
            }
            if (file.isDirectory()) {
                if (!file.setExecutable(false, false) || !file.setExecutable(true, true)) {
                    String message = String.format("Failed to set %s executable by current user", file.getAbsolutePath());
                    LOG.warn(message);
                    throw new OBDPException(message);
                }
            } else if (!file.setExecutable(false, false)) {
                String message = String.format("Failed to set %s not executable", file.getAbsolutePath());
                LOG.warn(message);
                throw new OBDPException(message);
            }
        }
    }

    private void initializeFromEnv() {
        Map<String, String> envVariables = System.getenv();
        if (envVariables != null && !envVariables.isEmpty()) {
            String key = envVariables.get("OBDP_SECURITY_MASTER_KEY");
            if (key == null || key.isEmpty()) {
                String keyPath = envVariables.get(Configuration.MASTER_KEY_LOCATION.getKey());
                if (keyPath != null && !keyPath.isEmpty()) {
                    File keyFile = new File(keyPath);
                    if (keyFile.exists()) {
                        try {
                            this.initializeFromFile(keyFile);
                        }
                        catch (Exception e) {
                            LOG.error("Cannot read master key from file: " + keyPath);
                            e.printStackTrace();
                        }
                    }
                } else {
                    LOG.error("Cannot read master key property {1} or master key file property {3} from environment");
                }
            } else {
                this.master = key.toCharArray();
            }
        }
    }

    private void initializeFromFile(File masterFile) throws Exception {
        try {
            List lines = FileUtils.readLines((File)masterFile, (String)"UTF8");
            String tag = (String)lines.get(0);
            LOG.info("Loading from persistent master: " + tag);
            this.master = this.encryptionService.decrypt((String)lines.get(1), MASTER_PASSPHRASE).toCharArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

