/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.encryption;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.security.credential.Credential;
import id.onyx.obdp.server.security.encryption.AbstractCredentialStore;
import java.security.KeyStore;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryCredentialStore
extends AbstractCredentialStore {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryCredentialStore.class);
    private final Cache<String, KeyStore> cache;

    public InMemoryCredentialStore() {
        this(0L, TimeUnit.MINUTES, false);
    }

    public InMemoryCredentialStore(final long retentionDuration, final TimeUnit units, boolean activelyPurge) {
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (retentionDuration > 0L) {
            if (activelyPurge) {
                ThreadFactory threadFactory = new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable runnable) {
                        Thread t = Executors.defaultThreadFactory().newThread(runnable);
                        if (t != null) {
                            t.setName(String.format("%s active cleanup timer", InMemoryCredentialStore.class.getSimpleName()));
                            t.setDaemon(true);
                        }
                        return t;
                    }
                };
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Cleaning up cache due to retention timeout of {} milliseconds", (Object)units.toMillis(retentionDuration));
                        }
                        InMemoryCredentialStore.this.cache.cleanUp();
                    }
                };
                Executors.newSingleThreadScheduledExecutor(threadFactory).schedule(runnable, 1L, TimeUnit.MINUTES);
            }
            builder.expireAfterWrite(retentionDuration, units);
        }
        this.cache = builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCredential(String alias, Credential credential) throws OBDPException {
        if (alias == null || alias.isEmpty()) {
            throw new IllegalArgumentException("Alias cannot be null or empty.");
        }
        Lock lock = this.getLock();
        lock.lock();
        try {
            KeyStore keyStore = this.loadKeyStore(null, "JCEKS");
            this.addCredential(keyStore, alias, credential);
            this.cache.put((Object)alias, (Object)keyStore);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credential getCredential(String alias) throws OBDPException {
        Credential credential = null;
        if (alias != null && !alias.isEmpty()) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                KeyStore keyStore = (KeyStore)this.cache.getIfPresent((Object)alias);
                if (keyStore != null) {
                    credential = this.getCredential(keyStore, alias);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return credential;
    }

    @Override
    public void removeCredential(String alias) throws OBDPException {
        if (alias != null) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                this.cache.invalidate((Object)alias);
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public Set<String> listCredentials() throws OBDPException {
        Lock lock = this.getLock();
        lock.lock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.cache.asMap().keySet());
            return hashSet;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsCredential(String alias) throws OBDPException {
        Lock lock = this.getLock();
        lock.lock();
        try {
            boolean bl = alias != null && !alias.isEmpty() && this.cache.getIfPresent((Object)alias) != null;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    protected void persistCredentialStore(KeyStore keyStore) throws OBDPException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected KeyStore loadCredentialStore() throws OBDPException {
        throw new UnsupportedOperationException();
    }
}

