/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.encryption;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.security.encryption.AbstractCredentialStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedCredentialStore
extends AbstractCredentialStore {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedCredentialStore.class);
    private File keyStoreFile;

    public FileBasedCredentialStore(File keyStoreLocation) {
        if (keyStoreLocation == null) {
            LOG.warn("Writing key store to the current working directory of the running process");
            keyStoreLocation = new File("credentials.jceks");
        } else if (keyStoreLocation.isDirectory()) {
            keyStoreLocation = new File(keyStoreLocation, "credentials.jceks");
        }
        if (keyStoreLocation.exists()) {
            if (!keyStoreLocation.canWrite()) {
                LOG.warn("The destination file is not writable. Failures may occur when writing the key store to disk: {}", (Object)keyStoreLocation.getAbsolutePath());
            }
        } else {
            File directory = keyStoreLocation.getParentFile();
            if (directory != null && !directory.canWrite()) {
                LOG.warn("The destination directory is not writable. Failures may occur when writing the key store to disk: {}", (Object)keyStoreLocation.getAbsolutePath());
            }
        }
        this.keyStoreFile = keyStoreLocation;
    }

    public File getKeyStorePath() {
        return this.keyStoreFile;
    }

    @Override
    protected void persistCredentialStore(KeyStore keyStore) throws OBDPException {
        this.putKeyStore(keyStore, this.keyStoreFile);
    }

    @Override
    protected KeyStore loadCredentialStore() throws OBDPException {
        return this.getKeyStore(this.keyStoreFile, "JCEKS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore getKeyStore(File keyStoreFile, String keyStoreType) throws OBDPException {
        KeyStore keyStore;
        FileInputStream inputStream;
        if (keyStoreFile.exists()) {
            if (keyStoreFile.length() > 0L) {
                LOG.debug("Reading key store from {}", (Object)keyStoreFile.getAbsolutePath());
                try {
                    inputStream = new FileInputStream(keyStoreFile);
                }
                catch (FileNotFoundException e) {
                    throw new OBDPException(String.format("Failed to open the key store file: %s", e.getLocalizedMessage()), (Throwable)e);
                }
            } else {
                LOG.debug("The key store file found in {} is empty. Returning new (non-persisted) KeyStore", (Object)keyStoreFile.getAbsolutePath());
                inputStream = null;
            }
        } else {
            LOG.debug("Key store file not found in {}. Returning new (non-persisted) KeyStore", (Object)keyStoreFile.getAbsolutePath());
            inputStream = null;
        }
        try {
            keyStore = this.loadKeyStore(inputStream, keyStoreType);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return keyStore;
    }

    private void putKeyStore(KeyStore keyStore, File keyStoreFile) throws OBDPException {
        LOG.debug("Writing key store to {}", (Object)keyStoreFile.getAbsolutePath());
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(this.keyStoreFile);
            this.writeKeyStore(keyStore, outputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new OBDPException(String.format("Failed to open the key store file: %s", e.getLocalizedMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }
}

