/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.encryption;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.security.credential.Credential;
import id.onyx.obdp.server.security.credential.GenericKeyCredential;
import id.onyx.obdp.server.security.encryption.CredentialStore;
import id.onyx.obdp.server.security.encryption.FileBasedCredentialStore;
import id.onyx.obdp.server.security.encryption.MasterKeyServiceImpl;
import id.onyx.obdp.server.utils.Closeables;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialProvider {
    public static final Pattern PASSWORD_ALIAS_PATTERN = Pattern.compile("\\$\\{alias=[\\w\\.]+\\}");
    protected char[] chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7', '8', '9'};
    private CredentialStore keystoreService;
    private static final Logger LOG = LoggerFactory.getLogger(CredentialProvider.class);

    public CredentialProvider(String masterKey, Configuration configuration) throws OBDPException {
        MasterKeyServiceImpl masterKeyService = masterKey != null ? new MasterKeyServiceImpl(masterKey) : new MasterKeyServiceImpl(configuration);
        if (!masterKeyService.isMasterKeyInitialized()) {
            throw new OBDPException("Master key initialization failed.");
        }
        this.keystoreService = new FileBasedCredentialStore(configuration.getMasterKeyStoreLocation());
        this.keystoreService.setMasterKeyService(masterKeyService);
    }

    public char[] getPasswordForAlias(String alias) throws OBDPException {
        Credential credential = CredentialProvider.isAliasString(alias) ? this.keystoreService.getCredential(this.getAliasFromString(alias)) : this.keystoreService.getCredential(alias);
        return credential instanceof GenericKeyCredential ? ((GenericKeyCredential)credential).getKey() : null;
    }

    public void generateAliasWithPassword(String alias) throws OBDPException {
        String passwordString = this.generatePassword(16);
        this.addAliasToCredentialStore(alias, passwordString);
    }

    public void addAliasToCredentialStore(String alias, String passwordString) throws OBDPException {
        if (alias == null || alias.isEmpty()) {
            throw new IllegalArgumentException("Alias cannot be null or empty.");
        }
        if (passwordString == null || passwordString.isEmpty()) {
            throw new IllegalArgumentException("Empty or null password not allowed.");
        }
        this.keystoreService.addCredential(alias, new GenericKeyCredential(passwordString.toCharArray()));
    }

    private String generatePassword(int length) {
        StringBuilder sb = new StringBuilder();
        Random r = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(this.chars[r.nextInt(this.chars.length)]);
        }
        return sb.toString();
    }

    public static boolean isAliasString(String aliasStr) {
        if (aliasStr == null || aliasStr.isEmpty()) {
            return false;
        }
        Matcher matcher = PASSWORD_ALIAS_PATTERN.matcher(aliasStr);
        return matcher.matches();
    }

    private String getAliasFromString(String strPasswd) {
        return strPasswd.substring(strPasswd.indexOf("=") + 1, strPasswd.length() - 1);
    }

    protected CredentialStore getKeystoreService() {
        return this.keystoreService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block18: {
            block19: {
                block21: {
                    CredentialProvider credentialProvider;
                    String alias;
                    String action;
                    block20: {
                        if (args == null || args.length <= 0) break block19;
                        action = args[0];
                        alias = null;
                        String masterKey = null;
                        credentialProvider = null;
                        Configuration configuration = new Configuration();
                        if (args.length > 1 && !args[1].isEmpty()) {
                            alias = args[1];
                        } else {
                            LOG.error("No valid arguments provided.");
                            System.exit(1);
                        }
                        if (args.length > 3 && !args[3].isEmpty() && !args[3].equalsIgnoreCase("None")) {
                            masterKey = args[3];
                            LOG.debug("Master key provided as an argument.");
                        }
                        try {
                            credentialProvider = new CredentialProvider(masterKey, configuration);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            System.exit(1);
                        }
                        LOG.info("action => " + action + ", alias => " + alias);
                        if (!action.equalsIgnoreCase("PUT")) break block20;
                        String password = null;
                        if (args.length > 2 && !args[2].isEmpty()) {
                            password = args[2];
                        }
                        if (password != null && !password.isEmpty()) {
                            try {
                                credentialProvider.addAliasToCredentialStore(alias, password);
                            }
                            catch (OBDPException e) {
                                e.printStackTrace();
                            }
                        } else {
                            LOG.error("Alias and password are required arguments.");
                            System.exit(1);
                        }
                        break block18;
                    }
                    if (!action.equalsIgnoreCase("GET")) break block18;
                    String writeFilePath = null;
                    if (args.length > 2 && !args[2].isEmpty()) {
                        writeFilePath = args[2];
                    }
                    if (writeFilePath == null || writeFilePath.isEmpty()) break block21;
                    String passwd = "";
                    try {
                        char[] retPasswd = credentialProvider.getPasswordForAlias(alias);
                        if (retPasswd != null) {
                            passwd = new String(retPasswd);
                        }
                    }
                    catch (OBDPException e) {
                        LOG.error("Error retrieving password for alias.");
                        e.printStackTrace();
                    }
                    FileOutputStream fo = null;
                    try {
                        fo = new FileOutputStream(writeFilePath);
                        fo.write(passwd.getBytes());
                    }
                    catch (IOException e) {
                        try {
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            Closeables.closeSilently(fo);
                            throw throwable;
                        }
                        Closeables.closeSilently(fo);
                        break block18;
                    }
                    Closeables.closeSilently(fo);
                    break block18;
                }
                LOG.error("Alias and file path are required arguments.");
                break block18;
            }
            LOG.error("No arguments provided to CredentialProvider");
            System.exit(1);
        }
        System.exit(0);
    }
}

