/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.encryption;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.security.encryption.EncryptionService;
import id.onyx.obdp.server.security.encryption.Encryptor;
import id.onyx.obdp.server.security.encryption.PropertiesEncryptor;
import id.onyx.obdp.server.state.Config;
import java.util.Map;

@Singleton
public class ConfigPropertiesEncryptor
extends PropertiesEncryptor
implements Encryptor<Config> {
    @Inject
    public ConfigPropertiesEncryptor(EncryptionService encryptionService) {
        super(encryptionService);
    }

    @Override
    public void encryptSensitiveData(Config config) {
        Map<String, String> properties = config.getProperties();
        this.encrypt(properties, config.getCluster(), config.getType());
        config.setProperties(properties);
    }

    @Override
    public void decryptSensitiveData(Config config) {
        Map<String, String> properties = config.getProperties();
        this.decrypt(properties);
        config.setProperties(properties);
    }

    @Override
    public String getEncryptionKey() {
        return this.encryptionService.getAmbariMasterKey();
    }
}

