/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.encryption;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.OBDPRuntimeException;
import id.onyx.obdp.server.agent.AgentEncryptionKey;
import id.onyx.obdp.server.agent.stomp.dto.ClusterConfigs;
import id.onyx.obdp.server.events.AgentConfigsUpdateEvent;
import id.onyx.obdp.server.security.encryption.CredentialStoreService;
import id.onyx.obdp.server.security.encryption.EncryptionService;
import id.onyx.obdp.server.security.encryption.Encryptor;
import id.onyx.obdp.server.security.encryption.PropertiesEncryptor;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import java.util.Map;
import java.util.SortedMap;

@Singleton
public class AgentConfigUpdateEncryptor
extends PropertiesEncryptor
implements Encryptor<AgentConfigsUpdateEvent> {
    private final AgentEncryptionKey encryptionKey;
    private final Provider<Clusters> clusters;

    @Inject
    public AgentConfigUpdateEncryptor(EncryptionService encryptionService, CredentialStoreService credentialStore, Provider<Clusters> clusters) {
        super(encryptionService);
        this.encryptionKey = AgentEncryptionKey.loadFrom(credentialStore, true);
        this.clusters = clusters;
    }

    @Override
    public void encryptSensitiveData(AgentConfigsUpdateEvent event) {
        for (Map.Entry<String, ClusterConfigs> each : event.getClustersConfigs().entrySet()) {
            Cluster cluster = this.getCluster(Long.parseLong(each.getKey()));
            ClusterConfigs clusterConfigs = each.getValue();
            for (Map.Entry<String, SortedMap<String, String>> clusterConfig : clusterConfigs.getConfigurations().entrySet()) {
                this.encrypt((Map<String, String>)clusterConfig.getValue(), cluster, clusterConfig.getKey(), this.encryptionKey.toString());
            }
        }
    }

    @Override
    public void decryptSensitiveData(AgentConfigsUpdateEvent event) {
        throw new UnsupportedOperationException("Not supported");
    }

    private Cluster getCluster(long clusterId) throws OBDPRuntimeException {
        try {
            return ((Clusters)this.clusters.get()).getCluster(clusterId);
        }
        catch (OBDPException e) {
            throw new OBDPRuntimeException("Cannot load cluster: " + clusterId, e);
        }
    }

    @Override
    public String getEncryptionKey() {
        return this.encryptionKey.toString();
    }
}

