/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.encryption;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.security.credential.Credential;
import id.onyx.obdp.server.security.credential.CredentialFactory;
import id.onyx.obdp.server.security.encryption.CredentialStore;
import id.onyx.obdp.server.security.encryption.MasterKeyService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractCredentialStore
implements CredentialStore {
    protected static final String DEFAULT_STORE_TYPE = "JCEKS";
    private final Lock lock = new ReentrantLock();
    private MasterKeyService masterKeyService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCredential(String alias, Credential credential) throws OBDPException {
        if (alias == null || alias.isEmpty()) {
            throw new IllegalArgumentException("Alias cannot be null or empty.");
        }
        this.lock.lock();
        try {
            KeyStore ks = this.loadCredentialStore();
            this.addCredential(ks, alias, credential);
            this.persistCredentialStore(ks);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Credential getCredential(String alias) throws OBDPException {
        if (alias == null) {
            return null;
        }
        this.lock.lock();
        try {
            Credential credential = this.getCredential(this.loadCredentialStore(), alias);
            return credential;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCredential(String alias) throws OBDPException {
        block6: {
            if (alias != null && !alias.isEmpty()) {
                this.lock.lock();
                try {
                    KeyStore ks = this.loadCredentialStore();
                    if (ks == null) break block6;
                    try {
                        ks.deleteEntry(alias);
                        this.persistCredentialStore(ks);
                    }
                    catch (KeyStoreException e) {
                        throw new OBDPException("Failed to delete the KeyStore entry - the key store may not have been initialized", (Throwable)e);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listCredentials() throws OBDPException {
        HashSet<String> credentials;
        block7: {
            credentials = null;
            this.lock.lock();
            try {
                KeyStore ks = this.loadCredentialStore();
                if (ks == null) break block7;
                try {
                    Enumeration<String> aliases = ks.aliases();
                    if (aliases != null) {
                        credentials = new HashSet<String>();
                        while (aliases.hasMoreElements()) {
                            credentials.add(aliases.nextElement());
                        }
                    }
                }
                catch (KeyStoreException e) {
                    throw new OBDPException("Failed to read KeyStore - the key store may not have been initialized", (Throwable)e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsCredential(String alias) throws OBDPException {
        boolean exists;
        block6: {
            exists = false;
            if (alias != null && !alias.isEmpty()) {
                this.lock.lock();
                try {
                    KeyStore ks = this.loadCredentialStore();
                    if (ks == null) break block6;
                    try {
                        exists = ks.containsAlias(alias);
                    }
                    catch (KeyStoreException e) {
                        throw new OBDPException("Failed to search the KeyStore for the requested entry - the key store may not have been initialized", (Throwable)e);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        return exists;
    }

    @Override
    public void setMasterKeyService(MasterKeyService masterKeyService) {
        this.masterKeyService = masterKeyService;
    }

    protected void addCredential(KeyStore keyStore, String alias, Credential credential) throws OBDPException {
        if (keyStore != null) {
            try {
                char[] value = credential == null ? null : credential.toValue();
                SecretKeySpec key = value == null || value.length == 0 ? null : new SecretKeySpec(this.toBytes(value), "AES");
                keyStore.setKeyEntry(alias, key, this.masterKeyService.getMasterSecret(), null);
            }
            catch (KeyStoreException e) {
                throw new OBDPException("The key store has not been initialized", (Throwable)e);
            }
        }
    }

    protected Credential getCredential(KeyStore keyStore, String alias) throws OBDPException {
        char[] value = null;
        if (keyStore != null) {
            try {
                Key key = keyStore.getKey(alias, this.masterKeyService.getMasterSecret());
                if (key != null) {
                    value = this.toChars(key.getEncoded());
                }
            }
            catch (UnrecoverableKeyException e) {
                throw new OBDPException("The key cannot be recovered (e.g., the given password is wrong)", (Throwable)e);
            }
            catch (KeyStoreException e) {
                throw new OBDPException("The key store has not been initialized", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new OBDPException(" if the algorithm for recovering the key cannot be found", (Throwable)e);
            }
        }
        return CredentialFactory.createCredential(value);
    }

    protected abstract void persistCredentialStore(KeyStore var1) throws OBDPException;

    protected abstract KeyStore loadCredentialStore() throws OBDPException;

    protected Lock getLock() {
        return this.lock;
    }

    protected KeyStore loadKeyStore(InputStream inputStream, String keyStoreType) throws OBDPException {
        KeyStore keyStore;
        if (this.masterKeyService == null) {
            throw new OBDPException("Master Key Service is not set for this Credential store.");
        }
        try {
            keyStore = KeyStore.getInstance(keyStoreType);
        }
        catch (KeyStoreException e) {
            throw new OBDPException(String.format("No provider supports a key store implementation for the specified type: %s", keyStoreType), (Throwable)e);
        }
        try {
            keyStore.load(inputStream, this.masterKeyService.getMasterSecret());
        }
        catch (CertificateException e) {
            throw new OBDPException(String.format("One or more credentials from the key store could not be loaded: %s", e.getLocalizedMessage()), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OBDPException(String.format("The algorithm used to check the integrity of the key store cannot be found: %s", e.getLocalizedMessage()), (Throwable)e);
        }
        catch (IOException e) {
            if (e.getCause() instanceof UnrecoverableKeyException) {
                throw new OBDPException(String.format("The password used to decrypt the key store is incorrect: %s", e.getLocalizedMessage()), (Throwable)e);
            }
            throw new OBDPException(String.format("Failed to read the key store: %s", e.getLocalizedMessage()), (Throwable)e);
        }
        return keyStore;
    }

    protected void writeKeyStore(KeyStore keyStore, OutputStream outputStream) throws OBDPException {
        if (this.masterKeyService == null) {
            throw new OBDPException("Master Key Service is not set for this Credential store.");
        }
        try {
            keyStore.store(outputStream, this.masterKeyService.getMasterSecret());
        }
        catch (CertificateException e) {
            throw new OBDPException(String.format("A credential within in the key store data could not be stored: %s", e.getLocalizedMessage()), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OBDPException(String.format("The appropriate data integrity algorithm could not be found: %s", e.getLocalizedMessage()), (Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new OBDPException(String.format("The key store has not been initialized: %s", e.getLocalizedMessage()), (Throwable)e);
        }
        catch (IOException e) {
            throw new OBDPException(String.format("Failed to write the key store: %s", e.getLocalizedMessage()), (Throwable)e);
        }
    }

    protected byte[] toBytes(char[] chars) {
        if (chars == null) {
            return null;
        }
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = Charset.forName("UTF-8").encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(charBuffer.array(), '\u0000');
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }

    protected char[] toChars(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        CharBuffer charBuffer = Charset.forName("UTF-8").decode(byteBuffer);
        char[] chars = Arrays.copyOfRange(charBuffer.array(), charBuffer.position(), charBuffer.limit());
        Arrays.fill(charBuffer.array(), '\u0000');
        Arrays.fill(byteBuffer.array(), (byte)0);
        return chars;
    }
}

