/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.encryption;

import id.onyx.obdp.server.security.encryption.EncryptionResult;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AESEncryptor {
    private static final int ITERATION_COUNT = 65536;
    private static final int KEY_LENGTH = 128;
    private Cipher ecipher;
    private Cipher dcipher;
    private SecretKey secret;
    private byte[] salt = null;
    private char[] passPhrase = null;

    public AESEncryptor(String passPhrase) {
        try {
            this.passPhrase = passPhrase.toCharArray();
            this.salt = new byte[8];
            SecureRandom rnd = new SecureRandom();
            rnd.nextBytes(this.salt);
            SecretKey tmp = this.getKeyFromPassword(passPhrase);
            this.secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            this.ecipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.ecipher.init(1, this.secret);
            this.dcipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            byte[] iv = this.ecipher.getParameters().getParameterSpec(IvParameterSpec.class).getIV();
            this.dcipher.init(2, (Key)this.secret, new IvParameterSpec(iv));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidParameterSpecException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
    }

    public SecretKey getKeyFromPassword(String passPhrase) {
        return this.getKeyFromPassword(passPhrase, this.salt);
    }

    public SecretKey getKeyFromPassword(String passPhrase, byte[] salt) {
        SecretKey key = null;
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(passPhrase.toCharArray(), salt, 65536, 128);
            key = factory.generateSecret(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return key;
    }

    public EncryptionResult encrypt(String encrypt) {
        try {
            byte[] bytes = encrypt.getBytes("UTF8");
            EncryptionResult atom = this.encrypt(bytes);
            return atom;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public EncryptionResult encrypt(byte[] plain) {
        try {
            return new EncryptionResult(this.salt, this.ecipher.getParameters().getParameterSpec(IvParameterSpec.class).getIV(), this.ecipher.doFinal(plain));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] decrypt(byte[] salt, byte[] iv, byte[] encrypt) {
        try {
            SecretKey tmp = this.getKeyFromPassword(new String(this.passPhrase), salt);
            this.secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            this.dcipher.init(2, (Key)this.secret, new IvParameterSpec(iv));
            return this.dcipher.doFinal(encrypt);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

