/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.encryption;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.security.encryption.AESEncryptor;
import id.onyx.obdp.server.security.encryption.EncryptionResult;
import id.onyx.obdp.server.security.encryption.EncryptionService;
import id.onyx.obdp.server.security.encryption.MasterKeyService;
import id.onyx.obdp.server.security.encryption.MasterKeyServiceImpl;
import id.onyx.obdp.server.utils.TextEncoding;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

@Singleton
public class AESEncryptionService
implements EncryptionService {
    private static final String ENCODED_TEXT_FIELD_DELIMITER = "::";
    private static final String UTF_8_CHARSET = StandardCharsets.UTF_8.name();
    private final Cache<String, AESEncryptor> aesEncryptorCache = CacheBuilder.newBuilder().build();
    private MasterKeyService environmentMasterKeyService;
    @Inject
    private Configuration configuration;

    @Override
    public String encrypt(String toBeEncrypted) {
        return this.encrypt(toBeEncrypted, TextEncoding.BASE_64);
    }

    @Override
    public String encrypt(String toBeEncrypted, TextEncoding textEncoding) {
        return this.encrypt(toBeEncrypted, this.getAmbariMasterKey(), textEncoding);
    }

    @Override
    public String encrypt(String toBeEncrypted, String key) {
        return this.encrypt(toBeEncrypted, key, TextEncoding.BASE_64);
    }

    @Override
    public String encrypt(String toBeEncrypted, String key, TextEncoding textEncoding) {
        try {
            EncryptionResult encryptionResult = this.getAesEncryptor(key).encrypt(toBeEncrypted);
            return TextEncoding.BASE_64 == textEncoding ? this.encodeEncryptionResultBase64(encryptionResult) : this.encodeEncryptionResultBinHex(encryptionResult);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private AESEncryptor getAesEncryptor(String key) {
        AESEncryptor aesEncryptor = (AESEncryptor)this.aesEncryptorCache.getIfPresent((Object)key);
        if (aesEncryptor == null) {
            aesEncryptor = new AESEncryptor(key);
            this.aesEncryptorCache.put((Object)key, (Object)aesEncryptor);
        }
        return aesEncryptor;
    }

    @Override
    public final String getAmbariMasterKey() {
        this.initEnvironmentMasterKeyService();
        return String.valueOf(this.environmentMasterKeyService.getMasterSecret());
    }

    private void initEnvironmentMasterKeyService() {
        if (this.environmentMasterKeyService == null) {
            this.environmentMasterKeyService = new MasterKeyServiceImpl(this.configuration);
            if (!this.environmentMasterKeyService.isMasterKeyInitialized()) {
                throw new SecurityException("You are trying to use a persisted master key but its initialization has been failed!");
            }
        }
    }

    private String encodeEncryptionResultBase64(EncryptionResult encryptionResult) throws UnsupportedEncodingException {
        return Base64.encodeBase64String((byte[])(Base64.encodeBase64String((byte[])encryptionResult.salt) + ENCODED_TEXT_FIELD_DELIMITER + Base64.encodeBase64String((byte[])encryptionResult.iv) + ENCODED_TEXT_FIELD_DELIMITER + Base64.encodeBase64String((byte[])encryptionResult.cipher)).getBytes(UTF_8_CHARSET));
    }

    private String encodeEncryptionResultBinHex(EncryptionResult encryptionResult) throws UnsupportedEncodingException {
        return Hex.encodeHexString((byte[])(Hex.encodeHexString((byte[])encryptionResult.salt) + ENCODED_TEXT_FIELD_DELIMITER + Hex.encodeHexString((byte[])encryptionResult.iv) + ENCODED_TEXT_FIELD_DELIMITER + Hex.encodeHexString((byte[])encryptionResult.cipher)).getBytes(UTF_8_CHARSET));
    }

    @Override
    public String decrypt(String toBeDecrypted) {
        return this.decrypt(toBeDecrypted, TextEncoding.BASE_64);
    }

    @Override
    public String decrypt(String toBeDecrypted, TextEncoding textEncoding) {
        return this.decrypt(toBeDecrypted, this.getAmbariMasterKey(), textEncoding);
    }

    @Override
    public String decrypt(String toBeDecrypted, String key) {
        return this.decrypt(toBeDecrypted, key, TextEncoding.BASE_64);
    }

    @Override
    public String decrypt(String toBeDecrypted, String key, TextEncoding textEncoding) {
        try {
            byte[] decodedValue = TextEncoding.BASE_64 == textEncoding ? Base64.decodeBase64((String)toBeDecrypted) : Hex.decodeHex((char[])toBeDecrypted.toCharArray());
            String decodedText = new String(decodedValue, UTF_8_CHARSET);
            String[] decodedParts = decodedText.split(ENCODED_TEXT_FIELD_DELIMITER);
            AESEncryptor aes = this.getAesEncryptor(key);
            if (TextEncoding.BASE_64 == textEncoding) {
                return new String(aes.decrypt(Base64.decodeBase64((String)decodedParts[0]), Base64.decodeBase64((String)decodedParts[1]), Base64.decodeBase64((String)decodedParts[2])), UTF_8_CHARSET);
            }
            return new String(aes.decrypt(Hex.decodeHex((char[])decodedParts[0].toCharArray()), Hex.decodeHex((char[])decodedParts[1].toCharArray()), Hex.decodeHex((char[])decodedParts[2].toCharArray())), UTF_8_CHARSET);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }
}

