/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.credential;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import id.onyx.obdp.server.security.credential.Credential;
import id.onyx.obdp.server.security.credential.InvalidCredentialValueException;
import java.util.Arrays;

public class PrincipalKeyCredential
implements Credential {
    private static final String VALUE_PREFIX = "PrincipalKeyCredential";
    private String principal;
    private char[] key;

    public PrincipalKeyCredential() {
        this(null, (char[])null);
    }

    public PrincipalKeyCredential(String principal, String key) {
        this(principal, key == null ? null : key.toCharArray());
    }

    public PrincipalKeyCredential(String principal, char[] key) {
        this.principal = principal;
        this.key = key;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public char[] getKey() {
        return this.key;
    }

    public void setKey(char[] key) {
        this.key = key;
    }

    @Override
    public char[] toValue() {
        StringBuilder builder = new StringBuilder();
        builder.append(VALUE_PREFIX);
        builder.append(new Gson().toJson((Object)this));
        return builder.toString().toCharArray();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj.getClass() == this.getClass()) {
            PrincipalKeyCredential other = (PrincipalKeyCredential)obj;
            return (this.principal == null ? other.principal == null : this.principal.equals(other.principal)) && (this.key == null ? other.key == null : Arrays.equals(this.key, other.key));
        }
        return false;
    }

    public int hashCode() {
        return (this.principal == null ? 0 : this.principal.hashCode()) + (this.key == null ? 0 : Arrays.hashCode(this.key));
    }

    public static PrincipalKeyCredential fromValue(String value) throws InvalidCredentialValueException {
        if (PrincipalKeyCredential.isValidValue(value)) {
            value = value.substring(VALUE_PREFIX.length());
            try {
                return value.isEmpty() ? null : (PrincipalKeyCredential)new Gson().fromJson(value, PrincipalKeyCredential.class);
            }
            catch (JsonSyntaxException e) {
                throw new InvalidCredentialValueException("The value does not represent a PrincipalKeyCredential", e);
            }
        }
        throw new InvalidCredentialValueException("The value does not represent a PrincipalKeyCredential");
    }

    public static boolean isValidValue(String value) {
        return value != null && value.startsWith(VALUE_PREFIX);
    }
}

