/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authorization.internal;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.math.BigInteger;
import java.security.SecureRandom;

@Singleton
public class InternalTokenStorage {
    private final SecureRandom random;
    private final String token;

    @Inject
    public InternalTokenStorage(SecureRandom secureRandom) {
        this.random = secureRandom;
        this.token = this.createNewToken();
    }

    public String getInternalToken() {
        return this.token;
    }

    public boolean isValidInternalToken(String token) {
        return this.token.equals(token);
    }

    public String createNewToken() {
        return new BigInteger(130, this.random).toString(32);
    }
}

