/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authorization.internal;

import id.onyx.obdp.server.orm.entities.PermissionEntity;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.ResourceEntity;
import id.onyx.obdp.server.orm.entities.ResourceTypeEntity;
import id.onyx.obdp.server.security.authorization.OBDPGrantedAuthority;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

public class InternalAuthenticationToken
implements Authentication {
    private static final long serialVersionUID = 1L;
    private static final String INTERNAL_NAME = "internal";
    private static final PrivilegeEntity ADMIN_PRIV_ENTITY = new PrivilegeEntity();
    private static final Collection<? extends GrantedAuthority> AUTHORITIES;
    private static final User INTERNAL_USER;
    private String token;
    private boolean authenticated = false;

    private static void createAdminPrivilegeEntity(PrivilegeEntity entity) {
        PermissionEntity pe = new PermissionEntity();
        pe.setId(1);
        pe.setPermissionName("OBDP.ADMINISTRATOR");
        pe.addAuthorizations(EnumSet.allOf(RoleAuthorization.class));
        entity.setPermission(pe);
        ResourceEntity resource = new ResourceEntity();
        resource.setId(1L);
        ResourceTypeEntity rte = new ResourceTypeEntity();
        rte.setId(ResourceType.OBDP.getId());
        rte.setName(ResourceType.OBDP.name());
        resource.setResourceType(rte);
        entity.setResource(resource);
    }

    public InternalAuthenticationToken(String tokenString) {
        this.token = tokenString;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return AUTHORITIES;
    }

    public String getCredentials() {
        return this.token;
    }

    public Object getDetails() {
        return null;
    }

    public Object getPrincipal() {
        return INTERNAL_USER;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        this.authenticated = isAuthenticated;
    }

    public String getName() {
        return INTERNAL_NAME;
    }

    static {
        InternalAuthenticationToken.createAdminPrivilegeEntity(ADMIN_PRIV_ENTITY);
        AUTHORITIES = Collections.singleton(new OBDPGrantedAuthority(ADMIN_PRIV_ENTITY));
        INTERNAL_USER = new User(INTERNAL_NAME, "empty", AUTHORITIES);
    }
}

