/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authorization.internal;

import id.onyx.obdp.server.security.authorization.internal.InternalAuthenticationToken;
import id.onyx.obdp.server.security.authorization.internal.RunWithInternalSecurityContext;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class InternalAuthenticationInterceptor
implements MethodInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Authentication savedAuthContext = SecurityContextHolder.getContext().getAuthentication();
        try {
            RunWithInternalSecurityContext securityAuthContextAnnotation = invocation.getMethod().getAnnotation(RunWithInternalSecurityContext.class);
            InternalAuthenticationToken authenticationToken = new InternalAuthenticationToken(securityAuthContextAnnotation.token());
            authenticationToken.setAuthenticated(true);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
            Object object = invocation.proceed();
            return object;
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(savedAuthContext);
        }
    }
}

