/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authorization.internal;

import com.google.inject.Inject;
import id.onyx.obdp.server.security.authentication.InvalidUsernamePasswordCombinationException;
import id.onyx.obdp.server.security.authorization.internal.InternalAuthenticationToken;
import id.onyx.obdp.server.security.authorization.internal.InternalTokenStorage;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class AmbariInternalAuthenticationProvider
implements AuthenticationProvider {
    private final InternalTokenStorage internalTokenStorage;

    @Inject
    public AmbariInternalAuthenticationProvider(InternalTokenStorage internalTokenStorage) {
        this.internalTokenStorage = internalTokenStorage;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        InternalAuthenticationToken token = (InternalAuthenticationToken)authentication;
        if (!this.internalTokenStorage.isValidInternalToken(token.getCredentials())) {
            throw new InvalidUsernamePasswordCombinationException(null);
        }
        token.setAuthenticated(true);
        return token;
    }

    public boolean supports(Class<?> authentication) {
        return InternalAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

