/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authorization;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.hooks.HookContextFactory;
import id.onyx.obdp.server.hooks.HookService;
import id.onyx.obdp.server.ldap.domain.OBDPLdapConfiguration;
import id.onyx.obdp.server.ldap.service.OBDPLdapConfigurationProvider;
import id.onyx.obdp.server.orm.dao.GroupDAO;
import id.onyx.obdp.server.orm.dao.MemberDAO;
import id.onyx.obdp.server.orm.dao.PermissionDAO;
import id.onyx.obdp.server.orm.dao.PrincipalDAO;
import id.onyx.obdp.server.orm.dao.PrincipalTypeDAO;
import id.onyx.obdp.server.orm.dao.PrivilegeDAO;
import id.onyx.obdp.server.orm.dao.ResourceDAO;
import id.onyx.obdp.server.orm.dao.UserAuthenticationDAO;
import id.onyx.obdp.server.orm.dao.UserDAO;
import id.onyx.obdp.server.orm.entities.GroupEntity;
import id.onyx.obdp.server.orm.entities.MemberEntity;
import id.onyx.obdp.server.orm.entities.PermissionEntity;
import id.onyx.obdp.server.orm.entities.PrincipalEntity;
import id.onyx.obdp.server.orm.entities.PrincipalTypeEntity;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.ResourceTypeEntity;
import id.onyx.obdp.server.orm.entities.UserAuthenticationEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.security.authentication.AccountDisabledException;
import id.onyx.obdp.server.security.authentication.TooManyLoginFailuresException;
import id.onyx.obdp.server.security.authentication.UserNotFoundException;
import id.onyx.obdp.server.security.authorization.AuthenticationMethod;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.Group;
import id.onyx.obdp.server.security.authorization.GroupType;
import id.onyx.obdp.server.security.authorization.OBDPGrantedAuthority;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.User;
import id.onyx.obdp.server.security.authorization.UserAuthenticationType;
import id.onyx.obdp.server.security.authorization.UserName;
import id.onyx.obdp.server.security.ldap.LdapBatchDto;
import id.onyx.obdp.server.security.ldap.LdapGroupDto;
import id.onyx.obdp.server.security.ldap.LdapUserDto;
import id.onyx.obdp.server.security.ldap.LdapUserGroupMemberDto;
import jakarta.persistence.EntityManager;
import jakarta.persistence.OptimisticLockException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;

@Singleton
public class Users {
    private static final Logger LOG = LoggerFactory.getLogger(Users.class);
    private static final int MAX_RETRIES = 10;
    @Inject
    private Provider<EntityManager> entityManagerProvider;
    @Inject
    private UserDAO userDAO;
    @Inject
    private UserAuthenticationDAO userAuthenticationDAO;
    @Inject
    private GroupDAO groupDAO;
    @Inject
    private MemberDAO memberDAO;
    @Inject
    private PrincipalDAO principalDAO;
    @Inject
    private PermissionDAO permissionDAO;
    @Inject
    private PrivilegeDAO privilegeDAO;
    @Inject
    private ResourceDAO resourceDAO;
    @Inject
    private PrincipalTypeDAO principalTypeDAO;
    @Inject
    private PasswordEncoder passwordEncoder;
    @Inject
    protected OBDPLdapConfigurationProvider ldapConfigurationProvider;
    @Inject
    protected Configuration configuration;
    @Inject
    private Provider<HookService> hookServiceProvider;
    @Inject
    private HookContextFactory hookContextFactory;

    public List<User> getAllUsers() {
        List<UserEntity> userEntities = this.userDAO.findAll();
        ArrayList<User> users = new ArrayList<User>(userEntities.size());
        for (UserEntity userEntity : userEntities) {
            users.add(new User(userEntity));
        }
        return users;
    }

    public List<UserEntity> getAllUserEntities() {
        return this.userDAO.findAll();
    }

    public UserEntity getUserEntity(String userName) {
        return userName == null ? null : this.userDAO.findUserByName(userName);
    }

    public UserEntity getUserEntity(Integer userId) {
        return userId == null ? null : this.userDAO.findByPK(userId);
    }

    public User getUser(UserEntity userEntity) {
        return null == userEntity ? null : new User(userEntity);
    }

    public User getUser(Integer userId) {
        return this.getUser(this.getUserEntity(userId));
    }

    public User getUser(String userName) {
        return this.getUser(this.getUserEntity(userName));
    }

    public synchronized void setUserActive(String userName, boolean active) throws OBDPException {
        UserEntity userEntity = this.userDAO.findUserByName(userName);
        if (userEntity == null) {
            throw new OBDPException("User " + userName + " doesn't exist");
        }
        this.setUserActive(userEntity, active);
    }

    public synchronized void setUserActive(UserEntity userEntity, final boolean active) throws OBDPException {
        if (userEntity != null) {
            Command command = new Command(){

                @Override
                public void perform(UserEntity userEntity) {
                    userEntity.setActive(active);
                }
            };
            this.safelyUpdateUserEntity(userEntity, command, 10);
        }
    }

    public void validateLogin(UserEntity userEntity, String userName) {
        if (userEntity == null) {
            LOG.info("User not found");
            throw new UserNotFoundException(userName);
        }
        if (!userEntity.getActive().booleanValue()) {
            LOG.info("User account is disabled: {}", (Object)userName);
            throw new AccountDisabledException(userName);
        }
        int maxConsecutiveFailures = this.configuration.getMaxAuthenticationFailures();
        if (maxConsecutiveFailures > 0 && userEntity.getConsecutiveFailures() >= maxConsecutiveFailures) {
            LOG.info("User account is locked out due to too many authentication failures ({}/{}): {}", new Object[]{userEntity.getConsecutiveFailures(), maxConsecutiveFailures, userName});
            throw new TooManyLoginFailuresException(userName);
        }
    }

    public synchronized void setGroupLdap(String groupName) throws OBDPException {
        GroupEntity groupEntity = this.groupDAO.findGroupByName(groupName);
        if (groupEntity == null) {
            throw new OBDPException("Group " + groupName + " doesn't exist");
        }
        groupEntity.setGroupType(GroupType.LDAP);
        this.groupDAO.merge(groupEntity);
    }

    public UserEntity createUser(String userName, String localUserName, String displayName) throws OBDPException {
        return this.createUser(userName, localUserName, displayName, true);
    }

    @Transactional
    public synchronized UserEntity createUser(String userName, String localUserName, String displayName, Boolean active) throws OBDPException {
        String validatedLocalUserName;
        String validatedUserName = UserName.fromString(userName).toString();
        String validatedDisplayName = StringUtils.isEmpty((String)displayName) ? validatedUserName : UserName.fromString(displayName).toString();
        String string = validatedLocalUserName = StringUtils.isEmpty((String)localUserName) ? validatedUserName : UserName.fromString(localUserName).toString();
        if (this.userDAO.findUserByName(validatedUserName) != null) {
            throw new OBDPException("User already exists");
        }
        PrincipalTypeEntity principalTypeEntity = this.principalTypeDAO.findById(1);
        if (principalTypeEntity == null) {
            principalTypeEntity = new PrincipalTypeEntity();
            principalTypeEntity.setId(1);
            principalTypeEntity.setName(PrincipalTypeEntity.USER_PRINCIPAL_TYPE_NAME);
            this.principalTypeDAO.create(principalTypeEntity);
        }
        PrincipalEntity principalEntity = new PrincipalEntity();
        principalEntity.setPrincipalType(principalTypeEntity);
        this.principalDAO.create(principalEntity);
        UserEntity userEntity = new UserEntity();
        userEntity.setUserName(validatedUserName);
        userEntity.setDisplayName(validatedDisplayName);
        userEntity.setLocalUsername(validatedLocalUserName);
        userEntity.setPrincipal(principalEntity);
        if (active != null) {
            userEntity.setActive(active);
        }
        this.userDAO.create(userEntity);
        this.executeUserHook(validatedUserName);
        return userEntity;
    }

    public void executeUserHook(String username) {
        ((HookService)this.hookServiceProvider.get()).execute(this.hookContextFactory.createUserHookContext(username));
    }

    public void executeUserHook(Map<String, Set<String>> userGroupsMap) {
        ((HookService)this.hookServiceProvider.get()).execute(this.hookContextFactory.createBatchUserHookContext(userGroupsMap));
    }

    @Transactional
    public synchronized void removeUser(User user) throws OBDPException {
        UserEntity userEntity = this.userDAO.findByPK(user.getUserId());
        if (userEntity == null) {
            throw new OBDPException("User " + user + " doesn't exist");
        }
        this.removeUser(userEntity);
    }

    @Transactional
    public synchronized void removeUser(UserEntity userEntity) throws OBDPException {
        if (userEntity != null) {
            if (!this.isUserCanBeRemoved(userEntity)) {
                throw new OBDPException("Could not remove user " + userEntity.getUserName() + ". System should have at least one administrator.");
            }
            this.userDAO.remove(userEntity);
        }
    }

    public Group getGroup(String groupName) {
        GroupEntity groupEntity = this.groupDAO.findGroupByName(groupName);
        return null == groupEntity ? null : new Group(groupEntity);
    }

    public Group getGroup(String groupName, GroupType groupType) {
        GroupEntity groupEntity = this.getGroupEntity(groupName, groupType);
        return null == groupEntity ? null : new Group(groupEntity);
    }

    public GroupEntity getGroupEntity(String groupName, GroupType groupType) {
        return this.groupDAO.findGroupByNameAndType(groupName, groupType);
    }

    public Collection<User> getGroupMembers(String groupName) {
        GroupEntity groupEntity = this.groupDAO.findGroupByName(groupName);
        if (groupEntity == null) {
            return null;
        }
        HashSet<User> users = new HashSet<User>();
        for (MemberEntity memberEntity : groupEntity.getMemberEntities()) {
            if (memberEntity.getUser() != null) {
                users.add(new User(memberEntity.getUser()));
                continue;
            }
            LOG.error("Wrong state, not found user for member '{}' (group: '{}')", (Object)memberEntity.getMemberId(), (Object)memberEntity.getGroup().getGroupName());
        }
        return users;
    }

    @Transactional
    public synchronized GroupEntity createGroup(String groupName, GroupType groupType) {
        PrincipalTypeEntity principalTypeEntity = this.principalTypeDAO.findById(2);
        if (principalTypeEntity == null) {
            principalTypeEntity = new PrincipalTypeEntity();
            principalTypeEntity.setId(2);
            principalTypeEntity.setName(PrincipalTypeEntity.GROUP_PRINCIPAL_TYPE_NAME);
            this.principalTypeDAO.create(principalTypeEntity);
        }
        PrincipalEntity principalEntity = new PrincipalEntity();
        principalEntity.setPrincipalType(principalTypeEntity);
        this.principalDAO.create(principalEntity);
        GroupEntity groupEntity = new GroupEntity();
        groupEntity.setGroupName(groupName);
        groupEntity.setPrincipal(principalEntity);
        groupEntity.setGroupType(groupType);
        this.groupDAO.create(groupEntity);
        return groupEntity;
    }

    public List<Group> getAllGroups() {
        List<GroupEntity> groupEntities = this.groupDAO.findAll();
        ArrayList<Group> groups = new ArrayList<Group>(groupEntities.size());
        for (GroupEntity groupEntity : groupEntities) {
            groups.add(new Group(groupEntity));
        }
        return groups;
    }

    public List<String> getAllMembers(String groupName) throws OBDPException {
        ArrayList<String> members = new ArrayList<String>();
        GroupEntity groupEntity = this.groupDAO.findGroupByName(groupName);
        if (groupEntity == null) {
            throw new OBDPException("Group " + groupName + " doesn't exist");
        }
        for (MemberEntity member : groupEntity.getMemberEntities()) {
            members.add(member.getUser().getUserName());
        }
        return members;
    }

    @Transactional
    public synchronized void removeGroup(Group group) throws OBDPException {
        GroupEntity groupEntity = this.groupDAO.findByPK(group.getGroupId());
        if (groupEntity == null) {
            throw new OBDPException("Group " + group + " doesn't exist");
        }
        this.groupDAO.remove(groupEntity);
    }

    public synchronized boolean hasAdminPrivilege(UserEntity userEntity) {
        Set<PrivilegeEntity> roles;
        PrincipalEntity principalEntity = userEntity.getPrincipal();
        if (principalEntity != null && (roles = principalEntity.getPrivileges()) != null) {
            Integer adminPermissionId;
            PermissionEntity adminPermission = this.permissionDAO.findAmbariAdminPermission();
            Integer n = adminPermissionId = adminPermission == null ? null : adminPermission.getId();
            if (adminPermissionId != null) {
                for (PrivilegeEntity privilegeEntity : roles) {
                    PermissionEntity rolePermission = privilegeEntity.getPermission();
                    if (rolePermission == null || !adminPermissionId.equals(rolePermission.getId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public synchronized void grantAdminPrivilege(Integer userId) {
        this.grantAdminPrivilege(this.userDAO.findByPK(userId));
    }

    public synchronized void grantAdminPrivilege(UserEntity userEntity) {
        PrivilegeEntity adminPrivilege = new PrivilegeEntity();
        adminPrivilege.setPermission(this.permissionDAO.findAmbariAdminPermission());
        adminPrivilege.setPrincipal(userEntity.getPrincipal());
        adminPrivilege.setResource(this.resourceDAO.findAmbariResource());
        if (!userEntity.getPrincipal().getPrivileges().contains(adminPrivilege)) {
            this.privilegeDAO.create(adminPrivilege);
            userEntity.getPrincipal().getPrivileges().add(adminPrivilege);
            this.principalDAO.merge(userEntity.getPrincipal());
            this.userDAO.merge(userEntity);
        }
    }

    public synchronized void grantPrivilegeToGroup(Integer groupId, Long resourceId, ResourceType resourceType, String permissionName) {
        GroupEntity group = this.groupDAO.findByPK(groupId);
        PrivilegeEntity privilege = new PrivilegeEntity();
        ResourceTypeEntity resourceTypeEntity = new ResourceTypeEntity();
        resourceTypeEntity.setId(resourceType.getId());
        resourceTypeEntity.setName(resourceType.name());
        privilege.setPermission(this.permissionDAO.findPermissionByNameAndType(permissionName, resourceTypeEntity));
        privilege.setPrincipal(group.getPrincipal());
        privilege.setResource(this.resourceDAO.findById(resourceId));
        if (!group.getPrincipal().getPrivileges().contains(privilege)) {
            this.privilegeDAO.create(privilege);
            group.getPrincipal().getPrivileges().add(privilege);
            this.principalDAO.merge(group.getPrincipal());
            this.groupDAO.merge(group);
            this.privilegeDAO.merge(privilege);
        }
    }

    public synchronized void revokeAdminPrivilege(Integer userId) {
        this.revokeAdminPrivilege(this.userDAO.findByPK(userId));
    }

    public synchronized void revokeAdminPrivilege(UserEntity userEntity) {
        for (PrivilegeEntity privilege : userEntity.getPrincipal().getPrivileges()) {
            if (!privilege.getPermission().getPermissionName().equals("OBDP.ADMINISTRATOR")) continue;
            userEntity.getPrincipal().getPrivileges().remove(privilege);
            this.principalDAO.merge(userEntity.getPrincipal());
            this.userDAO.merge(userEntity);
            this.privilegeDAO.remove(privilege);
            break;
        }
    }

    @Transactional
    public synchronized void addMemberToGroup(String groupName, String userName) throws OBDPException {
        GroupEntity groupEntity = this.groupDAO.findGroupByName(groupName);
        if (groupEntity == null) {
            throw new OBDPException("Group " + groupName + " doesn't exist");
        }
        UserEntity userEntity = this.userDAO.findUserByName(userName);
        if (userEntity == null) {
            throw new OBDPException("User " + userName + " doesn't exist");
        }
        this.addMemberToGroup(groupEntity, userEntity);
    }

    @Transactional
    public synchronized void addMemberToGroup(GroupEntity groupEntity, UserEntity userEntity) throws OBDPException {
        if (groupEntity == null) {
            throw new NullPointerException();
        }
        if (userEntity == null) {
            throw new NullPointerException();
        }
        if (!this.isUserInGroup(userEntity, groupEntity)) {
            MemberEntity memberEntity = new MemberEntity();
            memberEntity.setGroup(groupEntity);
            memberEntity.setUser(userEntity);
            userEntity.getMemberEntities().add(memberEntity);
            groupEntity.getMemberEntities().add(memberEntity);
            this.memberDAO.create(memberEntity);
            this.userDAO.merge(userEntity);
            this.groupDAO.merge(groupEntity);
        }
    }

    @Transactional
    public synchronized void removeMemberFromGroup(String groupName, String userName) throws OBDPException {
        GroupEntity groupEntity = this.groupDAO.findGroupByName(groupName);
        if (groupEntity == null) {
            throw new OBDPException("Group " + groupName + " doesn't exist");
        }
        UserEntity userEntity = this.userDAO.findUserByName(userName);
        if (userEntity == null) {
            throw new OBDPException("User " + userName + " doesn't exist");
        }
        this.removeMemberFromGroup(groupEntity, userEntity);
    }

    @Transactional
    public synchronized void removeMemberFromGroup(GroupEntity groupEntity, UserEntity userEntity) throws OBDPException {
        if (this.isUserInGroup(userEntity, groupEntity)) {
            MemberEntity memberEntity = null;
            for (MemberEntity entity : userEntity.getMemberEntities()) {
                if (!entity.getGroup().equals(groupEntity)) continue;
                memberEntity = entity;
                break;
            }
            userEntity.getMemberEntities().remove(memberEntity);
            groupEntity.getMemberEntities().remove(memberEntity);
            this.userDAO.merge(userEntity);
            this.groupDAO.merge(groupEntity);
            this.memberDAO.remove(memberEntity);
        }
    }

    public synchronized boolean isUserCanBeRemoved(UserEntity userEntity) {
        List<PrincipalEntity> adminPrincipals = this.principalDAO.findByPermissionId(1);
        HashSet<UserEntity> userEntitysSet = new HashSet<UserEntity>(this.userDAO.findUsersByPrincipal(adminPrincipals));
        return !userEntitysSet.contains(userEntity) || userEntitysSet.size() >= 2;
    }

    public boolean isUserInGroup(UserEntity userEntity, GroupEntity groupEntity) {
        for (MemberEntity memberEntity : userEntity.getMemberEntities()) {
            if (!memberEntity.getGroup().equals(groupEntity)) continue;
            return true;
        }
        return false;
    }

    public void processLdapSync(LdapBatchDto batchInfo) {
        HashMap<String, UserEntity> allUsers = new HashMap<String, UserEntity>();
        HashMap<String, GroupEntity> allGroups = new HashMap<String, GroupEntity>();
        for (UserEntity userEntity : this.userDAO.findAll()) {
            allUsers.put(userEntity.getUserName(), userEntity);
        }
        for (GroupEntity groupEntity : this.groupDAO.findAll()) {
            allGroups.put(groupEntity.getGroupName(), groupEntity);
        }
        PrincipalTypeEntity groupPrincipalType = this.principalTypeDAO.ensurePrincipalTypeCreated(2);
        HashSet<UserEntity> usersToRemove = new HashSet<UserEntity>();
        HashSet<UserAuthenticationEntity> authenticationEntitiesToRemove = new HashSet<UserAuthenticationEntity>();
        for (LdapUserDto ldapUserDto : batchInfo.getUsersToBeRemoved()) {
            UserEntity userEntity = this.userDAO.findUserByName(ldapUserDto.getUserName());
            if (userEntity == null) continue;
            List<UserAuthenticationEntity> list = this.userAuthenticationDAO.findByUser(userEntity);
            Iterator<UserAuthenticationEntity> iterator = list.iterator();
            while (iterator.hasNext()) {
                UserAuthenticationEntity userAuthenticationEntity = iterator.next();
                if (userAuthenticationEntity.getAuthenticationType() != UserAuthenticationType.LDAP) continue;
                String dn = ldapUserDto.getDn();
                String authenticationKey = userAuthenticationEntity.getAuthenticationKey();
                if (StringUtils.isEmpty((String)dn) || StringUtils.isEmpty((String)authenticationKey) || dn.equalsIgnoreCase(authenticationKey)) {
                    authenticationEntitiesToRemove.add(userAuthenticationEntity);
                }
                iterator.remove();
            }
            if (!list.isEmpty()) continue;
            allUsers.remove(userEntity.getUserName());
            usersToRemove.add(userEntity);
        }
        this.userAuthenticationDAO.remove(authenticationEntitiesToRemove);
        this.userDAO.remove(usersToRemove);
        HashSet<GroupEntity> groupsToRemove = new HashSet<GroupEntity>();
        for (LdapGroupDto ldapGroupDto : batchInfo.getGroupsToBeRemoved()) {
            GroupEntity groupEntity = this.groupDAO.findGroupByName(ldapGroupDto.getGroupName());
            allGroups.remove(groupEntity.getGroupName());
            groupsToRemove.add(groupEntity);
        }
        this.groupDAO.remove(groupsToRemove);
        HashSet<UserEntity> hashSet = new HashSet<UserEntity>();
        for (LdapUserDto ldapUserDto : batchInfo.getUsersToBecomeLdap()) {
            String string = ldapUserDto.getUserName();
            UserEntity userEntity = this.userDAO.findUserByName(string);
            if (userEntity != null) {
                List<UserAuthenticationEntity> existingEntities;
                LOG.trace("Enabling LDAP authentication for the user account with the username {}.", (Object)string);
                if (this.configuration.getLdapSyncCollisionHandlingBehavior() == Configuration.LdapUsernameCollisionHandlingBehavior.CONVERT && (existingEntities = userEntity.getAuthenticationEntities()) != null) {
                    Iterator iterator = existingEntities.iterator();
                    while (iterator.hasNext()) {
                        UserAuthenticationEntity userAuthenticationEntity = (UserAuthenticationEntity)iterator.next();
                        if (userAuthenticationEntity.getAuthenticationType() == UserAuthenticationType.LDAP) continue;
                        this.removeAuthentication(userEntity, userAuthenticationEntity.getUserAuthenticationId());
                        iterator.remove();
                    }
                }
                try {
                    this.addLdapAuthentication(userEntity, ldapUserDto.getDn(), false);
                    hashSet.add(userEntity);
                }
                catch (OBDPException e) {
                    LOG.warn(String.format("Failed to enable LDAP authentication for the user account with the username %s: %s", string, e.getLocalizedMessage()), (Throwable)e);
                }
                continue;
            }
            LOG.warn("Failed to find user account for {} while enabling LDAP authentication for the user.", (Object)string);
        }
        this.userDAO.merge(hashSet);
        HashSet<GroupEntity> hashSet2 = new HashSet<GroupEntity>();
        for (LdapGroupDto ldapGroupDto : batchInfo.getGroupsToBecomeLdap()) {
            GroupEntity groupEntity = this.groupDAO.findGroupByName(ldapGroupDto.getGroupName());
            groupEntity.setGroupType(GroupType.LDAP);
            allGroups.put(groupEntity.getGroupName(), groupEntity);
            hashSet2.add(groupEntity);
        }
        this.groupDAO.merge(hashSet2);
        ArrayList<PrincipalEntity> arrayList = new ArrayList<PrincipalEntity>();
        for (LdapUserDto ldapUserDto : batchInfo.getUsersToBeCreated()) {
            UserEntity userEntity;
            String userName = ldapUserDto.getUserName();
            try {
                userEntity = this.createUser(userName, userName, userName, true);
            }
            catch (OBDPException e) {
                LOG.error(String.format("Failed to create new user: %s", userName), (Throwable)e);
                userEntity = null;
            }
            if (userEntity == null) continue;
            LOG.trace("Enabling LDAP authentication for the user account with the username {}.", (Object)userName);
            try {
                this.addLdapAuthentication(userEntity, ldapUserDto.getDn(), false);
            }
            catch (OBDPException e) {
                LOG.warn(String.format("Failed to enable LDAP authentication for the user account with the username %s: %s", userName, e.getLocalizedMessage()), (Throwable)e);
            }
            this.userDAO.merge(userEntity);
            allUsers.put(userEntity.getUserName(), userEntity);
        }
        HashSet<GroupEntity> hashSet3 = new HashSet<GroupEntity>();
        for (LdapGroupDto group : batchInfo.getGroupsToBeCreated()) {
            PrincipalEntity principalEntity = new PrincipalEntity();
            principalEntity.setPrincipalType(groupPrincipalType);
            arrayList.add(principalEntity);
            GroupEntity groupEntity = new GroupEntity();
            groupEntity.setGroupName(group.getGroupName());
            groupEntity.setPrincipal(principalEntity);
            groupEntity.setGroupType(GroupType.LDAP);
            allGroups.put(groupEntity.getGroupName(), groupEntity);
            hashSet3.add(groupEntity);
        }
        this.principalDAO.create(arrayList);
        this.groupDAO.create(hashSet3);
        HashSet<MemberEntity> hashSet4 = new HashSet<MemberEntity>();
        HashSet<GroupEntity> groupsToUpdate = new HashSet<GroupEntity>();
        for (LdapUserGroupMemberDto member : batchInfo.getMembershipToAdd()) {
            MemberEntity memberEntity = new MemberEntity();
            GroupEntity groupEntity = (GroupEntity)allGroups.get(member.getGroupName());
            memberEntity.setGroup(groupEntity);
            memberEntity.setUser((UserEntity)allUsers.get(member.getUserName()));
            groupEntity.getMemberEntities().add(memberEntity);
            groupsToUpdate.add(groupEntity);
            hashSet4.add(memberEntity);
        }
        this.processLdapAdminGroupMappingRules(hashSet4);
        this.memberDAO.create(hashSet4);
        this.groupDAO.merge(groupsToUpdate);
        HashSet<MemberEntity> membersToRemove = new HashSet<MemberEntity>();
        for (LdapUserGroupMemberDto member : batchInfo.getMembershipToRemove()) {
            MemberEntity memberEntity = this.memberDAO.findByUserAndGroup(member.getUserName(), member.getGroupName());
            if (memberEntity == null) continue;
            membersToRemove.add(memberEntity);
        }
        this.memberDAO.remove(membersToRemove);
        ((EntityManager)this.entityManagerProvider.get()).getEntityManagerFactory().getCache().evictAll();
    }

    private void processLdapAdminGroupMappingRules(Set<MemberEntity> membershipsToCreate) {
        if (membershipsToCreate.isEmpty()) {
            LOG.debug("There are no new memberships for which to process administrator group mapping rules.");
            return;
        }
        OBDPLdapConfiguration ldapConfiguration = (OBDPLdapConfiguration)this.ldapConfigurationProvider.get();
        if (ldapConfiguration == null) {
            LOG.warn("The LDAP configuration is not available - no administrator group mappings will be processed.");
            return;
        }
        String adminGroupMappings = ldapConfiguration.groupMappingRules();
        if (Strings.isNullOrEmpty((String)adminGroupMappings)) {
            LOG.debug("There are no administrator group mappings to be processed.");
            return;
        }
        LOG.info("Processing admin group mapping rules [{}]. Membership entry count: [{}]", (Object)adminGroupMappings, (Object)membershipsToCreate.size());
        HashSet ldapAdminGroups = Sets.newHashSet((Object[])adminGroupMappings.split(","));
        HashSet ambariAdminProspects = Sets.newHashSet();
        for (MemberEntity memberEntity : membershipsToCreate) {
            if (!ldapAdminGroups.contains(memberEntity.getGroup().getGroupName())) continue;
            LOG.debug("Ambari admin user prospect: [{}] ", (Object)memberEntity.getUser().getUserName());
            ambariAdminProspects.add(memberEntity.getUser());
        }
        for (UserEntity userEntity : ambariAdminProspects) {
            LOG.info("Granting ambari admin roles to the user: {}", (Object)userEntity.getUserName());
            this.grantAdminPrivilege(userEntity.getUserId());
        }
    }

    private Map<String, Set<String>> getUsersToGroupMap(Set<UserEntity> usersToCreate) {
        HashMap<String, Set<String>> usersToGroups = new HashMap<String, Set<String>>();
        for (UserEntity userEntity : usersToCreate) {
            userEntity = this.userDAO.findByPK(userEntity.getUserId());
            usersToGroups.put(userEntity.getUserName(), new HashSet());
            for (MemberEntity memberEntity : userEntity.getMemberEntities()) {
                ((Set)usersToGroups.get(userEntity.getUserName())).add(memberEntity.getGroup().getGroupName());
            }
        }
        return usersToGroups;
    }

    public Collection<PrivilegeEntity> getUserPrivileges(UserEntity userEntity) {
        List<PrivilegeEntity> privilegeEntities;
        if (userEntity == null) {
            return Collections.emptyList();
        }
        LinkedList<PrincipalEntity> principalEntities = new LinkedList<PrincipalEntity>();
        principalEntities.add(userEntity.getPrincipal());
        List<MemberEntity> memberEntities = this.memberDAO.findAllMembersByUser(userEntity);
        for (MemberEntity memberEntity : memberEntities) {
            principalEntities.add(memberEntity.getGroup().getPrincipal());
        }
        List<PrivilegeEntity> explicitPrivilegeEntities = this.privilegeDAO.findAllByPrincipal(principalEntities);
        List<PrivilegeEntity> implicitPrivilegeEntities = this.getImplicitPrivileges(explicitPrivilegeEntities);
        if (implicitPrivilegeEntities.isEmpty()) {
            privilegeEntities = explicitPrivilegeEntities;
        } else {
            privilegeEntities = new LinkedList<PrivilegeEntity>();
            privilegeEntities.addAll(explicitPrivilegeEntities);
            privilegeEntities.addAll(implicitPrivilegeEntities);
        }
        return privilegeEntities;
    }

    public Collection<PrivilegeEntity> getGroupPrivileges(GroupEntity groupEntity) {
        List<PrivilegeEntity> privilegeEntities;
        if (groupEntity == null) {
            return Collections.emptyList();
        }
        LinkedList<PrincipalEntity> principalEntities = new LinkedList<PrincipalEntity>();
        principalEntities.add(groupEntity.getPrincipal());
        List<PrivilegeEntity> explicitPrivilegeEntities = this.privilegeDAO.findAllByPrincipal(principalEntities);
        List<PrivilegeEntity> implicitPrivilegeEntities = this.getImplicitPrivileges(explicitPrivilegeEntities);
        if (implicitPrivilegeEntities.isEmpty()) {
            privilegeEntities = explicitPrivilegeEntities;
        } else {
            privilegeEntities = new LinkedList<PrivilegeEntity>();
            privilegeEntities.addAll(explicitPrivilegeEntities);
            privilegeEntities.addAll(implicitPrivilegeEntities);
        }
        return privilegeEntities;
    }

    public Collection<OBDPGrantedAuthority> getUserAuthorities(String userName) {
        return this.getUserAuthorities(this.getUserEntity(userName));
    }

    public Collection<OBDPGrantedAuthority> getUserAuthorities(UserEntity userEntity) {
        if (userEntity == null) {
            return Collections.emptyList();
        }
        Collection<PrivilegeEntity> privilegeEntities = this.getUserPrivileges(userEntity);
        HashSet<OBDPGrantedAuthority> authorities = new HashSet<OBDPGrantedAuthority>(privilegeEntities.size());
        for (PrivilegeEntity privilegeEntity : privilegeEntities) {
            authorities.add(new OBDPGrantedAuthority(privilegeEntity));
        }
        return authorities;
    }

    private List<PrivilegeEntity> getImplicitPrivileges(List<PrivilegeEntity> privilegeEntities) {
        if (privilegeEntities == null || privilegeEntities.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<PrivilegeEntity> implicitPrivileges = new LinkedList<PrivilegeEntity>();
        ArrayList<PrincipalEntity> rolePrincipals = new ArrayList<PrincipalEntity>();
        for (PrivilegeEntity privilegeEntity : privilegeEntities) {
            PrincipalEntity rolePrincipal = privilegeEntity.getPermission().getPrincipal();
            if (rolePrincipal == null) continue;
            rolePrincipals.add(rolePrincipal);
        }
        if (!rolePrincipals.isEmpty()) {
            implicitPrivileges.addAll(this.privilegeDAO.findAllByPrincipal(rolePrincipals));
        }
        return implicitPrivileges;
    }

    public Collection<UserAuthenticationEntity> getUserAuthenticationEntities(String username, UserAuthenticationType authenticationType) {
        UserEntity userEntity;
        if (!StringUtils.isEmpty((String)username)) {
            userEntity = this.userDAO.findUserByName(username);
            if (userEntity == null) {
                return null;
            }
        } else {
            userEntity = null;
        }
        return this.getUserAuthenticationEntities(userEntity, authenticationType);
    }

    public Collection<UserAuthenticationEntity> getUserAuthenticationEntities(UserEntity userEntity, UserAuthenticationType authenticationType) {
        if (userEntity == null) {
            if (authenticationType == null) {
                return this.userAuthenticationDAO.findAll();
            }
            return this.userAuthenticationDAO.findByType(authenticationType);
        }
        List<UserAuthenticationEntity> authenticationEntities = this.userAuthenticationDAO.findByUser(userEntity);
        if (authenticationType == null) {
            return authenticationEntities;
        }
        ArrayList<UserAuthenticationEntity> pruned = new ArrayList<UserAuthenticationEntity>();
        for (UserAuthenticationEntity authenticationEntity : authenticationEntities) {
            if (authenticationEntity.getAuthenticationType() != authenticationType) continue;
            pruned.add(authenticationEntity);
        }
        return pruned;
    }

    public Collection<UserAuthenticationEntity> getUserAuthenticationEntities(UserAuthenticationType authenticationType, String key) {
        return this.userAuthenticationDAO.findByTypeAndKey(authenticationType, key);
    }

    @Transactional
    public synchronized void modifyAuthentication(UserAuthenticationEntity userAuthenticationEntity, String currentKey, String newKey, boolean isSelf) throws OBDPException {
        if (userAuthenticationEntity != null) {
            if (userAuthenticationEntity.getAuthenticationType() == UserAuthenticationType.LOCAL) {
                String expectedCurrentKey;
                String string = expectedCurrentKey = isSelf ? userAuthenticationEntity.getAuthenticationKey() : this.getAuthenticatedUserLocalAuthenticationMethod().orElseThrow(() -> new OBDPException("Authentication error")).getAuthenticationKey();
                if (StringUtils.isEmpty((String)currentKey) || !this.passwordEncoder.matches((CharSequence)currentKey, expectedCurrentKey)) {
                    throw new OBDPException("Wrong current password provided");
                }
                this.validatePassword(newKey, userAuthenticationEntity.getUser().getUserName(), userAuthenticationEntity.getFullAuthenticationKey());
                userAuthenticationEntity.updateAuthenticationKey(this.passwordEncoder.encode((CharSequence)newKey), this.configuration.getPasswordPolicyHistoryCount());
            } else {
                userAuthenticationEntity.setAuthenticationKey(newKey);
            }
            this.userAuthenticationDAO.merge(userAuthenticationEntity);
        }
    }

    private Optional<AuthenticationMethod> getAuthenticatedUserLocalAuthenticationMethod() {
        User authenticatedUser = this.getUser(AuthorizationHelper.getAuthenticatedId());
        return authenticatedUser.getAuthenticationMethods().stream().filter(am -> UserAuthenticationType.LOCAL.equals((Object)am.getAuthenticationType())).findAny();
    }

    public void removeAuthentication(String username, Long authenticationId) {
        this.removeAuthentication(this.getUserEntity(username), authenticationId);
    }

    @Transactional
    public void removeAuthentication(UserEntity userEntity, Long authenticationId) {
        if (userEntity != null && authenticationId != null) {
            boolean changed = false;
            userEntity = this.userDAO.findByPK(userEntity.getUserId());
            List<UserAuthenticationEntity> authenticationEntities = userEntity.getAuthenticationEntities();
            Iterator<UserAuthenticationEntity> iterator = authenticationEntities.iterator();
            while (iterator.hasNext()) {
                UserAuthenticationEntity authenticationEntity = iterator.next();
                if (!authenticationId.equals(authenticationEntity.getUserAuthenticationId())) continue;
                this.userAuthenticationDAO.remove(authenticationEntity);
                iterator.remove();
                changed = true;
                break;
            }
            if (changed) {
                this.userDAO.merge(userEntity);
            }
        }
    }

    public void addAuthentication(UserEntity userEntity, UserAuthenticationType authenticationType, String key) throws OBDPException {
        switch (authenticationType) {
            case LOCAL: {
                this.addLocalAuthentication(userEntity, key);
                break;
            }
            case LDAP: {
                this.addLdapAuthentication(userEntity, key);
                break;
            }
            case JWT: {
                this.addJWTAuthentication(userEntity, key);
                break;
            }
            case PAM: {
                this.addPamAuthentication(userEntity, key);
                break;
            }
            case KERBEROS: {
                this.addKerberosAuthentication(userEntity, key);
                break;
            }
            default: {
                throw new OBDPException("Unexpected user authentication type");
            }
        }
    }

    public void addJWTAuthentication(UserEntity userEntity, String key) throws OBDPException {
        this.addJWTAuthentication(userEntity, key, true);
    }

    public void addJWTAuthentication(UserEntity userEntity, String key, boolean persist) throws OBDPException {
        this.addAuthentication(userEntity, UserAuthenticationType.JWT, key, (user, authKey) -> {
            List<UserAuthenticationEntity> authenticationEntities = user.getAuthenticationEntities();
            for (UserAuthenticationEntity entity : authenticationEntities) {
                if (entity.getAuthenticationType() != UserAuthenticationType.JWT || !(authKey == null ? entity.getAuthenticationKey() == null : authKey.equals(entity.getAuthenticationKey()))) continue;
                throw new OBDPException("The authentication type already exists for this user");
            }
        }, persist);
    }

    public void addKerberosAuthentication(UserEntity userEntity, String principalName) throws OBDPException {
        this.addKerberosAuthentication(userEntity, principalName, true);
    }

    public void addKerberosAuthentication(UserEntity userEntity, String principalName, boolean persist) throws OBDPException {
        this.addAuthentication(userEntity, UserAuthenticationType.KERBEROS, principalName, (user, key) -> {
            if (!CollectionUtils.isEmpty(this.userAuthenticationDAO.findByTypeAndKey(UserAuthenticationType.KERBEROS, key))) {
                throw new OBDPException("The authentication type already exists for this principal");
            }
        }, persist);
    }

    public void addLocalAuthentication(UserEntity userEntity, String password) throws OBDPException {
        this.addLocalAuthentication(userEntity, password, true);
    }

    public void addLocalAuthentication(UserEntity userEntity, String password, boolean persist) throws OBDPException {
        this.validatePassword(password, userEntity.getUserName());
        String encodedPassword = this.passwordEncoder.encode((CharSequence)password);
        this.addAuthentication(userEntity, UserAuthenticationType.LOCAL, encodedPassword, (user, key) -> {
            List<UserAuthenticationEntity> authenticationEntities = user.getAuthenticationEntities();
            for (UserAuthenticationEntity entity : authenticationEntities) {
                if (entity.getAuthenticationType() != UserAuthenticationType.LOCAL) continue;
                throw new OBDPException("The authentication type already exists for this user");
            }
        }, persist);
    }

    public void addPamAuthentication(UserEntity userEntity, String userName) throws OBDPException {
        this.addPamAuthentication(userEntity, userName, true);
    }

    public void addPamAuthentication(UserEntity userEntity, String userName, boolean persist) throws OBDPException {
        this.addAuthentication(userEntity, UserAuthenticationType.PAM, userName, (user, key) -> {
            List<UserAuthenticationEntity> authenticationEntities = user.getAuthenticationEntities();
            for (UserAuthenticationEntity entity : authenticationEntities) {
                if (entity.getAuthenticationType() != UserAuthenticationType.PAM) continue;
                throw new OBDPException("The authentication type already exists for this user");
            }
        }, persist);
    }

    public void addLdapAuthentication(UserEntity userEntity, String dn) throws OBDPException {
        this.addLdapAuthentication(userEntity, dn, true);
    }

    public void addLdapAuthentication(UserEntity userEntity, String dn, boolean persist) throws OBDPException {
        this.addAuthentication(userEntity, UserAuthenticationType.LDAP, StringUtils.lowerCase((String)dn), (user, key) -> {
            List<UserAuthenticationEntity> authenticationEntities = user.getAuthenticationEntities();
            for (UserAuthenticationEntity entity : authenticationEntities) {
                if (entity.getAuthenticationType() != UserAuthenticationType.LDAP || !(key == null ? entity.getAuthenticationKey() == null : key.equalsIgnoreCase(entity.getAuthenticationKey()))) continue;
                throw new OBDPException("The authentication type already exists for this user");
            }
        }, persist);
    }

    private void addAuthentication(UserEntity userEntity, UserAuthenticationType type, String key, Validator validator, boolean persist) throws OBDPException {
        if (userEntity == null) {
            throw new OBDPException("Missing user");
        }
        validator.validate(userEntity, key);
        List<UserAuthenticationEntity> authenticationEntities = this.userAuthenticationDAO.findByUser(userEntity);
        UserAuthenticationEntity authenticationEntity = new UserAuthenticationEntity();
        authenticationEntity.setUser(userEntity);
        authenticationEntity.setAuthenticationType(type);
        authenticationEntity.setAuthenticationKey(key);
        authenticationEntities.add(authenticationEntity);
        userEntity.setAuthenticationEntities(authenticationEntities);
        if (persist) {
            this.userDAO.merge(userEntity);
        }
    }

    public Integer incrementConsecutiveAuthenticationFailures(String username) {
        return this.incrementConsecutiveAuthenticationFailures(this.getUserEntity(username));
    }

    public Integer incrementConsecutiveAuthenticationFailures(UserEntity userEntity) {
        if (userEntity != null) {
            Command command = new Command(){

                @Override
                public void perform(UserEntity userEntity) {
                    userEntity.incrementConsecutiveFailures();
                }
            };
            userEntity = this.safelyUpdateUserEntity(userEntity, command, 10);
        }
        return userEntity == null ? null : userEntity.getConsecutiveFailures();
    }

    public void clearConsecutiveAuthenticationFailures(String username) {
        this.clearConsecutiveAuthenticationFailures(this.getUserEntity(username));
    }

    public void clearConsecutiveAuthenticationFailures(UserEntity userEntity) {
        if (userEntity != null && userEntity.getConsecutiveFailures() != 0) {
            Command command = new Command(){

                @Override
                public void perform(UserEntity userEntity) {
                    userEntity.setConsecutiveFailures(0);
                }
            };
            this.safelyUpdateUserEntity(userEntity, command, 10);
        }
    }

    public UserEntity safelyUpdateUserEntity(UserEntity userEntity, Command command) {
        return this.safelyUpdateUserEntity(userEntity, command, 10);
    }

    public UserEntity safelyUpdateUserEntity(UserEntity userEntity, Command command, int maxRetries) {
        int retriesLeft = maxRetries;
        while (true) {
            try {
                command.perform(userEntity);
                this.userDAO.merge(userEntity);
                return userEntity;
            }
            catch (Throwable t) {
                Throwable cause = t;
                int failSafe = 50;
                do {
                    if (!(cause instanceof OptimisticLockException)) continue;
                    Integer userID = userEntity.getUserId();
                    if ((userEntity = this.userDAO.findByPK(userID)) == null) {
                        LOG.warn("Failed to find user with user id of {}.  The user may have been removed. Aborting.", (Object)userID);
                        return null;
                    }
                    if (--retriesLeft == 0) {
                        LOG.error("Failed to update the user's ({}) consecutive failures value due to an OptimisticLockException.  Aborting.", (Object)userEntity.getUserName());
                        throw t;
                    }
                    LOG.warn("Failed to update the user's ({}) consecutive failures value due to an OptimisticLockException.  {} retries left, retrying...", (Object)userEntity.getUserName(), (Object)retriesLeft);
                    break;
                } while ((cause = cause.getCause()) != null && cause != t && --failSafe > 0);
                if (cause != null && cause != t && failSafe != 0) continue;
                throw t;
                if (retriesLeft > 0) continue;
                return userEntity;
            }
            break;
        }
    }

    public void validatePassword(String password) {
        if (StringUtils.isEmpty((String)password)) {
            throw new IllegalArgumentException("The password does not meet the password policy requirements");
        }
        String regexp = this.configuration.getPasswordPolicyRegexp();
        if (!StringUtils.isEmpty((String)regexp) && !Pattern.matches(regexp, password)) {
            String msg = "The password does not meet the OBDP user password policy : " + this.configuration.getPasswordPolicyDescription();
            throw new IllegalArgumentException(msg);
        }
    }

    public void validatePassword(String password, String userName) {
        this.validatePassword(password);
        if (StringUtils.isNotEmpty((String)userName) && Pattern.compile(Pattern.quote(userName), 2).matcher(password).find()) {
            String msg = "The password does not meet the OBDP user password policy : password cannot contain the username";
            throw new IllegalArgumentException("The password does not meet the OBDP user password policy : password cannot contain the username");
        }
    }

    public void validatePassword(String password, String userName, String authenticationKey) {
        String[] previousPasswords;
        this.validatePassword(password, userName);
        boolean isMatched = false;
        for (String previousPassword : previousPasswords = StringUtils.split((String)authenticationKey, (String)",")) {
            if (!this.passwordEncoder.matches((CharSequence)password, previousPassword)) continue;
            isMatched = true;
            break;
        }
        if (isMatched) {
            String msg = "The password does not meet the Ambari user password policy : new password can not be same as previous " + this.configuration.getPasswordPolicyHistoryCount() + " passwords.";
            throw new IllegalArgumentException(msg);
        }
    }

    public static interface Command {
        public void perform(UserEntity var1);
    }

    private static interface Validator {
        public void validate(UserEntity var1, String var2) throws OBDPException;
    }
}

