/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authorization;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public class UserName {
    private static final char[] FORBIDDEN_CHARS = new char[]{'<', '>', '&', '|', '\\', '`'};
    private final String userName;

    public static UserName fromString(String userName) {
        return new UserName(UserName.validated(userName));
    }

    private static String validated(String userName) {
        if (StringUtils.isBlank((String)userName)) {
            throw new IllegalArgumentException("Username cannot be empty");
        }
        UserName.rejectIfContainsAnyOf(userName, FORBIDDEN_CHARS);
        return userName;
    }

    private static void rejectIfContainsAnyOf(String name, char[] forbiddenChars) {
        for (char each : forbiddenChars) {
            if (!name.contains(Character.toString(each))) continue;
            throw new IllegalArgumentException("Invalid username: " + name + " Avoid characters " + Arrays.toString(forbiddenChars));
        }
    }

    private UserName(String userName) {
        this.userName = userName;
    }

    public String toString() {
        return this.userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserName userName1 = (UserName)o;
        return this.userName.equals(userName1.userName);
    }

    public int hashCode() {
        return this.userName.hashCode();
    }
}

