/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authorization;

import id.onyx.obdp.server.orm.entities.MemberEntity;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.UserAuthenticationEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.security.authorization.AuthenticationMethod;
import id.onyx.obdp.server.security.authorization.UserAuthenticationType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

@ApiModel
public class User {
    private final int userId;
    private final String userName;
    private final Date createTime;
    private final boolean active;
    private final Collection<String> groups;
    private final Collection<AuthenticationMethod> authenticationMethods;
    private final boolean admin;

    public User(UserEntity userEntity) {
        boolean bl;
        this.userId = userEntity.getUserId();
        this.userName = userEntity.getUserName();
        this.createTime = new Date(userEntity.getCreateTime());
        this.active = userEntity.getActive();
        this.groups = new ArrayList<String>();
        for (MemberEntity memberEntity : userEntity.getMemberEntities()) {
            this.groups.add(memberEntity.getGroup().getGroupName());
        }
        this.authenticationMethods = new ArrayList<AuthenticationMethod>();
        List<UserAuthenticationEntity> authenticationEntities = userEntity.getAuthenticationEntities();
        for (UserAuthenticationEntity authenticationEntity : authenticationEntities) {
            this.authenticationMethods.add(new AuthenticationMethod(authenticationEntity.getAuthenticationType(), authenticationEntity.getAuthenticationKey()));
        }
        boolean bl2 = false;
        for (PrivilegeEntity privilegeEntity : userEntity.getPrincipal().getPrivileges()) {
            if (!privilegeEntity.getPermission().getPermissionName().equals("OBDP.ADMINISTRATOR")) continue;
            bl = true;
            break;
        }
        this.admin = bl;
    }

    @ApiModelProperty(hidden=true)
    public int getUserId() {
        return this.userId;
    }

    @ApiModelProperty(name="Users/user_name", required=true, access="public", notes="username containing only lowercase letters")
    public String getUserName() {
        return this.userName;
    }

    @ApiModelProperty(hidden=true)
    public Date getCreateTime() {
        return this.createTime;
    }

    @ApiModelProperty(name="Users/active")
    public boolean isActive() {
        return this.active;
    }

    @ApiModelProperty(name="Users/admin")
    public boolean isAdmin() {
        return this.admin;
    }

    @ApiModelProperty(name="Users/groups")
    public Collection<String> getGroups() {
        return this.groups;
    }

    @ApiModelProperty(name="Users/authentication_methods")
    public Collection<AuthenticationMethod> getAuthenticationMethods() {
        return this.authenticationMethods;
    }

    @ApiModelProperty(name="Users/ldap_user")
    public boolean isLdapUser() {
        for (AuthenticationMethod authenticationMethod : this.authenticationMethods) {
            if (authenticationMethod.getAuthenticationType() != UserAuthenticationType.LDAP) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.userName;
    }
}

