/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authorization;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.ViewInstanceDAO;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.security.authorization.OBDPGrantedAuthority;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

@Singleton
public class PermissionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PermissionHelper.class);
    @Inject
    private ClusterDAO clusterDAO;
    @Inject
    private ViewInstanceDAO viewInstanceDAO;

    public Map<String, List<String>> getPermissionLabels(Authentication authentication) {
        HashMap<String, List<String>> permissionLabels = new HashMap<String, List<String>>();
        if (authentication.getAuthorities() != null) {
            for (GrantedAuthority grantedAuthority : authentication.getAuthorities()) {
                if (!(grantedAuthority instanceof OBDPGrantedAuthority)) continue;
                OBDPGrantedAuthority ambariGrantedAuthority = (OBDPGrantedAuthority)grantedAuthority;
                PrivilegeEntity privilegeEntity = ambariGrantedAuthority.getPrivilegeEntity();
                String key = null;
                try {
                    switch (privilegeEntity.getResource().getResourceType().getName()) {
                        case "CLUSTER": {
                            key = this.clusterDAO.findByResourceId(privilegeEntity.getResource().getId()).getClusterName();
                            break;
                        }
                        case "OBDP": {
                            key = "Ambari";
                            break;
                        }
                        default: {
                            key = this.viewInstanceDAO.findByResourceId(privilegeEntity.getResource().getId()).getLabel();
                            break;
                        }
                    }
                }
                catch (Throwable ignored) {
                    LOG.warn("Error occurred when cluster or view is searched based on resource id", ignored);
                }
                if (key == null) continue;
                if (!permissionLabels.containsKey(key)) {
                    permissionLabels.put(key, new LinkedList());
                }
                ((List)permissionLabels.get(key)).add(privilegeEntity.getPermission().getPermissionLabel());
            }
        }
        return permissionLabels;
    }
}

