/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authorization;

import com.google.inject.Inject;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.security.authentication.OBDPUserAuthentication;
import id.onyx.obdp.server.security.authentication.OBDPUserDetailsImpl;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.Users;
import id.onyx.obdp.server.security.authorization.internal.InternalTokenStorage;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class OBDPUserAuthorizationFilter
implements Filter {
    private final InternalTokenStorage internalTokenStorage;
    private final Users users;

    @Inject
    public OBDPUserAuthorizationFilter(InternalTokenStorage internalTokenStorage, Users users) {
        this.internalTokenStorage = internalTokenStorage;
        this.users = users;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String userToken;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String token = httpRequest.getHeader("X-Internal-Token");
        if (token != null && this.internalTokenStorage.isValidInternalToken(token) && (userToken = httpRequest.getHeader("X-Authenticated-User-ID")) != null) {
            if (!NumberUtils.isDigits((String)userToken)) {
                httpResponse.sendError(403, "Invalid user ID");
                httpResponse.flushBuffer();
                return;
            }
            Integer userId = Integer.parseInt(userToken);
            UserEntity userEntity = this.users.getUserEntity(userId);
            if (userEntity == null) {
                httpResponse.sendError(403, "Authentication required");
                httpResponse.flushBuffer();
                return;
            }
            if (!userEntity.getActive().booleanValue()) {
                httpResponse.sendError(403, "User is not active");
                httpResponse.flushBuffer();
                return;
            }
            OBDPUserDetailsImpl userDetails = new OBDPUserDetailsImpl(this.users.getUser(userEntity), null, this.users.getUserAuthorities(userEntity));
            OBDPUserAuthentication authentication = new OBDPUserAuthentication(token, userDetails, true);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            httpResponse.setHeader("User", AuthorizationHelper.getAuthenticatedName());
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

