/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authorization;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.support.LdapUtils;

public class OBDPLdapUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OBDPLdapUtils.class);
    private static final Pattern UPN_FORMAT = Pattern.compile(".+@\\w+(\\.\\w+)*");

    public static boolean isUserPrincipalNameFormat(String loginName) {
        return UPN_FORMAT.matcher(loginName).matches();
    }

    public static boolean isLdapObjectOutOfScopeFromBaseDn(DirContextAdapter adapter, String baseDn) {
        boolean isOutOfScope = true;
        try {
            Name dn = adapter.getDn();
            Preconditions.checkArgument((dn != null ? 1 : 0) != 0, (Object)"DN cannot be null in LDAP response object");
            Name fullDn = OBDPLdapUtils.getFullDn(dn, (Context)adapter);
            LdapName base = LdapUtils.newLdapName((String)baseDn);
            if (fullDn.startsWith(base)) {
                isOutOfScope = false;
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        return isOutOfScope;
    }

    public static Name getFullDn(String dn, Context context) throws NamingException {
        return OBDPLdapUtils.getFullDn((Name)LdapUtils.newLdapName((String)dn), context);
    }

    public static Name getFullDn(Name dn, Context context) throws NamingException {
        return OBDPLdapUtils.getFullDn((Name)LdapUtils.newLdapName((Name)dn), LdapUtils.newLdapName((String)context.getNameInNamespace()));
    }

    public static Name getFullDn(Name dn, Name baseDn) {
        if (dn.startsWith(baseDn)) {
            return dn;
        }
        try {
            baseDn = LdapUtils.newLdapName((Name)baseDn);
            baseDn.addAll(dn);
        }
        catch (InvalidNameException e) {
            LOG.error(e.getMessage());
        }
        return baseDn;
    }
}

