/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authorization;

import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.ResourceEntity;
import org.springframework.security.core.GrantedAuthority;

public class OBDPGrantedAuthority
implements GrantedAuthority {
    private final PrivilegeEntity privilegeEntity;

    public OBDPGrantedAuthority(PrivilegeEntity privilegeEntity) {
        this.privilegeEntity = privilegeEntity;
    }

    public String getAuthority() {
        ResourceEntity resource = this.privilegeEntity.getResource();
        Long resourceId = resource.getId();
        String resourceTypeQualifier = resource.getResourceType().getName().toUpperCase() + ".";
        String privilegeName = this.privilegeEntity.getPermission().getPermissionName() + "@" + resourceId;
        return privilegeName.startsWith(resourceTypeQualifier) ? privilegeName : resourceTypeQualifier + privilegeName;
    }

    public PrivilegeEntity getPrivilegeEntity() {
        return this.privilegeEntity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBDPGrantedAuthority that = (OBDPGrantedAuthority)o;
        return !(this.privilegeEntity == null ? that.privilegeEntity != null : !this.privilegeEntity.equals(that.privilegeEntity));
    }

    public int hashCode() {
        return this.privilegeEntity != null ? this.privilegeEntity.hashCode() : 0;
    }
}

