/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.security.authorization;

import id.onyx.obdp.server.audit.AuditLogger;
import id.onyx.obdp.server.audit.event.AccessUnauthorizedAuditEvent;
import id.onyx.obdp.server.audit.event.AuditEvent;
import id.onyx.obdp.server.audit.event.LoginAuditEvent;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.security.AmbariEntryPoint;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.OBDPGrantedAuthority;
import id.onyx.obdp.server.security.authorization.PermissionHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.security.authorization.User;
import id.onyx.obdp.server.security.authorization.Users;
import id.onyx.obdp.server.security.authorization.internal.InternalAuthenticationToken;
import id.onyx.obdp.server.utils.RequestUtils;
import id.onyx.obdp.server.view.ViewRegistry;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.util.EnumSet;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class OBDPAuthorizationFilter
implements Filter {
    private static final String REALM_PARAM = "realm";
    private static final String DEFAULT_REALM = "AuthFilter";
    private static final String INTERNAL_TOKEN_HEADER = "X-Internal-Token";
    private static final Pattern STACK_ADVISOR_REGEX = Pattern.compile("/api/v[0-9]+/stacks/[^/]+/versions/[^/]+/(validations|recommendations).*");
    public static final String API_VERSION_PREFIX = "/api/v[0-9]+";
    public static final String VIEWS_CONTEXT_PATH_PREFIX = "/views/";
    private static final String VIEWS_CONTEXT_PATH_PATTERN = "/views/([^/]+)/([^/]+)/([^/]+)(.*)";
    private static final String VIEWS_CONTEXT_ALL_PATTERN = "/views/.*";
    private static final String API_USERS_ALL_PATTERN = "/api/v[0-9]+/users.*";
    private static final String API_PRIVILEGES_ALL_PATTERN = "/api/v[0-9]+/privileges.*";
    private static final String API_GROUPS_ALL_PATTERN = "/api/v[0-9]+/groups.*";
    private static final String API_CLUSTERS_PATTERN = "/api/v[0-9]+/clusters/(\\w+/?)?";
    private static final String API_WIDGET_LAYOUTS_PATTERN = "/api/v[0-9]+/clusters/.*?/widget_layouts.*?";
    private static final String API_WIDGET_PATTERN = "/api/v[0-9]+/clusters/.*?/widgets.*";
    private static final String API_CLUSTERS_ALL_PATTERN = "/api/v[0-9]+/clusters.*";
    private static final String API_VIEWS_ALL_PATTERN = "/api/v[0-9]+/views.*";
    private static final String API_AUTH_PATTERN = "/api/v[0-9]+/auth";
    private static final String API_PERSIST_ALL_PATTERN = "/api/v[0-9]+/persist.*";
    private static final String API_LDAP_SYNC_EVENTS_ALL_PATTERN = "/api/v[0-9]+/ldap_sync_events.*";
    private static final String API_CREDENTIALS_ALL_PATTERN = "/api/v[0-9]+/clusters/.*?/credentials.*";
    private static final String API_CREDENTIALS_AMBARI_PATTERN = "/api/v[0-9]+/clusters/.*?/credentials/ambari\\..*";
    private static final String API_CLUSTER_REQUESTS_ALL_PATTERN = "/api/v[0-9]+/clusters/.*?/requests.*";
    private static final String API_CLUSTER_SERVICES_ALL_PATTERN = "/api/v[0-9]+/clusters/.*?/services.*";
    private static final String API_CLUSTER_ALERT_ALL_PATTERN = "/api/v[0-9]+/clusters/.*?/alert.*";
    private static final String API_CLUSTER_HOSTS_ALL_PATTERN = "/api/v[0-9]+/clusters/.*?/hosts.*";
    private static final String API_CLUSTER_CONFIGURATIONS_ALL_PATTERN = "/api/v[0-9]+/clusters/.*?/configurations.*";
    private static final String API_CLUSTER_COMPONENTS_ALL_PATTERN = "/api/v[0-9]+/clusters/.*?/components.*";
    private static final String API_CLUSTER_HOST_COMPONENTS_ALL_PATTERN = "/api/v[0-9]+/clusters/.*?/host_components.*";
    private static final String API_CLUSTER_CONFIG_GROUPS_ALL_PATTERN = "/api/v[0-9]+/clusters/.*?/config_groups.*";
    private static final String API_STACK_VERSIONS_PATTERN = "/api/v[0-9]+/stacks/.*?/versions/.*";
    private static final String API_HOSTS_ALL_PATTERN = "/api/v[0-9]+/hosts.*";
    private static final String API_ALERT_TARGETS_ALL_PATTERN = "/api/v[0-9]+/alert_targets.*";
    private static final String API_BOOTSTRAP_PATTERN_ALL = "/api/v[0-9]+/bootstrap.*";
    private static final String API_REQUESTS_ALL_PATTERN = "/api/v[0-9]+/requests.*";
    private static final String API_CLUSTERS_UPGRADES_PATTERN = "/api/v[0-9]+/clusters/.*?/upgrades.*";
    protected static final String LOGIN_REDIRECT_BASE = "/#/login?targetURI=";
    private final AmbariEntryPoint entryPoint;
    private final Configuration configuration;
    private final Users users;
    private final AuditLogger auditLogger;
    private final PermissionHelper permissionHelper;
    private String realm;

    public OBDPAuthorizationFilter(AmbariEntryPoint entryPoint, Configuration configuration, Users users, AuditLogger auditLogger, PermissionHelper permissionHelper) {
        this.entryPoint = entryPoint;
        this.configuration = configuration;
        this.users = users;
        this.auditLogger = auditLogger;
        this.permissionHelper = permissionHelper;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.realm = OBDPAuthorizationFilter.getParameterValue(filterConfig, REALM_PARAM, DEFAULT_REALM);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        AuditEvent auditEvent;
        HttpServletResponse httpResponse;
        HttpServletRequest httpRequest;
        block19: {
            Authentication authentication;
            String requestURI;
            block18: {
                Authentication defaultAuthentication;
                httpRequest = (HttpServletRequest)request;
                httpResponse = (HttpServletResponse)response;
                requestURI = httpRequest.getRequestURI();
                SecurityContext context = this.getSecurityContext();
                authentication = context.getAuthentication();
                auditEvent = null;
                if ((authentication == null || authentication instanceof AnonymousAuthenticationToken) && (defaultAuthentication = this.getDefaultAuthentication()) != null) {
                    context.setAuthentication(defaultAuthentication);
                    authentication = defaultAuthentication;
                }
                if (authentication != null && !(authentication instanceof AnonymousAuthenticationToken) && authentication.isAuthenticated()) break block18;
                String token = httpRequest.getHeader(INTERNAL_TOKEN_HEADER);
                if (token != null) {
                    InternalAuthenticationToken internalAuthenticationToken = new InternalAuthenticationToken(token);
                    context.setAuthentication((Authentication)internalAuthenticationToken);
                    if (this.auditLogger.isEnabled()) {
                        LoginAuditEvent loginAuditEvent = (LoginAuditEvent)((LoginAuditEvent.LoginAuditEventBuilder)((LoginAuditEvent.LoginAuditEventBuilder)((LoginAuditEvent.LoginAuditEventBuilder)((LoginAuditEvent.LoginAuditEventBuilder)LoginAuditEvent.builder().withUserName(internalAuthenticationToken.getName())).withProxyUserName(AuthorizationHelper.getProxyUserName(internalAuthenticationToken))).withRemoteIp(RequestUtils.getRemoteAddress(httpRequest))).withRoles(this.permissionHelper.getPermissionLabels(authentication)).withTimestamp(System.currentTimeMillis())).build();
                        this.auditLogger.log(loginAuditEvent);
                    }
                    break block19;
                } else {
                    if (!requestURI.matches(VIEWS_CONTEXT_ALL_PATTERN)) {
                        this.entryPoint.commence(httpRequest, httpResponse, (AuthenticationException)new AuthenticationCredentialsNotFoundException("Missing authentication token"));
                        return;
                    }
                    String queryString = httpRequest.getQueryString();
                    String requestedURL = queryString == null ? requestURI : requestURI + "?" + queryString;
                    String redirectURL = httpResponse.encodeRedirectURL(LOGIN_REDIRECT_BASE + requestedURL);
                    httpResponse.sendRedirect(redirectURL);
                    return;
                }
            }
            if (!this.authorizationPerformedInternally(requestURI)) {
                boolean authorized = false;
                if (requestURI.matches(API_BOOTSTRAP_PATTERN_ALL)) {
                    authorized = AuthorizationHelper.isAuthorized(authentication, ResourceType.CLUSTER, null, EnumSet.of(RoleAuthorization.HOST_ADD_DELETE_HOSTS));
                } else {
                    for (GrantedAuthority grantedAuthority : authentication.getAuthorities()) {
                        if (!(grantedAuthority instanceof OBDPGrantedAuthority)) continue;
                        OBDPGrantedAuthority ambariGrantedAuthority = (OBDPGrantedAuthority)grantedAuthority;
                        PrivilegeEntity privilegeEntity = ambariGrantedAuthority.getPrivilegeEntity();
                        Integer permissionId = privilegeEntity.getPermission().getId();
                        if (permissionId.equals(1)) {
                            authorized = true;
                            break;
                        }
                        if (!"GET".equalsIgnoreCase(httpRequest.getMethod()) && requestURI.matches(API_CREDENTIALS_AMBARI_PATTERN)) {
                            if (!permissionId.equals(1)) continue;
                            authorized = true;
                            break;
                        }
                        if (requestURI.matches(API_CLUSTERS_ALL_PATTERN)) {
                            if (!permissionId.equals(2) && !permissionId.equals(3)) continue;
                            authorized = true;
                            break;
                        }
                        if (STACK_ADVISOR_REGEX.matcher(requestURI).matches()) {
                            if (!permissionId.equals(2) && !permissionId.equals(3)) continue;
                            authorized = true;
                            break;
                        }
                        if (requestURI.matches(API_VIEWS_ALL_PATTERN)) {
                            if (!permissionId.equals(4)) continue;
                            authorized = true;
                            break;
                        }
                        if (!requestURI.matches(API_AUTH_PATTERN) || !"POST".equalsIgnoreCase(httpRequest.getMethod())) continue;
                        authorized = true;
                        break;
                    }
                    boolean bl = authorized = authorized || httpRequest.getMethod().equals("GET") && !requestURI.matches(API_LDAP_SYNC_EVENTS_ALL_PATTERN);
                }
                if (!authorized) {
                    if (this.auditLogger.isEnabled()) {
                        auditEvent = ((AccessUnauthorizedAuditEvent.AccessUnauthorizedAuditEventBuilder)((AccessUnauthorizedAuditEvent.AccessUnauthorizedAuditEventBuilder)((AccessUnauthorizedAuditEvent.AccessUnauthorizedAuditEventBuilder)((AccessUnauthorizedAuditEvent.AccessUnauthorizedAuditEventBuilder)AccessUnauthorizedAuditEvent.builder().withHttpMethodName(httpRequest.getMethod()).withRemoteIp(RequestUtils.getRemoteAddress(httpRequest))).withResourcePath(httpRequest.getRequestURI()).withUserName(AuthorizationHelper.getAuthenticatedName())).withProxyUserName(AuthorizationHelper.getProxyUserName())).withTimestamp(System.currentTimeMillis())).build();
                        this.auditLogger.log(auditEvent);
                    }
                    httpResponse.setHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
                    httpResponse.sendError(403, "You do not have permissions to access this resource.");
                    httpResponse.flushBuffer();
                    return;
                }
            }
        }
        if (AuthorizationHelper.getAuthenticatedName() != null) {
            httpResponse.setHeader("User", AuthorizationHelper.getAuthenticatedName());
            if (this.auditLogger.isEnabled() && httpResponse.getStatus() == 403) {
                auditEvent = ((AccessUnauthorizedAuditEvent.AccessUnauthorizedAuditEventBuilder)((AccessUnauthorizedAuditEvent.AccessUnauthorizedAuditEventBuilder)((AccessUnauthorizedAuditEvent.AccessUnauthorizedAuditEventBuilder)((AccessUnauthorizedAuditEvent.AccessUnauthorizedAuditEventBuilder)AccessUnauthorizedAuditEvent.builder().withHttpMethodName(httpRequest.getMethod()).withRemoteIp(RequestUtils.getRemoteAddress(httpRequest))).withResourcePath(httpRequest.getRequestURI()).withUserName(AuthorizationHelper.getAuthenticatedName())).withProxyUserName(AuthorizationHelper.getProxyUserName())).withTimestamp(System.currentTimeMillis())).build();
                this.auditLogger.log(auditEvent);
            }
        }
        chain.doFilter(request, response);
    }

    private Authentication getDefaultAuthentication() {
        User user;
        String username;
        UsernamePasswordAuthenticationToken defaultUser = null;
        if (this.configuration != null && this.users != null && !StringUtils.isEmpty((String)(username = this.configuration.getDefaultApiAuthenticatedUser())) && (user = this.users.getUser(username)) != null) {
            Principal principal = new Principal(){

                @Override
                public String getName() {
                    return user.getUserName();
                }
            };
            defaultUser = new UsernamePasswordAuthenticationToken((Object)principal, null, this.users.getUserAuthorities(user.getUserName()));
        }
        return defaultUser;
    }

    private boolean authorizationPerformedInternally(String requestURI) {
        return requestURI.matches(API_USERS_ALL_PATTERN) || requestURI.matches(API_REQUESTS_ALL_PATTERN) || requestURI.matches(API_GROUPS_ALL_PATTERN) || requestURI.matches(API_CREDENTIALS_ALL_PATTERN) || requestURI.matches(API_PRIVILEGES_ALL_PATTERN) || requestURI.matches(API_CLUSTER_REQUESTS_ALL_PATTERN) || requestURI.matches(API_CLUSTER_SERVICES_ALL_PATTERN) || requestURI.matches(API_CLUSTER_ALERT_ALL_PATTERN) || requestURI.matches(API_CLUSTERS_PATTERN) || requestURI.matches(API_STACK_VERSIONS_PATTERN) || requestURI.matches(API_VIEWS_ALL_PATTERN) || requestURI.matches(VIEWS_CONTEXT_PATH_PATTERN) || requestURI.matches(API_WIDGET_LAYOUTS_PATTERN) || requestURI.matches(API_WIDGET_PATTERN) || requestURI.matches(API_CLUSTER_HOSTS_ALL_PATTERN) || requestURI.matches(API_CLUSTER_CONFIGURATIONS_ALL_PATTERN) || requestURI.matches(API_CLUSTER_COMPONENTS_ALL_PATTERN) || requestURI.matches(API_CLUSTER_HOST_COMPONENTS_ALL_PATTERN) || requestURI.matches(API_CLUSTER_CONFIG_GROUPS_ALL_PATTERN) || requestURI.matches(API_HOSTS_ALL_PATTERN) || requestURI.matches(API_ALERT_TARGETS_ALL_PATTERN) || requestURI.matches(API_PERSIST_ALL_PATTERN) || requestURI.matches(API_CLUSTERS_UPGRADES_PATTERN);
    }

    public void destroy() {
    }

    private static String getParameterValue(FilterConfig filterConfig, String parameterName, String defaultValue) {
        String value = filterConfig.getInitParameter(parameterName);
        if (value == null || value.length() == 0) {
            value = filterConfig.getServletContext().getInitParameter(parameterName);
        }
        return value == null || value.length() == 0 ? defaultValue : value;
    }

    SecurityContext getSecurityContext() {
        return SecurityContextHolder.getContext();
    }

    ViewRegistry getViewRegistry() {
        return ViewRegistry.getInstance();
    }
}

